/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.diagrams.design;

import org.eclipse.core.resources.IProject;
import ro.amiq.dvt.diagrams.DDiagram;
import ro.amiq.dvt.diagrams.netlist.utils.NLConfig;
import ro.amiq.dvt.diagrams.netlist.utils.NLUtils;
import ro.amiq.dvt.ui.trace.connections.model.TCNode;

public abstract class DTraceDiagram
implements DDiagram {
    private final IProject project;
    private final String title;
    private final String name;
    private final TCNode topNode;
    private final NLConfig config;

    protected DTraceDiagram(String name, TCNode topNode, NLConfig config) {
        this.project = topNode.namedElement != null && topNode.namedElement.getRfProject() != null ? topNode.namedElement.getRfProject().getProject() : null;
        this.title = NLUtils.getDesignNLLabel(topNode.namedElement, NLUtils.getNLDesign(topNode), null).replace("\n", " ");
        this.name = name;
        this.topNode = topNode;
        this.config = config;
    }

    @Override
    public IProject getProject() {
        return this.project;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public TCNode getTopNode() {
        return this.topNode;
    }

    public NLConfig getConfig() {
        return this.config;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.project == null ? 0 : this.project.hashCode());
        result = 31 * result + (this.title == null ? 0 : this.title.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.topNode == null ? 0 : this.topNode.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DTraceDiagram other = (DTraceDiagram)obj;
        if (this.project == null ? other.project != null : !this.project.equals((Object)other.project)) {
            return false;
        }
        if (this.title == null ? other.title != null : !this.title.equals(other.title)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.topNode == null ? other.topNode != null : !this.topNode.equals(other.topNode));
    }
}

