/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.diagrams.design.block;

import com.google.common.base.Objects;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import ro.amiq.dvt.diagrams.DProgressMonitor;
import ro.amiq.dvt.diagrams.exceptions.DCanceledException;
import ro.amiq.dvt.draw.obj.base.DGroup;
import ro.amiq.dvt.draw.obj.primitive.DHeadClosedArrow;
import ro.amiq.dvt.draw.obj.primitive.DLine;
import ro.amiq.dvt.draw.obj.primitive.DOval;
import ro.amiq.dvt.draw.obj.primitive.DPolygon;
import ro.amiq.dvt.draw.obj.primitive.DRectangle;
import ro.amiq.dvt.draw.obj.primitive.DText;
import ro.amiq.dvt.draw.utils.ColorFactory;
import ro.amiq.dvt.draw.utils.FontFactory;
import ro.amiq.dvt.model.reflection.IRfDesignElement;
import ro.amiq.dvt.model.reflection.IRfFieldElement;
import ro.amiq.dvt.model.reflection.IRfInstanceElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfPortElement;

public enum BlockDiagram2Engine {
    INSTANCE;

    public static final RGB BLACK;
    public static final RGB WHITE;
    public static final RGB GREY;
    public static final RGB DARK_GREY;
    public static final RGB VANILLA;
    public static final RGB DEEP_BLUE;
    private static final String FONT_NAME = "Ubuntu Mono";
    private static final int LABEL_FONT_SIZE = 13;
    private static final FontData LABEL_FONT_DATA;
    private static final Point LABEL_FONT_EM_SIZE;
    private static final int Y_PAD = 10;
    private static final int X_PAD = 10;
    private static final int SPACING = 10;
    private static final int LABEL_H;
    private static final int LABEL_Y_OFF;
    private static final int LABEL_X_PAD;
    private static final int PIN_W;
    private static final int PIN_Y_OFF;

    static {
        BLACK = ColorFactory.getInstance().getRGB(0, 0, 0);
        WHITE = ColorFactory.getInstance().getRGB(255, 255, 255);
        GREY = ColorFactory.getInstance().getRGB(200, 200, 200);
        DARK_GREY = ColorFactory.getInstance().getRGB(100, 100, 100);
        VANILLA = ColorFactory.getInstance().getRGB(255, 243, 176);
        DEEP_BLUE = ColorFactory.getInstance().getRGB(36, 114, 164);
        LABEL_FONT_DATA = FontFactory.getInstance().getFontData(FONT_NAME, 13, 0);
        LABEL_FONT_EM_SIZE = FontFactory.getInstance().emSize(LABEL_FONT_DATA);
        LABEL_H = (int)((float)BlockDiagram2Engine.LABEL_FONT_EM_SIZE.y * 1.5f);
        LABEL_Y_OFF = (LABEL_H - BlockDiagram2Engine.LABEL_FONT_EM_SIZE.y) / 2;
        LABEL_X_PAD = BlockDiagram2Engine.LABEL_FONT_EM_SIZE.x;
        PIN_W = (int)((float)BlockDiagram2Engine.LABEL_FONT_EM_SIZE.x * 2.5f);
        PIN_Y_OFF = LABEL_H / 2;
    }

    public DGroup makeBlockDiagram2(IRfNamedElement namedElement, DProgressMonitor monitor) throws DCanceledException {
        IRfDesignElement designElement = this.getDesignElement(namedElement);
        if (designElement == null) {
            throw new IllegalArgumentException();
        }
        List<Element> paramElements = this.getParamElements(designElement);
        List<Element> portElements = this.getPortElements(designElement);
        monitor.checkCanceled();
        return this.makeScene(designElement.getName(), paramElements, portElements);
    }

    private IRfDesignElement getDesignElement(IRfNamedElement namedElement) {
        IRfDesignElement designElement = null;
        if (namedElement instanceof IRfDesignElement) {
            designElement = (IRfDesignElement)namedElement;
        }
        if (namedElement instanceof IRfInstanceElement) {
            designElement = ((IRfInstanceElement)namedElement).getInstantiatedDesign();
        }
        return designElement;
    }

    private List<Element> getPortElements(IRfDesignElement designElement) {
        List<? extends IRfPortElement> localPorts = designElement.getLocalPorts();
        if (localPorts == null) {
            return Collections.emptyList();
        }
        LinkedList<Element> portElements = new LinkedList<Element>();
        for (IRfPortElement iRfPortElement : localPorts) {
            String type = iRfPortElement.getAssociatedTypeName(true);
            String range = "";
            if (type != null && type.contains("[")) {
                int idx = type.indexOf(91);
                range = type.substring(idx);
                type = type.substring(0, idx);
            } else {
                range = iRfPortElement.getRange();
            }
            portElements.add(new Element(iRfPortElement.getDeclarationIndex(), iRfPortElement.getName(), iRfPortElement.getDirectionString(), type, range));
        }
        portElements.sort((o1, o2) -> Integer.compare(o1.index, o2.index));
        return portElements;
    }

    private List<Element> getParamElements(IRfDesignElement designElement) {
        List<Element> paramElements = designElement.getLocalParameters().stream().filter(p -> p instanceof IRfFieldElement && ((IRfFieldElement)p).isRegularParameter()).map(p -> new Element(p.getDeclarationIndex(), p.getName())).sorted((o1, o2) -> Integer.compare(o1.index, o2.index)).collect(Collectors.toList());
        return paramElements;
    }

    private DRectangle createBlock(int x, int y, int width, int height, RGB color, RGB borderColor) {
        DRectangle rectangle = new DRectangle(x, y, width, height);
        rectangle.setFillColor(color);
        rectangle.setLineAutoScale(true);
        rectangle.setLineWidth(3);
        rectangle.setLineColor(borderColor);
        rectangle.setLineJoin(1);
        return rectangle;
    }

    private DGroup makeScene(String name, List<Element> block1Elem, List<Element> block2Elem) {
        AtomicInteger index;
        int leftBlock1Labels = (int)block1Elem.stream().filter(e -> e.side == Side.LEFT).count();
        int rightBlock1Labels = block1Elem.size() - leftBlock1Labels;
        int leftBlock2Labels = (int)block2Elem.stream().filter(e -> e.side == Side.LEFT).count();
        int rightBlock2Labels = block2Elem.size() - leftBlock2Labels;
        int maxBlock1Labels = Math.max(leftBlock1Labels, rightBlock1Labels);
        int maxBlock2Labels = Math.max(leftBlock2Labels, rightBlock2Labels);
        int maxBlock1NameW = block1Elem.stream().mapToInt(e -> e.name.length()).max().orElse(0) * BlockDiagram2Engine.LABEL_FONT_EM_SIZE.x;
        int maxBlock2NameW = block2Elem.stream().mapToInt(e -> e.name.length()).max().orElse(0) * BlockDiagram2Engine.LABEL_FONT_EM_SIZE.x;
        int maxTypeW = Stream.concat(block1Elem.stream(), block2Elem.stream()).mapToInt(e -> e.type.length() + e.range.length()).max().getAsInt() * BlockDiagram2Engine.LABEL_FONT_EM_SIZE.x;
        int blockW = Math.max((LABEL_X_PAD + maxBlock2NameW + LABEL_X_PAD) * 2 + 10, LABEL_X_PAD + maxBlock1NameW + LABEL_X_PAD);
        int blockYSpacing = block1Elem.isEmpty() || block2Elem.isEmpty() ? 0 : 10;
        int sceneW = (10 + LABEL_X_PAD + maxTypeW + LABEL_X_PAD + PIN_W) * 2 + blockW;
        int sceneH = 10 + (maxBlock1Labels + maxBlock2Labels) * LABEL_H + blockYSpacing + 10;
        int blockX1 = (sceneW - blockW) / 2;
        int blockX2 = (sceneW + blockW) / 2;
        int block1Y1 = 10;
        int block1H = maxBlock1Labels * LABEL_H;
        int block2Y1 = block1Y1 + block1H + blockYSpacing;
        int block2H = maxBlock2Labels * LABEL_H;
        DBlockScene scene = new DBlockScene(new Rectangle(0, 0, sceneW, sceneH));
        if (!block1Elem.isEmpty()) {
            scene.addChild(this.createBlock(blockX1, block1Y1, blockW, block1H, GREY, DARK_GREY));
            index = new AtomicInteger();
            block1Elem.stream().filter(e -> e.side == Side.LEFT).forEach(e -> {
                int elemY = block1Y1 + index.get() * LABEL_H;
                scene.addChild(new DLabel(e.name, BLACK, false, blockX1, elemY + LABEL_Y_OFF));
                scene.addChild(new DPin(true, e.isBus, e.pin, blockX1, elemY + PIN_Y_OFF));
                index.incrementAndGet();
            });
        }
        if (!block2Elem.isEmpty()) {
            scene.addChild(this.createBlock(blockX1, block2Y1, blockW, block2H, VANILLA, BLACK));
            index = new AtomicInteger();
            index.set(0);
            block2Elem.stream().filter(e -> e.side == Side.LEFT).forEach(e -> {
                int elemY = block2Y1 + index.get() * LABEL_H;
                scene.addChild(new DLabel(e.name, BLACK, false, blockX1, elemY + LABEL_Y_OFF));
                scene.addChild(new DPin(true, e.isBus, e.pin, blockX1, elemY + PIN_Y_OFF));
                scene.addChild(new DLabel(e.range, DEEP_BLUE, true, blockX1 - PIN_W, elemY + LABEL_Y_OFF));
                scene.addChild(new DLabel(e.type, DARK_GREY, true, blockX1 - PIN_W - e.range.length() * BlockDiagram2Engine.LABEL_FONT_EM_SIZE.x, elemY + LABEL_Y_OFF));
                index.incrementAndGet();
            });
            index.set(0);
            block2Elem.stream().filter(e -> e.side == Side.RIGHT).forEach(e -> {
                int elemY = block2Y1 + index.get() * LABEL_H;
                scene.addChild(new DLabel(e.name, BLACK, true, blockX2, elemY + LABEL_Y_OFF));
                scene.addChild(new DPin(false, e.isBus, e.pin, blockX2, elemY + PIN_Y_OFF));
                scene.addChild(new DLabel(e.type, DARK_GREY, false, blockX2 + PIN_W, elemY + LABEL_Y_OFF));
                scene.addChild(new DLabel(e.range, DEEP_BLUE, false, blockX2 + PIN_W + e.type.length() * BlockDiagram2Engine.LABEL_FONT_EM_SIZE.x, elemY + LABEL_Y_OFF));
                index.incrementAndGet();
            });
        }
        return scene;
    }

    private static class DBlockScene
    extends DGroup {
        private final Rectangle bounds;

        public DBlockScene(Rectangle bounds) {
            super("scene");
            this.bounds = bounds;
        }

        @Override
        public Rectangle getBounds() {
            return this.bounds;
        }
    }

    private static class DLabel
    extends DGroup {
        public DLabel(String label, RGB color, boolean rtl, int x, int y) {
            DText text = null;
            if (rtl) {
                Point textSize = FontFactory.getInstance().stringExtent(label, LABEL_FONT_DATA);
                text = new DText(label, x - LABEL_X_PAD - textSize.x, y, LABEL_FONT_DATA);
            } else {
                text = new DText(label, x + LABEL_X_PAD, y, LABEL_FONT_DATA);
            }
            text.setTextColor(color);
            this.addChild(text);
        }
    }

    private static class DPin
    extends DGroup {
        public DPin(boolean rtl, boolean isBus, Pin pin, int x, int y) {
            this.addChild(this.createWire(rtl, isBus, pin != Pin.SIMPLE && pin != Pin.CLOCK, pin == Pin.IO, x, y));
            if (pin == Pin.IO) {
                this.addChild(this.createArrow(rtl, 1, isBus, x, y));
                this.addChild(this.createArrow(rtl, -1, isBus, x + PIN_W, y));
            } else if (pin == Pin.CLOCK) {
                this.addChild(this.createTriangle(rtl, x, y));
            } else if (pin == Pin.NEG) {
                this.addChild(this.createCircle(rtl, x, y));
            }
        }

        private DPolygon createTriangle(boolean rtl, int x, int y) {
            int off = rtl ? 6 : -6;
            DHeadClosedArrow triangle = new DHeadClosedArrow(8, x + off, y, x, y);
            triangle.setFillColor(WHITE);
            return triangle;
        }

        private DOval createCircle(boolean rtl, int x, int y) {
            int off = rtl ? 4 : -4;
            DOval circle = new DOval(6, x - off, y);
            circle.setFillColor(WHITE);
            return circle;
        }

        private DPolygon createArrow(boolean rtl, int dir, boolean isBus, int x, int y) {
            int off = rtl ? -PIN_W : 0;
            int size = isBus ? 6 : 4;
            DHeadClosedArrow arrow = new DHeadClosedArrow(size, x + off + dir, y, x + off + dir * 6, y);
            arrow.setFillColor(BLACK);
            return arrow;
        }

        private DLine createWire(boolean rtl, boolean isBus, boolean trimClose, boolean trimFar, int x, int y) {
            int off = rtl ? -PIN_W : 0;
            int trimStart = rtl && trimFar || !rtl && trimClose ? 3 : 0;
            int trimEnd = rtl && trimClose || !rtl && trimFar ? -3 : 0;
            int width = isBus ? 3 : 1;
            DLine line = new DLine(new int[]{x + off + trimStart, y, x + off + PIN_W + trimEnd, y});
            line.setLineCap(3);
            line.setLineWidth(width);
            return line;
        }
    }

    private static class Element {
        private static final Pattern CLOCK_PATTERN = Pattern.compile("(^cl(oc)?k_.*)|(.*_cl(oc)?k$)");
        private static final Pattern NEG_PATTERN = Pattern.compile(".*_[nb]$");
        private final int index;
        private final String name;
        private final String type;
        private final String range;
        private final Side side;
        private final boolean isBus;
        private final Pin pin;

        public Element(int index, String name, String direction, String type, String range) {
            if (name == null) {
                throw new IllegalArgumentException();
            }
            if (direction == null) {
                direction = "";
            }
            if (type == null) {
                type = "";
            }
            if (range == null) {
                range = "";
            }
            if (!range.isEmpty() && !range.startsWith("[")) {
                range = "[" + range + "]";
            }
            if ((type = type.replace(range, "").replace("wire", "").replace("var", "").trim()).isEmpty()) {
                type = "logic";
            }
            this.index = index;
            this.name = name;
            this.range = range;
            this.type = type;
            this.side = Objects.equal((Object)direction.toLowerCase(), (Object)"in") || Objects.equal((Object)direction.toLowerCase(), (Object)"input") ? Side.LEFT : Side.RIGHT;
            boolean bl = this.isBus = !range.isEmpty();
            this.pin = Objects.equal((Object)direction.toLowerCase(), (Object)"inout") ? Pin.IO : (CLOCK_PATTERN.matcher(name).matches() ? Pin.CLOCK : (NEG_PATTERN.matcher(name).matches() ? Pin.NEG : Pin.SIMPLE));
        }

        public Element(int index, String name) {
            if (name == null) {
                throw new IllegalArgumentException();
            }
            this.index = index;
            this.name = name;
            this.type = "";
            this.range = "";
            this.side = Side.LEFT;
            this.isBus = false;
            this.pin = Pin.SIMPLE;
        }
    }

    private static enum Pin {
        SIMPLE,
        IO,
        CLOCK,
        NEG;

    }

    private static enum Side {
        LEFT,
        RIGHT;

    }
}

