/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.diagrams.design.editor;

import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.jface.action.IAction;
import ro.amiq.dvt.diagrams.design.editor.DDesignEditorContributorsCommon;
import ro.amiq.dvt.diagrams.design.editor.actions.DDesignFiltersDialog;
import ro.amiq.dvt.diagrams.design.editor.actions.DDesignPreferencesDialog;
import ro.amiq.dvt.diagrams.design.editor.actions.menu.DShowConnectionsAroundMenuAction;
import ro.amiq.dvt.diagrams.design.editor.actions.menu.DShowDestinationMenuAction;
import ro.amiq.dvt.diagrams.design.editor.actions.menu.DShowSourceMenuAction;
import ro.amiq.dvt.diagrams.editor.DDiagramEditor;
import ro.amiq.dvt.diagrams.editor.DMessages;
import ro.amiq.dvt.diagrams.editor.actions.DHideSideEffectsAction;
import ro.amiq.dvt.diagrams.editor.actions.DRefreshAction;
import ro.amiq.dvt.diagrams.editor.utils.DEditorToolbarDialogAction;
import ro.amiq.dvt.draw.obj.interaction.DSelectable;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.DVTImages;

public class DDesignEditorContributors
extends DDesignEditorContributorsCommon {
    public static Set<IAction> getNamedElementDiagramToolbarActions(DDiagramEditor diagramEditor) {
        LinkedHashSet<IAction> actions = new LinkedHashSet<IAction>();
        actions.add((IAction)new DEditorToolbarDialogAction(diagramEditor, DMessages.DiagramPanel_Preferences_Button_TT, DVTImages.IMG_TAB_GRAPHVIZ_PREFERENCES, DDesignPreferencesDialog::new));
        actions.add((IAction)new DEditorToolbarDialogAction(diagramEditor, DMessages.DiagramPanel_Filters_Button_TT, DVTImages.FILTER, DDesignFiltersDialog::new));
        actions.add((IAction)new DRefreshAction(diagramEditor));
        return actions;
    }

    public static Set<IAction> getTraceDiagramToolbarActions(DDiagramEditor diagramEditor) {
        LinkedHashSet<IAction> actions = new LinkedHashSet<IAction>();
        actions.add((IAction)new DEditorToolbarDialogAction(diagramEditor, "Filters...", DVTImages.FILTER, DDesignFiltersDialog::new));
        if (DVTLogger.INSTANCE.isDebugMode()) {
            actions.add((IAction)new DRefreshAction(diagramEditor));
        }
        return actions;
    }

    public static Set<IAction> getRefactoringConnectToolbarActions(DDiagramEditor diagramEditor) {
        LinkedHashSet<IAction> actions = new LinkedHashSet<IAction>();
        actions.add((IAction)new DHideSideEffectsAction(diagramEditor));
        return actions;
    }

    public static Set<IAction> getPFDiagramToolbarActions(DDiagramEditor diagramEditor) {
        LinkedHashSet<IAction> actions = new LinkedHashSet<IAction>();
        if (DVTLogger.INSTANCE.isDebugMode()) {
            actions.add((IAction)new DRefreshAction(diagramEditor));
        }
        return actions;
    }

    public static Runnable getMKCActions(DDiagramEditor diagramEditor, Set<DSelectable> selection, int button, int stateMask, Set<Integer> keyCodes) {
        if (button != 1) {
            return null;
        }
        if (stateMask != 0) {
            return null;
        }
        if (keyCodes.size() != 1) {
            return null;
        }
        for (Integer keyCode : keyCodes) {
            if (keyCode == 115) {
                DShowSourceMenuAction showSource = new DShowSourceMenuAction(selection, diagramEditor.getInput().getDiagram());
                if (!showSource.isVisible()) {
                    return null;
                }
                return showSource::run;
            }
            if (keyCode == 100) {
                DShowDestinationMenuAction showDestination = new DShowDestinationMenuAction(selection, diagramEditor.getInput().getDiagram());
                if (!showDestination.isVisible()) {
                    return null;
                }
                return showDestination::run;
            }
            if (keyCode != 99) continue;
            DShowConnectionsAroundMenuAction showConnections = new DShowConnectionsAroundMenuAction(selection, diagramEditor.getInput().getDiagram());
            if (!showConnections.isVisible()) {
                return null;
            }
            return showConnections::run;
        }
        return null;
    }
}

