/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.diagrams.design.editor;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ro.amiq.dvt.diagrams.DDiagram;
import ro.amiq.dvt.diagrams.design.DTopPathDiagram;
import ro.amiq.dvt.diagrams.design.editor.actions.menu.DMenuActionFactory;
import ro.amiq.dvt.diagrams.design.editor.actions.menu.DMenuActionKind;
import ro.amiq.dvt.diagrams.editor.DDiagramEditor;
import ro.amiq.dvt.diagrams.editor.DMenuItem;
import ro.amiq.dvt.diagrams.editor.DSelectionContributor;
import ro.amiq.dvt.diagrams.klay.utils.KLayDrawUtils;
import ro.amiq.dvt.draw.obj.base.DObject;
import ro.amiq.dvt.draw.obj.design.DDesignObject;
import ro.amiq.dvt.draw.obj.design.DDesignScene;
import ro.amiq.dvt.draw.obj.design.DEdge;
import ro.amiq.dvt.draw.obj.design.DLabel;
import ro.amiq.dvt.draw.obj.interaction.DSelectable;

public abstract class DDesignEditorContributorsCommon {
    private static final List<DMenuActionKind> MENU_PATTERN = Arrays.asList(DMenuActionKind.STEP_INTO, DMenuActionKind.SHOW_DESTINATIONS, DMenuActionKind.SHOW_SOURCES, DMenuActionKind.SEPARATOR, DMenuActionKind.EXPAND, DMenuActionKind.COLLAPSE, DMenuActionKind.SEPARATOR, DMenuActionKind.GO_TO_SOURCE, DMenuActionKind.GO_TO_DECLARATION, DMenuActionKind.SEPARATOR, DMenuActionKind.SHOW_CONNECTIONS, DMenuActionKind.SHOW_CONNECTIONS_BETWEEN, DMenuActionKind.SHOW_CONNECTIONS_BETWEEN_FLOW_TO_SCHEMATIC, DMenuActionKind.SEPARATOR, DMenuActionKind.TRACE_DRIVE_AND_LOAD, DMenuActionKind.SEPARATOR, DMenuActionKind.DELETE, DMenuActionKind.SEPARATOR, DMenuActionKind.SHOW_IN_PF_DIAGRAM);
    private static final List<DMenuActionKind> MENU_SHALLOW_ELABORATION_PATTERN = Arrays.asList(DMenuActionKind.GO_TO_SOURCE, DMenuActionKind.GO_TO_DECLARATION, DMenuActionKind.SEPARATOR, DMenuActionKind.DELETE);

    public static Map<String, Set<DSelectable>> getSelectedObjects(DDiagramEditor diagramEditor, DSelectable object) {
        DObject content = diagramEditor.getCanvas().getContent();
        if (content instanceof DDesignScene && object instanceof DEdge.DSelectableEdge) {
            return DSelectionContributor.createMainSelection(KLayDrawUtils.getEdgeConnections((DDesignScene)content, (DEdge.DSelectableEdge)object));
        }
        if (object instanceof DLabel.DSelectableLabel) {
            HashSet<DSelectable> selectables = new HashSet<DSelectable>();
            DLabel.DSelectableLabel selectableLabel = (DLabel.DSelectableLabel)object;
            DDesignObject connectedObject = selectableLabel.getConnectedDesignObject();
            if (connectedObject instanceof DEdge.DSelectableEdge) {
                selectables.add((DSelectable)((Object)connectedObject));
                selectables.add(selectableLabel);
            } else if (KLayDrawUtils.isChildOfImplicitGate(connectedObject)) {
                selectables.add(KLayDrawUtils.getParent((DDesignScene)content, connectedObject));
            } else if (connectedObject != null && connectedObject.getChildren() != null) {
                List<DObject> children = connectedObject.getChildren();
                for (DObject child : children) {
                    if (!(child instanceof DLabel.DSelectableLabel)) continue;
                    selectables.add((DLabel.DSelectableLabel)child);
                }
            }
            return DSelectionContributor.createMainSelection(selectables);
        }
        return DSelectionContributor.createMainSelection(object);
    }

    public static List<DMenuItem> getMenuItems(DDiagramEditor diagramEditor, Set<DSelectable> selection) {
        DDiagram diagram = diagramEditor.getInput().getDiagram();
        List<DMenuActionKind> pattern = diagram instanceof DTopPathDiagram && ((DTopPathDiagram)diagram).isOnlyShallowElaboration() ? MENU_SHALLOW_ELABORATION_PATTERN : MENU_PATTERN;
        return DMenuActionFactory.getInstance().createActions(pattern, selection, diagram);
    }

    public static DObject[] getFocusedObjects(DDiagramEditor diagramEditor, DObject content) {
        return KLayDrawUtils.getPreviousActionElements(content);
    }
}

