/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.diagrams.design.editor;

import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import ro.amiq.dvt.DVTRefactorConnectWizardInput;
import ro.amiq.dvt.diagrams.DDiagram;
import ro.amiq.dvt.diagrams.DNamedElementDiagram;
import ro.amiq.dvt.diagrams.design.DActionFlowDiagram;
import ro.amiq.dvt.diagrams.design.DActionOnPortSchematicDiagram;
import ro.amiq.dvt.diagrams.design.DActionSchematicDiagram;
import ro.amiq.dvt.diagrams.design.DBlockDiagram;
import ro.amiq.dvt.diagrams.design.DFlowDiagram;
import ro.amiq.dvt.diagrams.design.DPFDiagram;
import ro.amiq.dvt.diagrams.design.DRefactoringConnectDiagram;
import ro.amiq.dvt.diagrams.design.DRefactoringDiagram;
import ro.amiq.dvt.diagrams.design.DSchematicDiagram;
import ro.amiq.dvt.diagrams.design.DTraceAllDiagram;
import ro.amiq.dvt.diagrams.design.DTraceDiagram;
import ro.amiq.dvt.diagrams.design.DTracePathDiagram;
import ro.amiq.dvt.diagrams.design.editor.DDesignEditorContributors;
import ro.amiq.dvt.diagrams.design.editor.DDesignEditorContributorsCommon;
import ro.amiq.dvt.diagrams.design.editor.DDesignEditorFactoryCommon;
import ro.amiq.dvt.diagrams.editor.DDiagramEditor;
import ro.amiq.dvt.diagrams.editor.DDiagramEditorInput;
import ro.amiq.dvt.diagrams.editor.DFocusContributor;
import ro.amiq.dvt.diagrams.editor.DMKCContributor;
import ro.amiq.dvt.diagrams.editor.DMenuContributor;
import ro.amiq.dvt.diagrams.editor.DSelectionContributor;
import ro.amiq.dvt.diagrams.editor.DToolbarContributor;
import ro.amiq.dvt.diagrams.editor.DTransitionTableContributor;
import ro.amiq.dvt.diagrams.netlist.model.NLAbstractBase;
import ro.amiq.dvt.diagrams.netlist.utils.NLConfig;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfPortElement;
import ro.amiq.dvt.test.TestHelper;
import ro.amiq.dvt.ui.Utils;
import ro.amiq.dvt.ui.refactor.connect.RefactorInputWrapper;
import ro.amiq.dvt.ui.refactor.rename.PreviewDiagramInfo;
import ro.amiq.dvt.ui.trace.connections.model.TCEndSet;
import ro.amiq.dvt.ui.trace.connections.model.TCNode;
import ro.amiq.dvt.ui.trace.connections.model.TCPathChain;
import ro.amiq.dvt.ui.trace.connections.model.TCPathPoint;
import ro.amiq.dvt.ui.trace.connections.model.TCPathRedundance;
import ro.amiq.dvt.ui.trace.connections.utils.TCOperation;

public class DDesignEditorFactory
extends DDesignEditorFactoryCommon {
    private static DDesignEditorFactory INSTANCE;
    private static final Object SYNC_OBJECT;

    static {
        SYNC_OBJECT = new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DDesignEditorFactory getInstance() {
        if (INSTANCE == null) {
            Object object = SYNC_OBJECT;
            synchronized (object) {
                INSTANCE = new DDesignEditorFactory();
            }
        }
        return INSTANCE;
    }

    public DDesignEditorFactory() {
    }

    public DDesignEditorFactory(DDiagram diagram) {
        this.diagram = diagram;
    }

    @Override
    public DDesignEditorFactory newBlockDiagram(IRfNamedElement namedElement, NLConfig config, ElementPath topPath) {
        return new DDesignEditorFactory(new DBlockDiagram(namedElement, config != null ? config : new NLConfig(this.getDefaultNLConfiguration()), topPath));
    }

    @Override
    public DDesignEditorFactory newFlowDiagram(IRfNamedElement namedElement, NLConfig config, ElementPath topPath) {
        return new DDesignEditorFactory(new DFlowDiagram(namedElement, config != null ? config : new NLConfig(this.getDefaultNLConfiguration()), topPath, true));
    }

    @Override
    public DDesignEditorFactory newSchematicDiagram(IRfNamedElement namedElement, NLConfig config, ElementPath topPath) {
        return this.newSchematicDiagram(1, namedElement, config, topPath);
    }

    @Override
    public DDesignEditorFactory newSchematicDiagram(int depth, IRfNamedElement namedElement, NLConfig config, ElementPath topPath) {
        return new DDesignEditorFactory(new DSchematicDiagram(depth, namedElement, config != null ? config : new NLConfig(this.getDefaultNLConfiguration()), topPath, true));
    }

    @Override
    public DDesignEditorFactory newActionFlowDiagram(IRfNamedElement namedElement, NLConfig config, ElementPath topPath) {
        return new DDesignEditorFactory(new DActionFlowDiagram(namedElement, config != null ? config : new NLConfig(this.getDefaultNLConfiguration()), topPath));
    }

    @Override
    public DDesignEditorFactory newActionFlowDiagram(IRfNamedElement namedElement, NLConfig config, ElementPath topPath, List<NLAbstractBase> copyElements) {
        return new DDesignEditorFactory(new DActionFlowDiagram(namedElement, config != null ? config : new NLConfig(this.getDefaultNLConfiguration()), topPath, copyElements));
    }

    @Override
    public DDesignEditorFactory newActionDiagram(int depth, IRfNamedElement namedElement, NLConfig config, ElementPath topPath) {
        return new DDesignEditorFactory(new DActionSchematicDiagram(depth, namedElement, config != null ? config : new NLConfig(this.getDefaultNLConfiguration()), topPath));
    }

    @Override
    public DDesignEditorFactory newActionDiagram(int depth, IRfNamedElement namedElement, NLConfig config, ElementPath topPath, List<NLAbstractBase> copyElements) {
        return new DDesignEditorFactory(new DActionSchematicDiagram(depth, namedElement, config != null ? config : new NLConfig(this.getDefaultNLConfiguration()), topPath, copyElements));
    }

    public DDesignEditorFactory newActionOnPortDiagram(int depth, IRfNamedElement namedElement, IRfNamedElement portParent, IRfPortElement port, NLConfig config, ElementPath topPath) {
        return new DDesignEditorFactory(new DActionOnPortSchematicDiagram(depth, namedElement, portParent, port, config, topPath));
    }

    public DDesignEditorFactory newTraceAllDiagram(String name, TCNode topNode, TCPathPoint startPoint, TCEndSet sources, TCPathChain driveCausedBy, TCPathRedundance driveRedundance, TCEndSet destinations, TCPathChain loadCausedBy, TCPathRedundance loadRedundance, TCOperation operation, NLConfig config) {
        return new DDesignEditorFactory(new DTraceAllDiagram(name, topNode, startPoint, sources, driveCausedBy, driveRedundance, destinations, loadCausedBy, loadRedundance, operation, config != null ? config : new NLConfig(this.getDefaultNLConfiguration())));
    }

    public DDesignEditorFactory newTracePathDiagram(String name, TCNode topNode, TCPathPoint point, TCEndSet sources, TCPathChain driveCausedBy, TCEndSet destinations, TCPathChain loadCausedBy, TCPathPoint startPoint, TCOperation operation, NLConfig config) {
        return new DDesignEditorFactory(new DTracePathDiagram(name, topNode, point, sources, driveCausedBy, destinations, loadCausedBy, startPoint, operation, config != null ? config : new NLConfig(this.getDefaultNLConfiguration())));
    }

    public DDesignEditorFactory newPowerDomainsDiagram(IProject project, NLConfig config) {
        return new DDesignEditorFactory(new DPFDiagram(project, config != null ? config : new NLConfig(this.getDefaultNLConfiguration()), null));
    }

    public DDesignEditorFactory newPowerDomainsDiagramWithSelection(IProject project, NLConfig config, Set<String> selectedPDs) {
        return new DDesignEditorFactory(new DPFDiagram(project, config != null ? config : new NLConfig(this.getDefaultNLConfiguration()), selectedPDs));
    }

    public DDesignEditorFactory newRefactoringDiagram(IProject project, PreviewDiagramInfo refactoringInfo) {
        return new DDesignEditorFactory(new DRefactoringDiagram(project, new NLConfig(this.getDefaultNLConfiguration()), refactoringInfo));
    }

    public DDesignEditorFactory newRefactoringConnectDiagram(IProject project, Set<RefactorInputWrapper> targetElement, DVTRefactorConnectWizardInput info, String[] srcPath, String[] dstPath, IRfNamedElement srcPort, IRfNamedElement dstPort, String[] rootNode, boolean hideSideEffects) {
        return new DDesignEditorFactory(new DRefactoringConnectDiagram(project, new NLConfig(this.getDefaultNLConfiguration()), targetElement, info, srcPath, dstPath, srcPort, dstPort, rootNode, hideSideEffects));
    }

    @Override
    public DDiagramEditorInput createEditorInput(DDiagram diagram) {
        DSelectionContributor selectionContributor = DDesignEditorContributorsCommon::getSelectedObjects;
        DMenuContributor menuContributor = DDesignEditorContributorsCommon::getMenuItems;
        DFocusContributor miscContributor = DDesignEditorContributorsCommon::getFocusedObjects;
        DMKCContributor mkcContributor = DDesignEditorContributors::getMKCActions;
        DToolbarContributor toolbarContributor = null;
        toolbarContributor = diagram instanceof DNamedElementDiagram ? DDesignEditorContributors::getNamedElementDiagramToolbarActions : (diagram instanceof DPFDiagram ? DDesignEditorContributors::getPFDiagramToolbarActions : (diagram instanceof DRefactoringConnectDiagram ? DDesignEditorContributors::getRefactoringConnectToolbarActions : DDesignEditorContributors::getTraceDiagramToolbarActions));
        Runnable failedSchematicAction = diagram instanceof DSchematicDiagram ? this.newFailedSchematicAction((DSchematicDiagram)diagram) : null;
        DDiagramEditorInput diagramEditorInput = new DDiagramEditorInput(diagram, toolbarContributor, menuContributor, selectionContributor, DTransitionTableContributor.EMPTY, mkcContributor, miscContributor, failedSchematicAction);
        return diagramEditorInput;
    }

    public void closeDiagramTraceEditors() {
        DDiagramEditor.diagramEditorsAsStream().filter(editor -> editor.getInput().getDiagram() instanceof DTraceDiagram).forEach(editor -> {
            boolean bl = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().closeEditor((IEditorPart)editor, false);
        });
    }

    private Runnable newFailedSchematicAction(final DSchematicDiagram diagram) {
        if (diagram == null || diagram.getDepth() > 1) {
            return null;
        }
        String name = diagram.getTitle();
        return new DiagramFailedDialog(new Runnable(){

            @Override
            public void run() {
                DDesignEditorFactory.this.newFlowDiagram(diagram.getNamedElement(), null, diagram.getTopPath()).openEditor();
            }
        }, name);
    }

    private static class DiagramFailedDialog
    implements Runnable {
        private Runnable action;
        private MessageDialog dialog;

        public DiagramFailedDialog(Runnable action, String name) {
            this.action = action;
            this.dialog = new MessageDialog(Utils.getActiveShell(), "Diagram generation failed!", null, "Do you want to generate the flow diagram for '" + name + "'?", 3, new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL}, 0);
        }

        @Override
        public void run() {
            if (this.action == null) {
                return;
            }
            if (TestHelper.isTestMode()) {
                return;
            }
            Utils.safeRunAsynchInUIThread(new Runnable(){

                @Override
                public void run() {
                    if (dialog.open() == 0) {
                        action.run();
                    }
                }
            });
        }
    }
}

