/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.diagrams.design.editor.actions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import ro.amiq.dvt.diagrams.DDiagram;
import ro.amiq.dvt.diagrams.DNamedElementDiagram;
import ro.amiq.dvt.diagrams.design.DActionFlowDiagram;
import ro.amiq.dvt.diagrams.design.DActionSchematicDiagram;
import ro.amiq.dvt.diagrams.design.DBlockDiagram;
import ro.amiq.dvt.diagrams.design.DFlowDiagram;
import ro.amiq.dvt.diagrams.design.DSchematicDiagram;
import ro.amiq.dvt.diagrams.design.DTopPathDiagram;
import ro.amiq.dvt.diagrams.design.DTraceAllDiagram;
import ro.amiq.dvt.diagrams.design.DTraceDiagram;
import ro.amiq.dvt.diagrams.design.DTracePathDiagram;
import ro.amiq.dvt.diagrams.design.editor.DDesignEditorFactory;
import ro.amiq.dvt.diagrams.design.editor.actions.DDesignFiltersContentAssistProvider;
import ro.amiq.dvt.diagrams.design.editor.actions.DDesignFiltersDialogUtils;
import ro.amiq.dvt.diagrams.editor.DDiagramEditor;
import ro.amiq.dvt.diagrams.editor.actions.DFiltersDialogAbstract;
import ro.amiq.dvt.diagrams.filters.DiagramFiltersUtils;
import ro.amiq.dvt.diagrams.netlist.utils.NLConfig;
import ro.amiq.dvt.diagrams.netlist.utils.NLFilterSet;
import ro.amiq.dvt.model.reflection.IRfNamedElement;

public class DDesignFiltersDialog
extends DFiltersDialogAbstract {
    private static final List<String> PREDEFINED_FILTERS = new ArrayList<String>(Arrays.asList("Clock (predefined)", "Reset (predefined)", "Clock & Reset (predefined)"));
    public static final String SYNTAX_TOOLTIP = "Examples:\n\nhide instances matching [regex]\nshow types matching [regex]\ncolor ports, signals matching [regex]\ncolor signals matching [regex] using blue\ncolor ports matching [regex] using random";
    public static final String LINE_REGEX = "(show|hide)\\s+((port(s{0,1})|block(s{0,1})|instance(s{0,1})|type(s{0,1})|signal(s{0,1})|input port(s{0,1})|output port(s{0,1})|inout port(s{0,1})){0,1},{0,1} *)*\\s+matching\\s+(\\S+\\s+\\S+)+";
    public static final List<String> KINDS = Arrays.asList("port", "ports", "signal", "signals", "instance", "instances", "block", "blocks", "type", "types", "input port", "input ports", "output port", "output ports", "inout port", "inout ports");
    private Button reducePortsCheckbox;
    private Button reduceGatesCheckbox;
    private Button hidePlainAssignsCheckbox;

    public DDesignFiltersDialog(DDiagramEditor diagramEditor, Point location) {
        super(diagramEditor, location);
    }

    @Override
    protected void setDefaults() {
        super.setDefaults();
        DDiagram diagram = this.getDiagramEditor().getInput().getDiagram();
        NLConfig config = diagram instanceof DTopPathDiagram ? ((DTopPathDiagram)diagram).getConfig() : (diagram instanceof DTraceDiagram ? ((DTraceDiagram)diagram).getConfig() : null);
        NLFilterSet currentFilters = null;
        if (config != null) {
            currentFilters = config.getFilterSet();
        }
        this.filterSets = new LinkedHashMap();
        this.filterSets.put("None", null);
        this.filterSets.putAll(DiagramFiltersUtils.getFiltersBundle("diagramfilters.all_design_diagrams_filters"));
        for (String filterSetName : this.filterSets.keySet()) {
            this.filterSetCombo.add(filterSetName);
        }
        if (currentFilters == null || this.filterSets.get(currentFilters.getName()) == null) {
            this.selectSet("None");
        } else {
            this.selectSet(currentFilters.getName());
        }
    }

    @Override
    public void saveSet(String currentFiltersText) {
        if ("None".equals(this.currentFiltersName)) {
            return;
        }
        boolean reducePorts = this.reducePortsCheckbox != null ? this.reducePortsCheckbox.getSelection() : false;
        boolean reduceGates = this.reduceGatesCheckbox != null ? this.reduceGatesCheckbox.getSelection() : false;
        boolean hidePlainAssigns = this.hidePlainAssignsCheckbox != null ? this.hidePlainAssignsCheckbox.getSelection() : false;
        this.filterSets.put(this.currentFiltersName, new DiagramFiltersUtils.FilterBundle(currentFiltersText, reducePorts, reduceGates, false, hidePlainAssigns));
        this.saveFilters(this.filterSets);
    }

    @Override
    public void selectSet(String setName) {
        if (setName == null) {
            return;
        }
        this.currentFiltersName = setName;
        if (this.newSetComposite.isVisible()) {
            this.toggleNewSetComposite();
        }
        if (setName.equals("None")) {
            this.selectNone();
            return;
        }
        this.filterText.setEnabled(true);
        this.filterSetCombo.setText(setName);
        DiagramFiltersUtils.FilterBundle filterBundle = (DiagramFiltersUtils.FilterBundle)this.filterSets.get(setName);
        if (filterBundle == null) {
            return;
        }
        this.filterText.setText(filterBundle.filterSetContents);
        if (PREDEFINED_FILTERS.contains(setName)) {
            this.filterText.setEditable(false);
            if (this.deleteSetButton != null) {
                this.deleteSetButton.setEnabled(false);
            }
            if (this.duplicateSetButton != null) {
                this.duplicateSetButton.setEnabled(true);
            }
            if (this.reducePortsCheckbox != null) {
                this.reducePortsCheckbox.setEnabled(false);
                this.reducePortsCheckbox.setSelection(filterBundle.reducePorts);
            }
            if (this.reduceGatesCheckbox != null) {
                this.reduceGatesCheckbox.setEnabled(false);
                this.reduceGatesCheckbox.setSelection(filterBundle.reduceGates);
            }
            if (this.hidePlainAssignsCheckbox != null) {
                this.hidePlainAssignsCheckbox.setEnabled(false);
                this.hidePlainAssignsCheckbox.setSelection(filterBundle.hidePlainAssigns);
            }
        } else {
            this.filterText.setEditable(true);
            if (this.deleteSetButton != null) {
                this.deleteSetButton.setEnabled(true);
            }
            if (this.duplicateSetButton != null) {
                this.duplicateSetButton.setEnabled(true);
            }
            if (this.reducePortsCheckbox != null) {
                this.reducePortsCheckbox.setEnabled(true);
                this.reducePortsCheckbox.setSelection(filterBundle.reducePorts);
            }
            if (this.reduceGatesCheckbox != null) {
                this.reduceGatesCheckbox.setEnabled(true);
                this.reduceGatesCheckbox.setSelection(filterBundle.reduceGates);
            }
            if (this.hidePlainAssignsCheckbox != null) {
                this.hidePlainAssignsCheckbox.setEnabled(true);
                this.hidePlainAssignsCheckbox.setSelection(filterBundle.hidePlainAssigns);
            }
        }
    }

    @Override
    public void selectNone() {
        NLConfig config;
        this.filterSetCombo.setText("None");
        this.filterText.setText("");
        this.filterText.setEnabled(false);
        DDiagram diagram = this.getDiagramEditor().getInput().getDiagram();
        NLConfig nLConfig = diagram instanceof DTopPathDiagram ? ((DTopPathDiagram)diagram).getConfig() : (config = diagram instanceof DTraceDiagram ? ((DTraceDiagram)diagram).getConfig() : null);
        if (this.deleteSetButton != null) {
            this.deleteSetButton.setEnabled(false);
        }
        if (this.duplicateSetButton != null) {
            this.duplicateSetButton.setEnabled(false);
        }
        if (this.reducePortsCheckbox != null) {
            this.reducePortsCheckbox.setEnabled(true);
            this.reducePortsCheckbox.setSelection(config != null ? config.configReducePorts() : false);
        }
        if (this.reduceGatesCheckbox != null) {
            this.reduceGatesCheckbox.setEnabled(true);
            this.reduceGatesCheckbox.setSelection(config != null ? config.configReduceGates() : false);
        }
        if (this.hidePlainAssignsCheckbox != null) {
            this.hidePlainAssignsCheckbox.setEnabled(true);
            this.hidePlainAssignsCheckbox.setSelection(config != null ? config.configHidePlainAssigns() : false);
        }
    }

    @Override
    public void saveFilters(Map<String, DiagramFiltersUtils.FilterBundle> filterSets) {
        DiagramFiltersUtils.saveFilters(filterSets, "diagramfilters.all_design_diagrams_filters", true);
    }

    @Override
    public void openEditor(boolean newEditor) {
        DDiagram diagram = this.getDiagramEditor().getInput().getDiagram();
        if (!(diagram instanceof DTopPathDiagram) && !(diagram instanceof DTraceDiagram)) {
            return;
        }
        IRfNamedElement namedElement = diagram instanceof DNamedElementDiagram ? ((DNamedElementDiagram)diagram).getNamedElement() : null;
        this.saveSet(this.filterText.getText());
        NLConfig initialConfig = diagram instanceof DTopPathDiagram ? ((DTopPathDiagram)diagram).getConfig() : ((DTraceDiagram)diagram).getConfig();
        String selectedFilter = this.filterSetCombo.getText();
        String serializedSelectedFilter = "None".equals(selectedFilter) ? null : ((DiagramFiltersUtils.FilterBundle)this.filterSets.get(selectedFilter)).serializeBundle();
        boolean reduceGatesCheckboxSelection = this.reduceGatesCheckbox != null ? this.reduceGatesCheckbox.getSelection() : false;
        boolean reducePortsCheckboxSelection = this.reducePortsCheckbox != null ? this.reducePortsCheckbox.getSelection() : false;
        boolean hidePlainAssignsCheckboxSelection = this.hidePlainAssignsCheckbox != null ? this.hidePlainAssignsCheckbox.getSelection() : false;
        NLConfig config = DDesignFiltersDialogUtils.INSTANCE.getConfig(initialConfig, selectedFilter, serializedSelectedFilter, reduceGatesCheckboxSelection, reducePortsCheckboxSelection, hidePlainAssignsCheckboxSelection);
        DDesignEditorFactory designEditorFactory = null;
        if (diagram instanceof DBlockDiagram) {
            designEditorFactory = DDesignEditorFactory.getInstance().newBlockDiagram(namedElement, config, ((DTopPathDiagram)diagram).getTopPath());
        } else if (diagram instanceof DActionSchematicDiagram) {
            designEditorFactory = DDesignEditorFactory.getInstance().newActionDiagram(((DActionSchematicDiagram)diagram).getDepth(), namedElement, config, ((DTopPathDiagram)diagram).getTopPath());
        } else if (diagram instanceof DActionFlowDiagram) {
            designEditorFactory = DDesignEditorFactory.getInstance().newActionFlowDiagram(namedElement, config, ((DTopPathDiagram)diagram).getTopPath());
        } else if (diagram instanceof DFlowDiagram) {
            designEditorFactory = DDesignEditorFactory.getInstance().newFlowDiagram(namedElement, config, ((DTopPathDiagram)diagram).getTopPath());
        } else if (diagram instanceof DSchematicDiagram) {
            designEditorFactory = DDesignEditorFactory.getInstance().newSchematicDiagram(((DSchematicDiagram)diagram).getDepth(), namedElement, config, ((DTopPathDiagram)diagram).getTopPath());
        } else if (diagram instanceof DTraceAllDiagram) {
            DTraceAllDiagram traceDiagram = (DTraceAllDiagram)diagram;
            designEditorFactory = DDesignEditorFactory.getInstance().newTraceAllDiagram(traceDiagram.getName(), traceDiagram.getTopNode(), traceDiagram.getStartPoint(), traceDiagram.getSources(), traceDiagram.getDriveCausedBy(), traceDiagram.getDriveRedundance(), traceDiagram.getDestinations(), traceDiagram.getLoadCausedBy(), traceDiagram.getLoadRedundance(), traceDiagram.getOperation(), config);
        } else if (diagram instanceof DTracePathDiagram) {
            DTracePathDiagram traceDiagram = (DTracePathDiagram)diagram;
            designEditorFactory = DDesignEditorFactory.getInstance().newTracePathDiagram(traceDiagram.getName(), traceDiagram.getTopNode(), traceDiagram.getPoint(), traceDiagram.getSources(), traceDiagram.getDriveCausedBy(), traceDiagram.getDestinations(), traceDiagram.getLoadCausedBy(), traceDiagram.getStartPoint(), traceDiagram.getOperation(), config);
        }
        this.close();
        if (designEditorFactory != null) {
            if (newEditor) {
                designEditorFactory.openNewEditor();
            } else {
                designEditorFactory.openReuseEditor(this.getDiagramEditor());
            }
        }
    }

    @Override
    public void createAdditionalButtons(Composite composite) {
        if (!(this.getDiagramEditor().getInput().getDiagram() instanceof DBlockDiagram)) {
            if (!(this.getDiagramEditor().getInput().getDiagram() instanceof DFlowDiagram)) {
                this.reducePortsCheckbox = this.createButton(composite, 32, GridDataFactory.fillDefaults().span(5, 1).align(1, 0x1000000).grab(false, false), "Hide unconnected ports", null);
                this.reduceGatesCheckbox = this.createButton(composite, 32, GridDataFactory.fillDefaults().span(5, 1).align(1, 0x1000000).grab(false, false), "Hide blocks without ports", null);
            } else {
                this.reduceGatesCheckbox = this.createButton(composite, 32, GridDataFactory.fillDefaults().span(5, 1).align(1, 0x1000000).grab(false, false), "Hide blocks without ports", null);
            }
        }
    }

    @Override
    public IContentProposalProvider getContentProposalProvider() {
        return DDesignFiltersContentAssistProvider.getInstance();
    }

    @Override
    public String getTooltipText() {
        return SYNTAX_TOOLTIP;
    }

    @Override
    public String getLineRegex() {
        return LINE_REGEX;
    }

    @Override
    public List<String> getKindNames() {
        return KINDS;
    }
}

