/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.diagrams.design.editor.actions;

import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Widget;
import ro.amiq.dvt.diagrams.DDiagram;
import ro.amiq.dvt.diagrams.DNamedElementDiagram;
import ro.amiq.dvt.diagrams.design.DBlockDiagram;
import ro.amiq.dvt.diagrams.design.DFlowDiagram;
import ro.amiq.dvt.diagrams.design.DSchematicDiagram;
import ro.amiq.dvt.diagrams.design.DTopPathDiagram;
import ro.amiq.dvt.diagrams.design.DTraceDiagram;
import ro.amiq.dvt.diagrams.design.editor.DDesignEditorFactory;
import ro.amiq.dvt.diagrams.editor.DDiagramEditor;
import ro.amiq.dvt.diagrams.editor.DDiagramEditorInput;
import ro.amiq.dvt.diagrams.editor.utils.DEditorDialog;
import ro.amiq.dvt.diagrams.netlist.utils.NLConfig;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfSingleLangProject;
import ro.amiq.dvt.power.format.DVTPFModel;
import ro.amiq.dvt.ui.preferences.PrefConst;

public class DDesignPreferencesDialog
extends DEditorDialog {
    private static final String SHOW_PD_INFO = "Show PD Info";
    private static final String SHOW_BOUNDARY_CONNECTIONS = "Show boundary connections";
    public static final String SHOW_WAVEFORM_INFO = "Show Waveform Info";
    public static final String SHOW_CONSTANTS = "Show Constants";
    public static final String SHOW_PORT_WIDTH_TEXT = "Show Port Width";
    public static final String SHOW_PORT_FULLY_QUALIFIED_TYPE_TEXT = "Show Port Fully Qualified Type";
    private Button blockRadio;
    private Button flowRadio;
    private Button schematicRadio;
    private Button blockShowPDColorCheck;
    private Button schematicShowPDColorCheck;
    private Button flowShowPDColorCheck;
    private Composite stackComposite;
    private StackLayout stackLayout;
    private Composite schematicOptionsComposite;
    private Composite flowOptionsComposite;
    private Composite blockOptionsComposite;
    private boolean isOnlyShallowElaboration;
    private Spinner depthSpinner;
    private Button flowShowBoundaryConnections;
    private Button schematicShowWaveformInfo;
    private Button schematicHideInternalLogicGates;
    private Button schematicShowConstants;
    private Button schematicShowPortWidth;
    private Button blockShowPortWidth;
    private boolean showUPFInfo;
    private NLConfig config;

    public DDesignPreferencesDialog(DDiagramEditor diagramEditor, Point location) {
        super(diagramEditor, location, false);
        DDiagram diagram;
        this.setShowUPFInfo();
        DDiagramEditorInput input = diagramEditor.getInput();
        DDiagram dDiagram = diagram = input != null ? input.getDiagram() : null;
        if (diagram instanceof DTopPathDiagram) {
            this.isOnlyShallowElaboration = ((DTopPathDiagram)diagram).isOnlyShallowElaboration();
            this.config = new NLConfig(((DTopPathDiagram)diagram).getConfig());
            this.config.setBreadcrumbInput(((DTopPathDiagram)diagram).getConfig().getBreadcrumbInput());
        } else {
            this.config = new NLConfig(DDesignEditorFactory.getInstance().getDefaultNLConfiguration());
        }
    }

    @Override
    protected void createMainArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)composite);
        GridLayoutFactory.fillDefaults().numColumns(3).applyTo(composite);
        this.createRadioComposite(composite);
        this.createSeparator(composite, 512);
        this.createStackComposite(composite);
    }

    private void createRadioComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridDataFactory.fillDefaults().align(1, 1).grab(false, false).applyTo((Control)composite);
        GridLayoutFactory.fillDefaults().applyTo(composite);
        this.blockRadio = this.createButton(composite, 16, "Block", () -> this.setOptionsComposite(this.blockOptionsComposite));
        this.flowRadio = this.createButton(composite, 16, "Flow", () -> this.setOptionsComposite(this.flowOptionsComposite));
        this.schematicRadio = this.createButton(composite, 16, "Schematic", () -> this.setOptionsComposite(this.schematicOptionsComposite));
    }

    private void createStackComposite(Composite parent) {
        this.stackComposite = new Composite(parent, 0);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)this.stackComposite);
        this.stackLayout = new StackLayout();
        this.stackComposite.setLayout((Layout)this.stackLayout);
        this.blockOptionsComposite = new Composite(this.stackComposite, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).equalWidth(false).applyTo(this.blockOptionsComposite);
        this.flowOptionsComposite = new Composite(this.stackComposite, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).equalWidth(false).applyTo(this.flowOptionsComposite);
        this.schematicOptionsComposite = new Composite(this.stackComposite, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).equalWidth(false).applyTo(this.schematicOptionsComposite);
        if (this.showUPFInfo) {
            this.createPDInfoOptions();
        }
        this.createBlockDialog();
        this.createFlowDialog();
        this.createSchematicDialog();
        this.addShowPortWidthListeners();
    }

    private void createBlockDialog() {
        Label blockShowPortWidthLabel = new Label(this.blockOptionsComposite, 0);
        GridDataFactory.fillDefaults().align(1, 0x1000000).grab(false, false).applyTo((Control)blockShowPortWidthLabel);
        blockShowPortWidthLabel.setText(SHOW_PORT_WIDTH_TEXT);
        this.blockShowPortWidth = new Button(this.blockOptionsComposite, 32);
        GridDataFactory.fillDefaults().align(4, 0x1000000).hint(50, -1).grab(true, false).applyTo((Control)this.blockOptionsComposite);
    }

    private void createFlowDialog() {
        Label flowShowBoundaryConnectionsLabel = new Label(this.flowOptionsComposite, 0);
        GridDataFactory.fillDefaults().align(1, 0x1000000).grab(false, false).applyTo((Control)flowShowBoundaryConnectionsLabel);
        flowShowBoundaryConnectionsLabel.setText(SHOW_BOUNDARY_CONNECTIONS);
        this.flowShowBoundaryConnections = new Button(this.flowOptionsComposite, 32);
        GridDataFactory.fillDefaults().align(4, 0x1000000).hint(50, -1).grab(true, false).applyTo((Control)this.flowShowBoundaryConnections);
    }

    private void createSchematicDialog() {
        Label schematicShowWaveformInfoLabel = new Label(this.schematicOptionsComposite, 0);
        GridDataFactory.fillDefaults().align(1, 0x1000000).grab(false, false).applyTo((Control)schematicShowWaveformInfoLabel);
        schematicShowWaveformInfoLabel.setText(SHOW_WAVEFORM_INFO);
        this.schematicShowWaveformInfo = new Button(this.schematicOptionsComposite, 32);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)this.schematicShowWaveformInfo);
        if (!this.isOnlyShallowElaboration) {
            Label depthLabel = new Label(this.schematicOptionsComposite, 0);
            GridDataFactory.fillDefaults().align(1, 0x1000000).grab(false, false).applyTo((Control)depthLabel);
            depthLabel.setText("Depth");
            this.depthSpinner = new Spinner(this.schematicOptionsComposite, 2048);
            GridDataFactory.fillDefaults().align(4, 0x1000000).hint(50, -1).grab(true, false).applyTo((Control)this.depthSpinner);
            this.depthSpinner.setTextLimit(3);
            this.depthSpinner.setMinimum(1);
            this.depthSpinner.setMaximum(999);
        }
        Label schematicHideInternalLogicGatesLabel = new Label(this.schematicOptionsComposite, 0);
        GridDataFactory.fillDefaults().align(1, 0x1000000).grab(false, false).applyTo((Control)schematicHideInternalLogicGatesLabel);
        schematicHideInternalLogicGatesLabel.setText("Hide logic gates");
        this.schematicHideInternalLogicGates = new Button(this.schematicOptionsComposite, 32);
        GridDataFactory.fillDefaults().align(4, 0x1000000).hint(50, -1).grab(true, false).applyTo((Control)this.schematicHideInternalLogicGates);
        Label schematicShowConstantsLabel = new Label(this.schematicOptionsComposite, 0);
        GridDataFactory.fillDefaults().align(1, 0x1000000).grab(false, false).applyTo((Control)schematicShowConstantsLabel);
        schematicShowConstantsLabel.setText(SHOW_CONSTANTS);
        this.schematicShowConstants = new Button(this.schematicOptionsComposite, 32);
        GridDataFactory.fillDefaults().align(4, 0x1000000).hint(50, -1).grab(true, false).applyTo((Control)this.schematicShowConstants);
        Label schematicShowPortWidthLabel = new Label(this.schematicOptionsComposite, 0);
        GridDataFactory.fillDefaults().align(1, 0x1000000).grab(false, false).applyTo((Control)schematicShowPortWidthLabel);
        schematicShowPortWidthLabel.setText(SHOW_PORT_WIDTH_TEXT);
        this.schematicShowPortWidth = new Button(this.schematicOptionsComposite, 32);
        GridDataFactory.fillDefaults().align(4, 0x1000000).hint(50, -1).grab(true, false).applyTo((Control)this.schematicShowPortWidth);
    }

    private void addShowPortWidthListeners() {
        this.schematicShowPortWidth.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DDesignPreferencesDialog.this.blockShowPortWidth.setSelection(DDesignPreferencesDialog.this.schematicShowPortWidth.getSelection());
            }
        });
        this.blockShowPortWidth.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DDesignPreferencesDialog.this.schematicShowPortWidth.setSelection(DDesignPreferencesDialog.this.blockShowPortWidth.getSelection());
            }
        });
    }

    private void createPDInfoOptions() {
        Label blockPDColorLabel = new Label(this.blockOptionsComposite, 0);
        GridDataFactory.fillDefaults().align(1, 0x1000000).grab(false, false).applyTo((Control)blockPDColorLabel);
        blockPDColorLabel.setText(SHOW_PD_INFO);
        this.blockShowPDColorCheck = new Button(this.blockOptionsComposite, 32);
        GridDataFactory.fillDefaults().align(4, 0x1000000).hint(50, -1).grab(true, false).applyTo((Control)this.blockShowPDColorCheck);
        this.blockShowPDColorCheck.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                DDesignPreferencesDialog.this.flowShowPDColorCheck.setSelection(DDesignPreferencesDialog.this.blockShowPDColorCheck.getSelection());
                DDesignPreferencesDialog.this.schematicShowPDColorCheck.setSelection(DDesignPreferencesDialog.this.blockShowPDColorCheck.getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Label schematicPDColorLabel = new Label(this.schematicOptionsComposite, 0);
        GridDataFactory.fillDefaults().align(1, 0x1000000).grab(false, false).applyTo((Control)schematicPDColorLabel);
        schematicPDColorLabel.setText(SHOW_PD_INFO);
        this.schematicShowPDColorCheck = new Button(this.schematicOptionsComposite, 32);
        GridDataFactory.fillDefaults().align(4, 0x1000000).hint(50, -1).grab(true, false).applyTo((Control)this.schematicShowPDColorCheck);
        this.schematicShowPDColorCheck.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                DDesignPreferencesDialog.this.blockShowPDColorCheck.setSelection(DDesignPreferencesDialog.this.schematicShowPDColorCheck.getSelection());
                DDesignPreferencesDialog.this.flowShowPDColorCheck.setSelection(DDesignPreferencesDialog.this.schematicShowPDColorCheck.getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Label flowPDColorLabel = new Label(this.flowOptionsComposite, 0);
        GridDataFactory.fillDefaults().align(1, 0x1000000).grab(false, false).applyTo((Control)flowPDColorLabel);
        flowPDColorLabel.setText(SHOW_PD_INFO);
        this.flowShowPDColorCheck = new Button(this.flowOptionsComposite, 32);
        GridDataFactory.fillDefaults().align(4, 0x1000000).hint(50, -1).grab(true, false).applyTo((Control)this.flowShowPDColorCheck);
        this.flowShowPDColorCheck.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                DDesignPreferencesDialog.this.blockShowPDColorCheck.setSelection(DDesignPreferencesDialog.this.flowShowPDColorCheck.getSelection());
                DDesignPreferencesDialog.this.schematicShowPDColorCheck.setSelection(DDesignPreferencesDialog.this.flowShowPDColorCheck.getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    @Override
    protected void createBottomArea(Composite parent) {
        Composite composite = super.createBottomComposite(parent, 2);
        this.createPreferencesLink("ro.amiq.dvt.diagrams.DesignDiagramsPreferencePage", composite);
        Composite buttonsComposite = this.createButtonsComposite(composite, 3);
        this.createButton(buttonsComposite, 8, "Cancel", () -> {
            boolean bl = this.close();
        });
        this.createButton(buttonsComposite, 8, "New", () -> this.openEditor(true));
        this.createButton(buttonsComposite, 8, "Apply", () -> this.openEditor(false));
    }

    @Override
    protected void setDefaults() {
        DDiagram diagram = this.getDiagramEditor().getInput().getDiagram();
        Button selectedButton = null;
        if (diagram instanceof DSchematicDiagram) {
            selectedButton = this.schematicRadio;
            if (!this.isOnlyShallowElaboration) {
                this.depthSpinner.setSelection(((DSchematicDiagram)diagram).getDepth());
            }
        } else if (diagram instanceof DFlowDiagram) {
            selectedButton = this.flowRadio;
        } else if (diagram instanceof DBlockDiagram) {
            selectedButton = this.blockRadio;
        }
        if (this.showUPFInfo) {
            this.blockShowPDColorCheck.setSelection(PrefConst.getDiagramsShowPDInfo());
            this.schematicShowPDColorCheck.setSelection(PrefConst.getDiagramsShowPDInfo());
            this.flowShowPDColorCheck.setSelection(PrefConst.getDiagramsShowPDInfo());
        }
        NLConfig config = diagram instanceof DTopPathDiagram ? ((DTopPathDiagram)diagram).getConfig() : (diagram instanceof DTraceDiagram ? ((DTraceDiagram)diagram).getConfig() : null);
        this.flowShowBoundaryConnections.setSelection(config != null ? config.configFlowShowBoundaryConnections() : PrefConst.getFlowShowBoundaryConnections());
        this.schematicShowWaveformInfo.setSelection(PrefConst.getSchematicShowWaveformInfo());
        this.schematicHideInternalLogicGates.setSelection(PrefConst.getSchematicHideInternalLogicGates());
        this.schematicShowConstants.setSelection(PrefConst.getSchematicShowConstants());
        this.schematicShowPortWidth.setSelection(PrefConst.getDiagramShowPortWidth());
        this.blockShowPortWidth.setSelection(PrefConst.getDiagramShowPortWidth());
        if (config != null) {
            config.setSchematicShowConstants(PrefConst.getSchematicShowConstants());
            config.setDiagramShowPortWidth(PrefConst.getDiagramShowPortWidth());
        }
        if (selectedButton != null) {
            selectedButton.setSelection(true);
            DDesignPreferencesDialog.runWidgetSelectedAction((Widget)selectedButton);
        }
    }

    private void setOptionsComposite(Composite composite) {
        this.stackLayout.topControl = composite;
        this.stackComposite.layout();
    }

    private void openEditor(boolean newEditor) {
        DTopPathDiagram diagram = (DTopPathDiagram)this.getDiagramEditor().getInput().getDiagram();
        IRfNamedElement namedElement = diagram.getNamedElement();
        ElementPath topPath = diagram.getTopPath();
        DDesignEditorFactory designEditorFactory = null;
        if (this.blockRadio.getSelection()) {
            PrefConst.setDiagramsShowPDColors(this.blockShowPDColorCheck != null ? this.blockShowPDColorCheck.getSelection() : false);
            designEditorFactory = DDesignEditorFactory.getInstance().newBlockDiagram(namedElement, this.config, topPath);
            PrefConst.setDiagramShowPortWidth(this.blockShowPortWidth != null && this.blockShowPortWidth.getSelection());
            this.config.setDiagramShowPortWidth(PrefConst.getDiagramShowPortWidth());
        } else if (this.flowRadio.getSelection()) {
            PrefConst.setDiagramsShowPDColors(this.flowShowPDColorCheck != null ? this.flowShowPDColorCheck.getSelection() : false);
            this.config.setFlowShowBoundaryConnections(this.flowShowBoundaryConnections != null ? this.flowShowBoundaryConnections.getSelection() : false);
            designEditorFactory = DDesignEditorFactory.getInstance().newFlowDiagram(namedElement, this.config, topPath);
        } else if (this.schematicRadio.getSelection()) {
            PrefConst.setDiagramsShowPDColors(this.schematicShowPDColorCheck != null ? this.schematicShowPDColorCheck.getSelection() : false);
            PrefConst.setSchematicShowWaveformInfo(this.schematicShowWaveformInfo != null && this.schematicShowWaveformInfo.getSelection());
            this.config.setSchematicShowWaveformInfo(PrefConst.getSchematicShowWaveformInfo());
            PrefConst.setSchematicHideInternalLogicGates(this.schematicHideInternalLogicGates != null && this.schematicHideInternalLogicGates.getSelection());
            this.config.setHideInternalLogicGates(PrefConst.getSchematicHideInternalLogicGates());
            PrefConst.setSchematicShowConstants(this.schematicShowConstants != null && this.schematicShowConstants.getSelection());
            this.config.setSchematicShowConstants(PrefConst.getSchematicShowConstants());
            PrefConst.setDiagramShowPortWidth(this.schematicShowPortWidth != null && this.schematicShowPortWidth.getSelection());
            this.config.setDiagramShowPortWidth(PrefConst.getDiagramShowPortWidth());
            if (!this.isOnlyShallowElaboration) {
                designEditorFactory = DDesignEditorFactory.getInstance().newSchematicDiagram(this.depthSpinner.getSelection(), namedElement, this.config, topPath);
            }
        }
        this.close();
        if (designEditorFactory != null) {
            if (newEditor) {
                designEditorFactory.openNewEditor();
            } else {
                designEditorFactory.openReuseEditor(this.getDiagramEditor());
            }
        }
    }

    private void setShowUPFInfo() {
        IRfNamedElement namedElement = ((DNamedElementDiagram)this.getDiagramEditor().getInput().getDiagram()).getNamedElement();
        if (namedElement == null) {
            return;
        }
        IRfSingleLangProject project = namedElement.getRfProject();
        if (project == null) {
            return;
        }
        DVTPFModel upfModel = project.getPFModel();
        if (upfModel == null || !upfModel.hasPowerDomains()) {
            return;
        }
        this.showUPFInfo = true;
    }
}

