/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.diagrams.design.editor.actions;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.text.FindReplaceDocumentAdapterContentProposalProvider;
import ro.amiq.dvt.diagrams.editor.actions.DAbstractProposalComputer;
import ro.amiq.dvt.draw.utils.ColorMap;

public class DDesignProposalComputer
extends DAbstractProposalComputer {
    private static final String RANDOM_STRING = "random";

    public DDesignProposalComputer(String expression, int offset) {
        super(expression, offset);
    }

    @Override
    public IContentProposal[] computeProposals() {
        if (this.getExpression().substring(0, this.getOffset()).trim().length() < 5) {
            String prolog = this.getExpression().substring(0, this.getOffset()).trim();
            if (this.getExpression().substring(0, this.getOffset()).trim().length() < 4) {
                this.addKeywordProposal("hide ", 5, 0, prolog, "hide", "Hide elements of the specified types by name");
                this.addKeywordProposal("show ", 5, 0, prolog, "show", "Show previously hidden elements of the specified types by name");
            }
            this.addKeywordProposal("color ", 6, 0, prolog, "color", "Color elements of the specified types by name. You may also specify the color to be used by adding \"using [color_code_or_name]\". color_code_or_name may be either a 6-digit or a 3-digit hexadecimal code, a comma-separated list of three integers representing RGB values, or any standard CSS color name.");
        }
        if (this.getExpression().matches("\\s*(?i)(show|hide|color)\\s+.*")) {
            this.addTypeProposal("blocks", 6, "blocks", "Apply this filter to logic blocks and design instances");
            this.addTypeProposal("instances", 9, "instances", "Apply this filter to design instances");
            this.addTypeProposal("ports", 5, "ports", "Apply this filter to ports");
            this.addTypeProposal("input ports", 11, "input ports", "Apply this filter to input ports");
            this.addTypeProposal("output ports", 12, "output ports", "Apply this filter to output ports");
            this.addTypeProposal("inout ports", 11, "inout ports", "Apply this filter to inout ports");
            this.addTypeProposal("signals", 7, "signals", "Apply this filter to signals");
            this.addTypeProposal("types", 5, "types", "Apply this filter to design elements");
        }
        if (this.getExpression().matches("\\s*(?i)(show|hide|color)\\s+((port(s{0,1})|block(s{0,1})|instance(s{0,1})|type(s{0,1})|signal(s{0,1})|input port(s{0,1})|output port(s{0,1})|inout port(s{0,1})){0,1},{0,1} *)*\\s+(m|ma|mat|matc|match|matchi|matchin){0,1}")) {
            pattern = Pattern.compile("\\s*(?i)(show|hide|color)\\s+((port(s{0,1})|block(s{0,1})|instance(s{0,1})|type(s{0,1})|signal(s{0,1})|input port(s{0,1})|output port(s{0,1})|inout port(s{0,1})){0,1},{0,1} *)*\\s+(.*)");
            Matcher matcher = pattern.matcher(this.getExpression());
            String prolog = "";
            if (matcher.find()) {
                prolog = matcher.group(12);
            }
            this.addKeywordProposal("matching ", 9, 0, prolog, "matching", "Keyword introducing the regular expression matching the diagram elements you want to filter");
        } else if (this.getExpression().matches("\\s*(?i)(show|hide|color)\\s+((port(s{0,1})|block(s{0,1})|instance(s{0,1})|type(s{0,1})|signal(s{0,1})|input port(s{0,1})|output port(s{0,1})|inout port(s{0,1})){0,1},{0,1} *)*\\s+matching\\s+\\S*")) {
            if (!(this.getOffset() <= this.getExpression().indexOf("matching") + 8 || this.getExpression().contains("using") && this.getOffset() >= this.getExpression().indexOf("using"))) {
                return new FindReplaceDocumentAdapterContentProposalProvider(true).getProposals(this.getExpression(), this.getOffset());
            }
        } else if (this.getExpression().matches("\\s*(?i)(color)\\s+((port(s{0,1})|block(s{0,1})|instance(s{0,1})|type(s{0,1})|signal(s{0,1})|input port(s{0,1})|output port(s{0,1})|inout port(s{0,1})){0,1},{0,1} *)*\\s+matching\\s+\\S*\\s+(u|us|usi|usin){0,1}")) {
            pattern = Pattern.compile("\\s*(?i)(color)\\s+((port(s{0,1})|block(s{0,1})|instance(s{0,1})|type(s{0,1})|signal(s{0,1})|input port(s{0,1})|output port(s{0,1})|inout port(s{0,1})){0,1},{0,1} *)*\\s+matching\\s+\\S*\\s+(.*)");
            Matcher matcher = pattern.matcher(this.getExpression());
            String prolog = "";
            if (matcher.find()) {
                prolog = matcher.group(12);
            }
            this.addKeywordProposal("using ", 6, 0, prolog, "using", "Keyword introducing the code or name of the color to be used");
        } else if (this.getExpression().matches("\\s*(?i)(color)\\s+((port(s{0,1})|block(s{0,1})|instance(s{0,1})|type(s{0,1})|signal(s{0,1})|input port(s{0,1})|output port(s{0,1})|inout port(s{0,1})){0,1},{0,1} *)*\\s+matching\\s+\\S*\\s+using\\s+.*")) {
            pattern = Pattern.compile("\\s*(?i)(color)\\s+((port(s{0,1})|block(s{0,1})|instance(s{0,1})|type(s{0,1})|signal(s{0,1})|input port(s{0,1})|output port(s{0,1})|inout port(s{0,1})){0,1},{0,1} *)*\\s+matching\\s+\\S*\\s+using\\s+(.*)");
            Matcher matcher = pattern.matcher(this.getExpression());
            String prolog = "";
            int start = 0;
            if (matcher.find()) {
                start = matcher.start(12);
                if (this.getOffset() > start) {
                    prolog = this.getExpression().substring(start, this.getOffset());
                }
            }
            if (RANDOM_STRING.startsWith(prolog)) {
                this.addKeywordProposal(RANDOM_STRING, RANDOM_STRING.length(), start, prolog, RANDOM_STRING, null);
            }
            for (String colorName : ColorMap.getNamesStartingWith(prolog)) {
                this.addKeywordProposal(colorName, colorName.length(), start, prolog, colorName, null);
            }
        }
        this.getPriorityProposals().addAll(this.getProposals());
        return this.getPriorityProposals().toArray(new IContentProposal[this.getProposals().size()]);
    }
}

