/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.diagrams.design.editor.actions.menu;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import ro.amiq.dvt.diagrams.DDiagram;
import ro.amiq.dvt.diagrams.design.editor.actions.menu.DWaveformViewerMenuAction;
import ro.amiq.dvt.diagrams.klay.utils.KLayDrawUtils;
import ro.amiq.dvt.diagrams.netlist.model.INLViewSelectable2;
import ro.amiq.dvt.diagrams.netlist.model.NLInstanceGate;
import ro.amiq.dvt.diagrams.netlist.model.NLPort;
import ro.amiq.dvt.diagrams.wave.WaveDiagramEditor;
import ro.amiq.dvt.draw.obj.interaction.DSelectable;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.ui.waveviewer.DVTVCDSignalWrapper;
import ro.amiq.dvt.ui.waveviewer.DVTVCDUtils;
import ro.amiq.dvt.ui.waveviewer.DVTWaveViewIDEFactory;

public class DAddPortsToWaveformViewerMenuAction
extends DWaveformViewerMenuAction {
    protected DAddPortsToWaveformViewerMenuAction(Set<DSelectable> selection, DDiagram diagram) {
        super(selection, diagram, "Add Ports");
    }

    @Override
    public boolean isVisible() {
        if (this.selection == null || this.selection.isEmpty()) {
            return false;
        }
        INLViewSelectable2 selectable = KLayDrawUtils.getNLViewSelectable2((DSelectable)this.selection.iterator().next());
        return selectable instanceof NLInstanceGate;
    }

    @Override
    public void run() {
        if (this.selection == null || this.selection.isEmpty()) {
            return;
        }
        WaveDiagramEditor inputWaveEditor = DVTWaveViewIDEFactory.getInstance().getInputWaveEditor(this.getProject());
        if (inputWaveEditor == null) {
            return;
        }
        List<DVTVCDSignalWrapper> signalsWrappers = DVTVCDUtils.getSignalsWrappers(inputWaveEditor);
        if (signalsWrappers == null || signalsWrappers.isEmpty()) {
            return;
        }
        INLViewSelectable2 selectable = KLayDrawUtils.getNLViewSelectable2((DSelectable)this.selection.iterator().next());
        if (!(selectable instanceof NLInstanceGate)) {
            return;
        }
        ElementPath gateElementPath = this.getElementPathFromGate((NLInstanceGate)selectable);
        if (gateElementPath == null) {
            return;
        }
        List<String> portsName = this.getSignalsNameToSend((NLInstanceGate)selectable);
        DVTWaveViewIDEFactory.getInstance().addToWave(inputWaveEditor, gateElementPath, portsName, signalsWrappers);
    }

    private List<String> getSignalsNameToSend(NLInstanceGate gate) {
        ArrayList<String> portNames = new ArrayList<String>();
        Collection<NLPort> ports = gate.getPorts();
        for (NLPort port : ports) {
            portNames.add(port.getName());
        }
        return portNames;
    }
}

