/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.diagrams.design.editor.actions.menu;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import ro.amiq.dvt.diagrams.DDiagram;
import ro.amiq.dvt.diagrams.design.DSchematicDiagram;
import ro.amiq.dvt.diagrams.design.DTopPathDiagram;
import ro.amiq.dvt.diagrams.design.editor.DDesignEditorFactory;
import ro.amiq.dvt.diagrams.design.editor.actions.menu.DMenuActionKind;
import ro.amiq.dvt.diagrams.design.editor.actions.menu.DMenuActionMessages;
import ro.amiq.dvt.diagrams.editor.DMenuAction;
import ro.amiq.dvt.diagrams.klay.utils.KLayDrawUtils;
import ro.amiq.dvt.diagrams.netlist.model.INLViewSelectable2;
import ro.amiq.dvt.diagrams.netlist.model.NLAbstractBase;
import ro.amiq.dvt.diagrams.netlist.model.NLGateKind;
import ro.amiq.dvt.diagrams.netlist.model.NLInstanceGate;
import ro.amiq.dvt.diagrams.netlist.model.NLInstanceGateExpandState;
import ro.amiq.dvt.diagrams.netlist.model.NLParameters;
import ro.amiq.dvt.diagrams.netlist.utils.NLConfig;
import ro.amiq.dvt.diagrams.netlist.utils.NLUtils;
import ro.amiq.dvt.draw.obj.interaction.DSelectable;

public class DCollapseMenuAction
extends DMenuAction {
    private Set<INLViewSelectable2> selection;

    public DCollapseMenuAction(Set<DSelectable> selection, DDiagram dDiagram) {
        super(dDiagram, DMenuActionMessages.collapseTitle);
        this.selection = selection.stream().map(KLayDrawUtils::getNLViewSelectable2).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    @Override
    public boolean isVisible() {
        if (!(this.getDiagram() instanceof DSchematicDiagram)) {
            return false;
        }
        Iterator<INLViewSelectable2> iter = this.selection.iterator();
        while (iter.hasNext()) {
            NLInstanceGate selectable = (NLInstanceGate)iter.next();
            if (selectable.getKind() != NLGateKind.INSTANCE) {
                iter.remove();
                continue;
            }
            if (selectable.getExpandState() == NLInstanceGateExpandState.COLLAPSED || selectable.getExpandState() == NLInstanceGateExpandState.INVISIBLE) {
                iter.remove();
                continue;
            }
            if (!selectable.isTopGate()) continue;
            iter.remove();
        }
        return !this.selection.isEmpty();
    }

    @Override
    public void run() {
        DTopPathDiagram diagram = (DTopPathDiagram)this.getDiagram();
        NLConfig newConfig = new NLConfig(diagram.getConfig());
        HashSet<NLAbstractBase> nlObjects = new HashSet<NLAbstractBase>();
        for (INLViewSelectable2 selectable : this.selection) {
            nlObjects.add((NLInstanceGate)selectable);
        }
        newConfig.setTopInstance(NLUtils.copyModelForSelection(nlObjects, diagram.getConfig(), NLParameters.NLParametersFlag.TO_COLLAPSE).getTopGate());
        newConfig.setActionKind(DMenuActionKind.COLLAPSE);
        this.openEditor(DDesignEditorFactory.getInstance().newActionDiagram(this.getDepth(diagram), diagram.getNamedElement(), newConfig, diagram.getTopPath()));
    }
}

