/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.diagrams.design.editor.actions.menu;

import java.util.HashSet;
import java.util.Set;
import ro.amiq.dvt.diagrams.DDiagram;
import ro.amiq.dvt.diagrams.design.DSchematicDiagram;
import ro.amiq.dvt.diagrams.design.DTopPathDiagram;
import ro.amiq.dvt.diagrams.design.editor.DDesignEditorFactory;
import ro.amiq.dvt.diagrams.design.editor.actions.menu.DMenuActionKind;
import ro.amiq.dvt.diagrams.design.editor.actions.menu.DMenuActionMessages;
import ro.amiq.dvt.diagrams.editor.DMenuAction;
import ro.amiq.dvt.diagrams.klay.utils.KLayDrawUtils;
import ro.amiq.dvt.diagrams.netlist.model.INLViewSelectable2;
import ro.amiq.dvt.diagrams.netlist.model.NLAbstractBase;
import ro.amiq.dvt.diagrams.netlist.model.NLGateKind;
import ro.amiq.dvt.diagrams.netlist.model.NLInstanceGate;
import ro.amiq.dvt.diagrams.netlist.model.NLInstanceGateExpandState;
import ro.amiq.dvt.diagrams.netlist.model.NLParameters;
import ro.amiq.dvt.diagrams.netlist.utils.NLConfig;
import ro.amiq.dvt.diagrams.netlist.utils.NLUtils;
import ro.amiq.dvt.draw.obj.interaction.DSelectable;

public class DExpandMenuAction
extends DMenuAction {
    private Set<INLViewSelectable2> validElements = new HashSet<INLViewSelectable2>();

    public DExpandMenuAction(Set<DSelectable> selection, DDiagram dDiagram) {
        super(dDiagram, DMenuActionMessages.expandTitle);
        if (!(this.getDiagram() instanceof DSchematicDiagram)) {
            return;
        }
        for (DSelectable selectable : selection) {
            NLInstanceGate gate;
            INLViewSelectable2 element = KLayDrawUtils.getNLViewSelectable2(selectable);
            if (!(element instanceof NLInstanceGate) || (gate = (NLInstanceGate)element).getKind() != NLGateKind.INSTANCE && gate.getKind() != NLGateKind.BLOCK && !gate.isTopGate() || gate.getExpandState() == NLInstanceGateExpandState.EXPANDED) continue;
            this.validElements.add(gate);
        }
    }

    @Override
    public boolean isVisible() {
        return !this.validElements.isEmpty();
    }

    @Override
    public void run() {
        DTopPathDiagram diagram = (DTopPathDiagram)this.getDiagram();
        NLConfig newConfig = new NLConfig(diagram.getConfig());
        HashSet<NLAbstractBase> nlObjects = new HashSet<NLAbstractBase>();
        for (INLViewSelectable2 selectable : this.validElements) {
            nlObjects.add((NLInstanceGate)selectable);
        }
        newConfig.setTopInstance(NLUtils.copyModelForSelection(nlObjects, diagram.getConfig(), NLParameters.NLParametersFlag.TO_EXPAND).getTopGate());
        newConfig.setActionKind(DMenuActionKind.EXPAND);
        newConfig.setBreadcrumbInput(diagram.getConfig().getBreadcrumbInput());
        this.openEditor(DDesignEditorFactory.getInstance().newActionDiagram(this.getDepth(diagram), diagram.getNamedElement(), newConfig, diagram.getTopPath()));
    }
}

