/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.diagrams.design.editor.actions.menu;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import ro.amiq.dvt.diagrams.DDiagram;
import ro.amiq.dvt.diagrams.design.editor.actions.menu.DAddAllSignalsToWaveformViewerMenuAction;
import ro.amiq.dvt.diagrams.design.editor.actions.menu.DAddPortsToWaveformViewerMenuAction;
import ro.amiq.dvt.diagrams.design.editor.actions.menu.DAddToWaveformViewerMenuAction;
import ro.amiq.dvt.diagrams.design.editor.actions.menu.DAddWithDriversMenuAction;
import ro.amiq.dvt.diagrams.design.editor.actions.menu.DAddWithLoadsMenuAction;
import ro.amiq.dvt.diagrams.design.editor.actions.menu.DCollapseMenuAction;
import ro.amiq.dvt.diagrams.design.editor.actions.menu.DDeleteMenuAction;
import ro.amiq.dvt.diagrams.design.editor.actions.menu.DExpandMenuAction;
import ro.amiq.dvt.diagrams.design.editor.actions.menu.DGoToDeclarationMenuAction;
import ro.amiq.dvt.diagrams.design.editor.actions.menu.DMenuActionFactoryCommon;
import ro.amiq.dvt.diagrams.design.editor.actions.menu.DMenuActionKind;
import ro.amiq.dvt.diagrams.design.editor.actions.menu.DMenuActionMessages;
import ro.amiq.dvt.diagrams.design.editor.actions.menu.DRevealInWaveformViewer;
import ro.amiq.dvt.diagrams.design.editor.actions.menu.DShowConnectionsAroundMenuAction;
import ro.amiq.dvt.diagrams.design.editor.actions.menu.DShowConnectionsBetweenMenuAction;
import ro.amiq.dvt.diagrams.design.editor.actions.menu.DShowDestinationMenuAction;
import ro.amiq.dvt.diagrams.design.editor.actions.menu.DShowInSNDiagramMenuAction;
import ro.amiq.dvt.diagrams.design.editor.actions.menu.DShowSourceMenuAction;
import ro.amiq.dvt.diagrams.design.editor.actions.menu.DStepIntoMenuAction;
import ro.amiq.dvt.diagrams.design.editor.actions.menu.DStepOutMenuAction;
import ro.amiq.dvt.diagrams.design.editor.actions.menu.DTraceConnectionsMenuAction;
import ro.amiq.dvt.diagrams.editor.DMenuCascade;
import ro.amiq.dvt.diagrams.editor.DMenuItem;
import ro.amiq.dvt.diagrams.editor.DMenuSeparator;
import ro.amiq.dvt.draw.obj.interaction.DSelectable;
import ro.amiq.dvt.ui.trace.connections.utils.TCOperation;

public final class DMenuActionFactory
extends DMenuActionFactoryCommon {
    private static DMenuActionFactory INSTANCE;
    private static final Object SYNC_OBJECT;

    static {
        SYNC_OBJECT = new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DMenuActionFactory getInstance() {
        if (INSTANCE == null) {
            Object object = SYNC_OBJECT;
            synchronized (object) {
                INSTANCE = new DMenuActionFactory();
            }
        }
        return INSTANCE;
    }

    private DMenuActionFactory() {
    }

    @Override
    protected List<DMenuItem> createAction(DMenuActionKind kind, Set<DSelectable> selection, DDiagram dDiagram) {
        if (kind == null) {
            return null;
        }
        ArrayList<DMenuItem> items = new ArrayList<DMenuItem>();
        switch (kind) {
            case STEP_INTO: {
                items.add(new DStepIntoMenuAction(selection, dDiagram));
                break;
            }
            case STEP_OUT: {
                items.add(new DStepOutMenuAction(dDiagram));
                break;
            }
            case GO_TO_DECLARATION: {
                items.add(new DGoToDeclarationMenuAction(selection, dDiagram));
                break;
            }
            case GO_TO_SOURCE: {
                return this.createGoToSourceActions(selection, dDiagram);
            }
            case SHOW_CONNECTIONS: {
                items.add(new DShowConnectionsAroundMenuAction(selection, dDiagram));
                break;
            }
            case SHOW_CONNECTIONS_BETWEEN: {
                items.add(new DShowConnectionsBetweenMenuAction(selection, dDiagram, false));
                break;
            }
            case SHOW_CONNECTIONS_BETWEEN_FLOW_TO_SCHEMATIC: {
                items.add(new DShowConnectionsBetweenMenuAction(selection, dDiagram, true));
                break;
            }
            case SEPARATOR: {
                items.add(DMenuSeparator.INSTANCE);
                break;
            }
            case TRACE_DRIVE_AND_LOAD: {
                items.addAll(DMenuActionFactory.createTraceDriveAndLoadActions(selection, dDiagram));
                break;
            }
            case SHOW_IN_PF_DIAGRAM: {
                items.add(new DShowInSNDiagramMenuAction(selection, dDiagram));
                break;
            }
            case DELETE: {
                items.add(new DDeleteMenuAction(selection, dDiagram));
                break;
            }
            case COLLAPSE: {
                items.add(new DCollapseMenuAction(selection, dDiagram));
                break;
            }
            case EXPAND: {
                items.add(new DExpandMenuAction(selection, dDiagram));
                break;
            }
            case SHOW_DESTINATIONS: {
                items.add(new DShowDestinationMenuAction(selection, dDiagram));
                break;
            }
            case SHOW_SOURCES: {
                items.add(new DShowSourceMenuAction(selection, dDiagram));
                break;
            }
            case ADD: {
                items.add(new DAddToWaveformViewerMenuAction(selection, dDiagram));
                break;
            }
            case ADD_WITH_DRIVERS: {
                items.add(new DAddWithDriversMenuAction(selection, dDiagram));
                break;
            }
            case ADD_WITH_LOADS: {
                items.add(new DAddWithLoadsMenuAction(selection, dDiagram));
                break;
            }
            case REVEAL: {
                items.add(new DRevealInWaveformViewer(selection, dDiagram));
                break;
            }
            case ADD_PORTS: {
                items.add(new DAddPortsToWaveformViewerMenuAction(selection, dDiagram));
                break;
            }
            case ADD_ALL_SIGNALS: {
                items.add(new DAddAllSignalsToWaveformViewerMenuAction(selection, dDiagram));
                break;
            }
        }
        return items.size() == 1 && ((DMenuItem)items.get(0)).isVisible() ? items : null;
    }

    private static List<DMenuItem> createTraceDriveAndLoadActions(Set<DSelectable> selection, DDiagram diagram) {
        DTraceConnectionsMenuAction traceDriveAndLoad;
        DTraceConnectionsMenuAction traceLoad;
        ArrayList<DMenuItem> subActions = new ArrayList<DMenuItem>();
        DTraceConnectionsMenuAction traceDrive = new DTraceConnectionsMenuAction(selection, diagram, TCOperation.DRIVE);
        if (traceDrive.isVisible()) {
            subActions.add(traceDrive);
        }
        if ((traceLoad = new DTraceConnectionsMenuAction(selection, diagram, TCOperation.LOAD)).isVisible()) {
            subActions.add(traceLoad);
        }
        if ((traceDriveAndLoad = new DTraceConnectionsMenuAction(selection, diagram, TCOperation.DRIVE_AND_LOAD)).isVisible()) {
            subActions.add(traceDriveAndLoad);
        }
        DMenuCascade cascade = new DMenuCascade(DMenuActionMessages.traceTitle, subActions);
        return Collections.singletonList(cascade);
    }
}

