/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.diagrams.design.editor.actions.menu;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import ro.amiq.dvt.diagrams.DDiagram;
import ro.amiq.dvt.diagrams.design.editor.actions.menu.DGoToSourceMenuAction;
import ro.amiq.dvt.diagrams.design.editor.actions.menu.DMenuActionKind;
import ro.amiq.dvt.diagrams.design.editor.actions.menu.DMenuActionMessages;
import ro.amiq.dvt.diagrams.editor.DMenuCascade;
import ro.amiq.dvt.diagrams.editor.DMenuItem;
import ro.amiq.dvt.diagrams.editor.DMenuSeparator;
import ro.amiq.dvt.diagrams.klay.utils.KLayDrawUtils;
import ro.amiq.dvt.diagrams.netlist.model.INLViewSelectable;
import ro.amiq.dvt.diagrams.netlist.model.INLViewSelectable2;
import ro.amiq.dvt.diagrams.netlist.model.NLGate;
import ro.amiq.dvt.draw.obj.interaction.DSelectable;
import ro.amiq.dvt.model.reflection.GoToInfo;
import ro.amiq.dvt.ui.waveviewer.DVTWaveViewIDEFactory;

public abstract class DMenuActionFactoryCommon {
    protected List<DMenuItem> createGoToSourceActions(Set<DSelectable> selection, DDiagram diagram) {
        Set<GoToInfo> goTos = KLayDrawUtils.getUniqueGoToInfos(selection);
        if (goTos.isEmpty()) {
            return Collections.emptyList();
        }
        if (goTos.size() == 1) {
            DGoToSourceMenuAction gotoAction = new DGoToSourceMenuAction(selection, goTos.iterator().next(), diagram, DMenuActionMessages.goToSourceTitle);
            return gotoAction.isVisible() ? Collections.singletonList(gotoAction) : Collections.emptyList();
        }
        ArrayList<GoToInfo> goToList = new ArrayList<GoToInfo>(goTos);
        Collections.sort(goToList);
        ArrayList<DMenuItem> subActions = new ArrayList<DMenuItem>(goToList.size());
        for (GoToInfo goTo : goToList) {
            DGoToSourceMenuAction gotoAction = new DGoToSourceMenuAction(selection, goTo, diagram, this.makeText(goTo));
            if (!gotoAction.isVisible()) continue;
            subActions.add(gotoAction);
        }
        DMenuCascade cascade = new DMenuCascade(DMenuActionMessages.goToSourceTitle, subActions);
        return Collections.singletonList(cascade);
    }

    private String makeText(GoToInfo marker) {
        if (marker == null) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        result.append("Line ").append(marker.line);
        if (marker.filePath == null) {
            return result.toString();
        }
        File markerFile = new File(marker.filePath);
        result.append(" in '").append(markerFile.getName()).append("'");
        return result.toString();
    }

    public List<DMenuItem> createActions(List<DMenuActionKind> kinds, Set<DSelectable> selection, DDiagram diagram) {
        DMenuCascade waveformViewerActionsMenu;
        INLViewSelectable2 selectable;
        if (kinds == null || kinds.isEmpty() || diagram == null) {
            return Collections.emptyList();
        }
        if (selection == null || selection.isEmpty()) {
            return this.createAction(DMenuActionKind.STEP_OUT, selection, diagram);
        }
        Set<GoToInfo> goTos = KLayDrawUtils.getUniqueGoToInfos(selection);
        if (selection.size() == 1 && (selectable = KLayDrawUtils.getNLViewSelectable2(selection.iterator().next())) instanceof NLGate && ((NLGate)((Object)selectable)).isTopGate()) {
            DMenuCascade waveformViewerActionsMenu2;
            List<DMenuItem> showInPFDiagramAction;
            List<DMenuItem> showAllConnectionsAction;
            List<DMenuItem> expandAction;
            List<DMenuItem> showSourcesAction;
            List<DMenuItem> showDestinationsAction;
            ArrayList<DMenuItem> actions = new ArrayList<DMenuItem>();
            List<DMenuItem> stepOutAction = this.createAction(DMenuActionKind.STEP_OUT, selection, diagram);
            if (stepOutAction != null) {
                actions.addAll(stepOutAction);
            }
            if ((showDestinationsAction = this.createAction(DMenuActionKind.SHOW_DESTINATIONS, selection, diagram)) != null) {
                actions.addAll(showDestinationsAction);
            }
            if ((showSourcesAction = this.createAction(DMenuActionKind.SHOW_SOURCES, selection, diagram)) != null) {
                actions.addAll(showSourcesAction);
            }
            if ((expandAction = this.createAction(DMenuActionKind.EXPAND, selection, diagram)) != null) {
                if (!actions.isEmpty()) {
                    actions.add(DMenuSeparator.INSTANCE);
                }
                actions.addAll(expandAction);
            }
            if (!goTos.isEmpty()) {
                if (!actions.isEmpty()) {
                    actions.add(DMenuSeparator.INSTANCE);
                }
                actions.addAll(this.createAction(DMenuActionKind.GO_TO_SOURCE, selection, diagram));
            }
            if ((showAllConnectionsAction = this.createAction(DMenuActionKind.SHOW_CONNECTIONS, selection, diagram)) != null) {
                if (!actions.isEmpty()) {
                    actions.add(DMenuSeparator.INSTANCE);
                }
                actions.addAll(showAllConnectionsAction);
            }
            if ((showInPFDiagramAction = this.createAction(DMenuActionKind.SHOW_IN_PF_DIAGRAM, selection, diagram)) != null) {
                if (!actions.isEmpty()) {
                    actions.add(DMenuSeparator.INSTANCE);
                }
                actions.addAll(showInPFDiagramAction);
            }
            if (DVTWaveViewIDEFactory.getInstance().isVcdSetAsInput(diagram.getProject()) && (waveformViewerActionsMenu2 = this.getWaveformViewerActionsMenu(selection, diagram)) != null) {
                actions.add(DMenuSeparator.INSTANCE);
                actions.add(waveformViewerActionsMenu2);
            }
            return actions;
        }
        ArrayList<DMenuItem> items = new ArrayList<DMenuItem>();
        for (DMenuActionKind kind : kinds) {
            List<DMenuItem> actionItems = this.createAction(kind, selection, diagram);
            if (actionItems == null || actionItems.isEmpty() || actionItems.get(0) == DMenuSeparator.INSTANCE && (items.isEmpty() || items.get(items.size() - 1) == DMenuSeparator.INSTANCE)) continue;
            items.addAll(actionItems);
        }
        if (DVTWaveViewIDEFactory.getInstance().isVcdSetAsInput(diagram.getProject()) && (waveformViewerActionsMenu = this.getWaveformViewerActionsMenu(selection, diagram)) != null) {
            items.add(waveformViewerActionsMenu);
        }
        if (items.isEmpty()) {
            return items;
        }
        if (items.get(items.size() - 1) == DMenuSeparator.INSTANCE) {
            items.remove(items.size() - 1);
        }
        return items;
    }

    protected DMenuCascade getWaveformViewerActionsMenu(Set<DSelectable> selection, DDiagram diagram) {
        Set<DSelectable> uniqueElements = this.getUniqueSelectionElements(selection);
        if (uniqueElements.isEmpty()) {
            return null;
        }
        ArrayList<DMenuItem> subActions = new ArrayList<DMenuItem>();
        List<DMenuActionKind> actions = DVTWaveViewIDEFactory.getInstance().getDiagramActions(uniqueElements);
        for (DMenuActionKind action : actions) {
            List<DMenuItem> actionItems = this.createAction(action, uniqueElements, diagram);
            if (actionItems == null || actionItems.isEmpty() || subActions.isEmpty() && actionItems.get(0) == DMenuSeparator.INSTANCE) continue;
            subActions.addAll(actionItems);
        }
        if (subActions.isEmpty()) {
            return null;
        }
        return new DMenuCascade("Waveform Viewer", subActions);
    }

    private Set<DSelectable> getUniqueSelectionElements(Set<DSelectable> selection) {
        HashSet<INLViewSelectable> uniqueSelectables = new HashSet<INLViewSelectable>();
        LinkedHashSet<DSelectable> uniqueSelection = new LinkedHashSet<DSelectable>();
        for (DSelectable selectionItem : selection) {
            INLViewSelectable selectableItem = KLayDrawUtils.getNLViewSelectable(selectionItem);
            if (selectableItem == null || !uniqueSelectables.add(selectableItem)) continue;
            uniqueSelection.add(selectionItem);
        }
        return uniqueSelection;
    }

    protected abstract List<DMenuItem> createAction(DMenuActionKind var1, Set<DSelectable> var2, DDiagram var3);
}

