/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.diagrams.design.editor.actions.menu;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import ro.amiq.dvt.diagrams.DDiagram;
import ro.amiq.dvt.diagrams.design.DFlowDiagram;
import ro.amiq.dvt.diagrams.design.DSchematicDiagram;
import ro.amiq.dvt.diagrams.design.DTopPathDiagram;
import ro.amiq.dvt.diagrams.design.editor.DDesignEditorFactory;
import ro.amiq.dvt.diagrams.design.editor.actions.menu.DMenuActionKind;
import ro.amiq.dvt.diagrams.editor.DMenuAction;
import ro.amiq.dvt.diagrams.editor.DMenuActionCommon;
import ro.amiq.dvt.diagrams.editor.DiagramBreadcrumbUtils;
import ro.amiq.dvt.diagrams.klay.utils.KLayDrawUtils;
import ro.amiq.dvt.diagrams.netlist.model.NLAbstractBase;
import ro.amiq.dvt.diagrams.netlist.model.NLConnection;
import ro.amiq.dvt.diagrams.netlist.model.NLGate;
import ro.amiq.dvt.diagrams.netlist.model.NLGateKind;
import ro.amiq.dvt.diagrams.netlist.model.NLInstanceGate;
import ro.amiq.dvt.diagrams.netlist.model.NLParameters;
import ro.amiq.dvt.diagrams.netlist.model.NLPort;
import ro.amiq.dvt.diagrams.netlist.utils.NLConfig;
import ro.amiq.dvt.diagrams.netlist.utils.NLUtils;
import ro.amiq.dvt.draw.obj.interaction.DSelectable;
import ro.amiq.dvt.ui.editor.breadcrumb.BreadcrumbInput;
import ro.amiq.dvt.ui.editor.breadcrumb.BreadcrumbSegment;

public abstract class DShowConnectionsAroundMenuActionCommon
extends DMenuAction {
    protected Set<NLAbstractBase> validElements = new HashSet<NLAbstractBase>();

    public DShowConnectionsAroundMenuActionCommon(Set<DSelectable> selection, DDiagram dDiagram, String text) {
        super(dDiagram, text);
        if (!(this.getDiagram() instanceof DSchematicDiagram) && !(this.getDiagram() instanceof DFlowDiagram)) {
            return;
        }
        List<BreadcrumbSegment> breadcrumbSegments = this.getBreadcrumbSegments();
        for (DSelectable selectable : selection) {
            NLGate enclosingGate;
            NLInstanceGate gate = KLayDrawUtils.unwrapNLViewObject(selectable, NLInstanceGate.class);
            NLConnection connection = KLayDrawUtils.unwrapNLViewObject(selectable, NLConnection.class);
            NLPort port = KLayDrawUtils.unwrapNLViewObject(selectable, NLPort.class);
            if (!(gate == null || gate.getKind() != NLGateKind.DESIGN && gate.getKind() != NLGateKind.INSTANCE && gate.getKind() != NLGateKind.LOGIC && gate.getKind() != NLGateKind.BUNDLE || (breadcrumbSegments == null || breadcrumbSegments.size() <= 1) && gate.isTopGate())) {
                this.validElements.add(gate);
            }
            if (connection != null && !(this.getDiagram() instanceof DFlowDiagram)) {
                this.validElements.add(connection);
            }
            if (port == null || this.getDiagram() instanceof DFlowDiagram || (enclosingGate = port.getEnclosingGate()).getKind() != NLGateKind.DESIGN && enclosingGate.getKind() != NLGateKind.INSTANCE && enclosingGate.getKind() != NLGateKind.LOGIC && enclosingGate.getKind() != NLGateKind.BUNDLE) continue;
            this.validElements.add(port);
        }
    }

    @Override
    public boolean isVisible() {
        if (this.validElements.isEmpty()) {
            return false;
        }
        NLGate firstEnclosingGate = null;
        Object prevElement = null;
        for (NLAbstractBase element : this.validElements) {
            if (firstEnclosingGate == null) {
                firstEnclosingGate = element.getEnclosingGate();
            } else if (firstEnclosingGate != element.getEnclosingGate()) {
                return false;
            }
            if (prevElement != null && (prevElement.getClass().isInstance(element.getClass()) || element.getClass().isInstance(prevElement.getClass()))) {
                return false;
            }
            prevElement = element;
        }
        return true;
    }

    @Override
    public void run() {
        DTopPathDiagram diagram = (DTopPathDiagram)this.getDiagram();
        NLConfig newConfig = new NLConfig(diagram.getConfig());
        newConfig.setReduceGates(false);
        newConfig.setReducePorts(false);
        NLUtils.SelectionNewModel changeFlagResult = NLUtils.copyModelForSelection(this.validElements, newConfig, NLParameters.NLParametersFlag.IS_ACTION_SELECTED);
        newConfig.setTopInstance(changeFlagResult.getTopGate());
        NLAbstractBase firstSelectedElement = changeFlagResult.getSelection().iterator().next();
        DMenuActionCommon.TopInstanceResult topUpdateResult = null;
        topUpdateResult = firstSelectedElement instanceof NLGate && ((NLGate)firstSelectedElement).isTopGate() || firstSelectedElement instanceof NLPort && ((NLPort)firstSelectedElement).getEnclosingGate().isTopGate() ? this.getBreadcrumbUpwardsOf(newConfig.getTopInstance()) : this.getBreadcrumbDownwardOf(firstSelectedElement, changeFlagResult.getSelection());
        if (topUpdateResult == null) {
            newConfig.setTopInstance(changeFlagResult.getTopGate());
            topUpdateResult = new DMenuActionCommon.TopInstanceResult(diagram.getTopPath(), diagram.getNamedElement(), null, null);
        }
        newConfig.setActionKind(DMenuActionKind.SHOW_CONNECTIONS);
        newConfig.setBreadcrumbInput(new BreadcrumbInput(diagram.getProject(), topUpdateResult.getBreadcrumbSegments(), DiagramBreadcrumbUtils.getInstance().getBreadcrumbSerializer()));
        DDesignEditorFactory editorFactory = diagram instanceof DFlowDiagram ? DDesignEditorFactory.getInstance().newActionFlowDiagram(topUpdateResult.getNamedElement(), newConfig, topUpdateResult.getInstancePath(), topUpdateResult.getCopyElements()) : DDesignEditorFactory.getInstance().newActionDiagram(1, topUpdateResult.getNamedElement(), newConfig, topUpdateResult.getInstancePath(), topUpdateResult.getCopyElements());
        this.openEditor(editorFactory);
    }
}

