/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.diagrams.design.editor.actions.menu;

import java.util.HashSet;
import java.util.Set;
import ro.amiq.dvt.diagrams.DDiagram;
import ro.amiq.dvt.diagrams.design.DFlowDiagram;
import ro.amiq.dvt.diagrams.design.DSchematicDiagram;
import ro.amiq.dvt.diagrams.design.DTopPathDiagram;
import ro.amiq.dvt.diagrams.design.editor.DDesignEditorFactory;
import ro.amiq.dvt.diagrams.design.editor.actions.menu.DMenuActionKind;
import ro.amiq.dvt.diagrams.design.editor.actions.menu.DMenuActionMessages;
import ro.amiq.dvt.diagrams.editor.DMenuAction;
import ro.amiq.dvt.diagrams.klay.utils.KLayDrawUtils;
import ro.amiq.dvt.diagrams.netlist.model.NLAbstractBase;
import ro.amiq.dvt.diagrams.netlist.model.NLGateKind;
import ro.amiq.dvt.diagrams.netlist.model.NLInstanceGate;
import ro.amiq.dvt.diagrams.netlist.model.NLParameters;
import ro.amiq.dvt.diagrams.netlist.utils.NLConfig;
import ro.amiq.dvt.diagrams.netlist.utils.NLUtils;
import ro.amiq.dvt.draw.obj.interaction.DSelectable;

public class DShowConnectionsBetweenMenuAction
extends DMenuAction {
    private Set<NLAbstractBase> validElements = new HashSet<NLAbstractBase>();
    private boolean flowToSchematic;

    public DShowConnectionsBetweenMenuAction(Set<DSelectable> selection, DDiagram dDiagram, boolean flowToSchematic) {
        super(dDiagram, flowToSchematic ? DMenuActionMessages.showConnectionsBetweenFlowToSchematicTitle : DMenuActionMessages.showConnectionsBetweenTitle);
        this.flowToSchematic = flowToSchematic;
        if (!(this.getDiagram() instanceof DSchematicDiagram && !flowToSchematic || this.getDiagram() instanceof DFlowDiagram)) {
            return;
        }
        for (DSelectable selectable : selection) {
            NLInstanceGate gate = KLayDrawUtils.unwrapNLViewObject(selectable, NLInstanceGate.class);
            if (gate == null) {
                this.validElements.clear();
                return;
            }
            NLGateKind kind = gate.getKind();
            if (kind != NLGateKind.DESIGN && kind != NLGateKind.INSTANCE) continue;
            this.validElements.add(gate);
        }
    }

    @Override
    public boolean isVisible() {
        return this.validElements.size() >= 2;
    }

    @Override
    public void run() {
        DTopPathDiagram diagram = (DTopPathDiagram)this.getDiagram();
        NLConfig newConfig = new NLConfig(diagram.getConfig());
        newConfig.setReduceGates(false);
        newConfig.setReducePorts(false);
        newConfig.setActionKind(this.flowToSchematic ? DMenuActionKind.SHOW_CONNECTIONS_BETWEEN_FLOW_TO_SCHEMATIC : DMenuActionKind.SHOW_CONNECTIONS_BETWEEN);
        newConfig.setTopInstance(NLUtils.copyModelForSelection(this.validElements, diagram.getConfig(), NLParameters.NLParametersFlag.IS_ACTION_SELECTED).getTopGate());
        newConfig.setBreadcrumbInput(diagram.getConfig().getBreadcrumbInput());
        DDesignEditorFactory editorFactory = diagram instanceof DFlowDiagram && !this.flowToSchematic ? DDesignEditorFactory.getInstance().newActionFlowDiagram(diagram.getNamedElement(), newConfig, diagram.getTopPath()) : DDesignEditorFactory.getInstance().newActionDiagram(this.getDepth(diagram), diagram.getNamedElement(), newConfig, diagram.getTopPath());
        this.openEditor(editorFactory);
    }
}

