/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.diagrams.design.editor.actions.menu;

import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import ro.amiq.dvt.diagrams.DDiagram;
import ro.amiq.dvt.diagrams.design.DPFDiagram;
import ro.amiq.dvt.diagrams.design.DTopPathDiagram;
import ro.amiq.dvt.diagrams.design.editor.DDesignEditorFactory;
import ro.amiq.dvt.diagrams.design.editor.actions.menu.DMenuActionMessages;
import ro.amiq.dvt.diagrams.editor.DMenuAction;
import ro.amiq.dvt.diagrams.klay.utils.KLayDrawUtils;
import ro.amiq.dvt.diagrams.netlist.model.NLInstanceGate;
import ro.amiq.dvt.diagrams.netlist.model.NLPDInstanceGate;
import ro.amiq.dvt.diagrams.netlist.utils.NLConfig;
import ro.amiq.dvt.diagrams.netlist.utils.NLUtils;
import ro.amiq.dvt.draw.obj.interaction.DSelectable;
import ro.amiq.dvt.power.format.DVTPFModel;
import ro.amiq.dvt.utils.Utils;

public class DShowInSNDiagramMenuAction
extends DMenuAction {
    Set<String> selectedPDs = new LinkedHashSet<String>();
    private Set<DSelectable> selection;

    public DShowInSNDiagramMenuAction(Set<DSelectable> selection, DDiagram dDiagram) {
        super(dDiagram, DMenuActionMessages.showInSNDiagram);
        this.selection = selection;
    }

    @Override
    public boolean isVisible() {
        if (this.selection == null || this.selection.isEmpty()) {
            return false;
        }
        for (DSelectable sel : this.selection) {
            NLInstanceGate instanceGate = KLayDrawUtils.unwrapNLViewObject(sel, NLInstanceGate.class);
            if (instanceGate == null) continue;
            String pdName = null;
            if (instanceGate instanceof NLPDInstanceGate) {
                pdName = ((NLPDInstanceGate)instanceGate).getPowerDomainName();
            } else {
                DVTPFModel pfModel;
                if (!Utils.isDiagramsShowPDInfo() || (pfModel = NLUtils.getPFModel(instanceGate)) == null) continue;
                pdName = pfModel.getPDNameForPath(NLUtils.getGatePathToTop(instanceGate));
            }
            if (pdName == null) continue;
            this.selectedPDs.add(pdName);
        }
        return !this.selectedPDs.isEmpty();
    }

    @Override
    public void run() {
        NLConfig config = null;
        IProject project = null;
        DDiagram dDiagram = this.getDiagram();
        if (dDiagram instanceof DTopPathDiagram) {
            DTopPathDiagram diagram = (DTopPathDiagram)dDiagram;
            config = diagram.getConfig();
            project = diagram.getProject();
        } else if (dDiagram instanceof DPFDiagram) {
            DPFDiagram diagram = (DPFDiagram)dDiagram;
            config = diagram.getConfig();
            project = diagram.getProject();
        }
        if (config == null || project == null) {
            return;
        }
        DDesignEditorFactory.getInstance().newPowerDomainsDiagramWithSelection(project, config, this.selectedPDs).openEditor();
    }
}

