/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.diagrams.design.editor.actions.menu;

import java.util.HashSet;
import java.util.Set;
import ro.amiq.dvt.diagrams.DDiagram;
import ro.amiq.dvt.diagrams.design.DSchematicDiagram;
import ro.amiq.dvt.diagrams.design.editor.actions.menu.DShowNextConnectionsLevelAction;
import ro.amiq.dvt.diagrams.klay.utils.KLayDrawUtils;
import ro.amiq.dvt.diagrams.netlist.model.NLGate;
import ro.amiq.dvt.diagrams.netlist.model.NLGateKind;
import ro.amiq.dvt.diagrams.netlist.model.NLParameters;
import ro.amiq.dvt.diagrams.netlist.model.NLPort;
import ro.amiq.dvt.draw.obj.interaction.DSelectable;

public class DShowSourceMenuAction
extends DShowNextConnectionsLevelAction {
    public DShowSourceMenuAction(Set<DSelectable> selection, DDiagram dDiagram) {
        super(dDiagram, NLParameters.NLParametersFlag.SHOW_SOURCES);
        this.validElements = new HashSet();
        if (!(this.getDiagram() instanceof DSchematicDiagram)) {
            return;
        }
        for (DSelectable selected : selection) {
            this.checkPortValidity(KLayDrawUtils.unwrapNLViewObject(selected, NLPort.class));
            NLGate gate = KLayDrawUtils.unwrapNLViewObject(selected, NLGate.class);
            if (gate == null) continue;
            gate.getPorts().stream().filter(port -> port.getDirection() != NLPort.NLPortDirection.DIR_OUT).forEach(sourcePort -> this.checkPortValidity((NLPort)sourcePort));
        }
    }

    @Override
    public boolean isVisible() {
        return !this.validElements.isEmpty();
    }

    private void checkPortValidity(NLPort port) {
        if (port == null) {
            return;
        }
        NLGate enclosingGate = port.getEnclosingGate();
        if (enclosingGate.getKind() == NLGateKind.LOGIC && port.getDirection() == NLPort.NLPortDirection.DIR_OUT) {
            return;
        }
        if (enclosingGate.isTopGate() && port.getDirection() != NLPort.NLPortDirection.DIR_OUT) {
            String top = this.getTopDesignOfBreadcrumb();
            if (top == null || top.equals(enclosingGate.toString())) {
                return;
            }
            this.changeTop = true;
        }
        this.validElements.add(port);
    }
}

