/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.diagrams.design.editor.actions.menu;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IProject;
import ro.amiq.dvt.diagrams.DDiagram;
import ro.amiq.dvt.diagrams.design.DTopPathDiagram;
import ro.amiq.dvt.diagrams.design.editor.DDesignEditorFactory;
import ro.amiq.dvt.diagrams.design.editor.actions.menu.DMenuActionMessages;
import ro.amiq.dvt.diagrams.editor.DMenuAction;
import ro.amiq.dvt.diagrams.editor.DiagramBreadcrumbUtils;
import ro.amiq.dvt.diagrams.klay.utils.KLayDrawUtils;
import ro.amiq.dvt.diagrams.netlist.model.INLViewSelectable2;
import ro.amiq.dvt.diagrams.netlist.model.NLELInstanceGate;
import ro.amiq.dvt.diagrams.netlist.utils.NLConfig;
import ro.amiq.dvt.draw.obj.interaction.DSelectable;
import ro.amiq.dvt.elaboration.model.DiagramInstanceWrapper;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.ui.editor.breadcrumb.BreadcrumbInput;
import ro.amiq.dvt.ui.editor.breadcrumb.BreadcrumbSegment;

public class DStepIntoMenuAction
extends DMenuAction {
    private final Set<INLViewSelectable2.StepIntoWrapper> selectable;

    protected DStepIntoMenuAction(Set<DSelectable> selection, DDiagram dDiagram) {
        super(dDiagram, DMenuActionMessages.stepIntoTitle);
        this.selectable = selection.stream().map(KLayDrawUtils::getNLViewSelectable2).filter(sel -> sel != null && sel.hasStepInto()).map(INLViewSelectable2::stepInto).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    @Override
    public boolean isVisible() {
        return !this.selectable.isEmpty();
    }

    @Override
    public void run() {
        BreadcrumbInput breadcrumbInput = this.getBreadcrumbInput();
        boolean openNewEditor = this.selectable.size() > 1;
        for (INLViewSelectable2.StepIntoWrapper siw : this.selectable) {
            ArrayList<BreadcrumbSegment> breadcrumbSegments = null;
            if (breadcrumbInput != null) {
                List<BreadcrumbSegment> inputSegments = breadcrumbInput.getInputSegments();
                ArrayList<BreadcrumbSegment> inputPathElements = inputSegments == null ? new ArrayList<BreadcrumbSegment>() : new ArrayList<BreadcrumbSegment>(inputSegments);
                List<BreadcrumbSegment> gatePathElements = siw.gate.getPathSegments();
                if (gatePathElements != null) {
                    Collections.reverse(gatePathElements);
                    if (!inputPathElements.isEmpty()) {
                        gatePathElements.removeAll(inputPathElements);
                    }
                    inputPathElements.addAll(gatePathElements);
                    breadcrumbSegments = inputPathElements;
                }
            }
            IRfNamedElement instanceOrDesign = siw.gate instanceof NLELInstanceGate ? siw.gate.getMapping(DiagramInstanceWrapper.class).getDescription() : siw.gate.getMapping(IRfNamedElement.class);
            IProject project = this.getProject();
            if (project == null) continue;
            NLConfig config = new NLConfig(((DTopPathDiagram)this.getDiagram()).getConfig());
            config.setBreadcrumbInput(new BreadcrumbInput(project, breadcrumbSegments, DiagramBreadcrumbUtils.getInstance().getBreadcrumbSerializer()));
            DDesignEditorFactory editorFactory = siw.isFlowInstance ? DDesignEditorFactory.getInstance().newFlowDiagram(instanceOrDesign, config, siw.getTopPath()) : DDesignEditorFactory.getInstance().newSchematicDiagram(1, instanceOrDesign, config, siw.getTopPath());
            this.openEditor(editorFactory, openNewEditor);
        }
    }

    public int getNofSelectables() {
        return this.selectable.size();
    }
}

