/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.diagrams.design.editor.actions.menu;

import java.util.List;
import ro.amiq.dvt.diagrams.DDiagram;
import ro.amiq.dvt.diagrams.design.DBlockDiagram;
import ro.amiq.dvt.diagrams.design.DFlowDiagram;
import ro.amiq.dvt.diagrams.design.DSchematicDiagram;
import ro.amiq.dvt.diagrams.design.DTopPathDiagram;
import ro.amiq.dvt.diagrams.design.editor.DDesignEditorFactory;
import ro.amiq.dvt.diagrams.design.editor.actions.menu.DMenuActionMessages;
import ro.amiq.dvt.diagrams.editor.DMenuAction;
import ro.amiq.dvt.diagrams.editor.DMenuActionCommon;
import ro.amiq.dvt.diagrams.editor.DiagramBreadcrumbUtils;
import ro.amiq.dvt.diagrams.netlist.utils.NLConfig;
import ro.amiq.dvt.ui.editor.breadcrumb.BreadcrumbInput;
import ro.amiq.dvt.ui.editor.breadcrumb.BreadcrumbSegment;

public class DStepOutMenuAction
extends DMenuAction {
    protected DStepOutMenuAction(DDiagram dDiagram) {
        super(dDiagram, DMenuActionMessages.stepOutTitle);
    }

    @Override
    public boolean isVisible() {
        List<BreadcrumbSegment> breadcrumbSegments = this.getBreadcrumbSegments();
        return breadcrumbSegments != null && breadcrumbSegments.size() > 1;
    }

    @Override
    public void run() {
        DDiagram diagram = this.getDiagram();
        NLConfig oldConfig = ((DTopPathDiagram)diagram).getConfig();
        DMenuActionCommon.TopInstanceResult result = this.getBreadcrumbUpwardsOf(oldConfig.getTopInstance());
        if (result == null) {
            return;
        }
        NLConfig newConfig = new NLConfig(oldConfig);
        newConfig.setBreadcrumbInput(new BreadcrumbInput(diagram.getProject(), result.getBreadcrumbSegments(), DiagramBreadcrumbUtils.getInstance().getBreadcrumbSerializer()));
        DDesignEditorFactory editorFactory = null;
        if (diagram instanceof DFlowDiagram) {
            editorFactory = DDesignEditorFactory.getInstance().newFlowDiagram(result.getNamedElement(), newConfig, result.getInstancePath());
        } else if (diagram instanceof DSchematicDiagram) {
            editorFactory = DDesignEditorFactory.getInstance().newSchematicDiagram(1, result.getNamedElement(), newConfig, result.getInstancePath());
        } else if (diagram instanceof DBlockDiagram) {
            editorFactory = DDesignEditorFactory.getInstance().newBlockDiagram(result.getNamedElement(), newConfig, result.getInstancePath());
        }
        this.openEditor(editorFactory);
    }
}

