/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.diagrams.design.editor.actions.menu;

import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.keys.IBindingService;
import ro.amiq.dvt.diagrams.DDiagram;
import ro.amiq.dvt.diagrams.design.editor.actions.menu.DMenuActionMessages;
import ro.amiq.dvt.diagrams.editor.DMenuAction;
import ro.amiq.dvt.diagrams.klay.utils.KLayDrawUtils;
import ro.amiq.dvt.diagrams.netlist.model.INLViewSelectable3;
import ro.amiq.dvt.draw.obj.interaction.DSelectable;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.trace.connections.utils.TCOperation;
import ro.amiq.dvt.ui.trace.connections.utils.TCViewUtils;
import ro.amiq.dvt.ui.views.trace.connections.actions.ITCPropertyConstants;

public class DTraceConnectionsMenuAction
extends DMenuAction {
    private final Set<INLViewSelectable3> selectable;
    private final TCOperation operation;

    protected DTraceConnectionsMenuAction(Set<DSelectable> selection, DDiagram dDiagram, TCOperation operation) {
        super(dDiagram, DTraceConnectionsMenuAction.getNameWithKeyBinding(operation), DVTImages.imageCache.getImage(TCViewUtils.getImageForTraceOperation(operation)));
        this.operation = operation;
        HashSet<INLViewSelectable3> uniqueElements = new HashSet<INLViewSelectable3>();
        boolean isGoodCandidate = true;
        for (DSelectable sel2 : selection) {
            INLViewSelectable3 nlViewSelectable3 = KLayDrawUtils.getNLViewSelectable3(sel2);
            if (nlViewSelectable3 == null || uniqueElements.size() > 1) {
                isGoodCandidate = false;
                break;
            }
            uniqueElements.add(nlViewSelectable3);
        }
        this.selectable = isGoodCandidate ? uniqueElements.stream().filter(sel -> sel != null && sel.canTraceConnection()).collect(Collectors.toSet()) : Collections.emptySet();
    }

    @Override
    public boolean isVisible() {
        return this.selectable.size() == 1;
    }

    public TCOperation getOperation() {
        return this.operation;
    }

    public static String getNameWithKeyBinding(TCOperation operation) {
        StringBuilder label = new StringBuilder();
        label.append(operation == TCOperation.DRIVE ? DMenuActionMessages.traceDriveTitle : (operation == TCOperation.LOAD ? DMenuActionMessages.traceLoadTitle : DMenuActionMessages.traceDriveAndLoadTitle));
        String commandID = ITCPropertyConstants.getCommandID(operation);
        String keyBinding = null;
        IBindingService bindingService = (IBindingService)PlatformUI.getWorkbench().getAdapter(IBindingService.class);
        if (bindingService != null) {
            keyBinding = bindingService.getBestActiveBindingFormattedFor(commandID);
        }
        if (keyBinding != null) {
            label.append("\t").append(keyBinding);
        }
        return label.toString();
    }

    @Override
    public void run() {
        if (this.selectable.isEmpty()) {
            return;
        }
        Optional findFirst = this.selectable.stream().findFirst();
        if (!findFirst.isPresent()) {
            return;
        }
        INLViewSelectable3 selected = (INLViewSelectable3)findFirst.get();
        selected.traceConnection(this.getOperation());
    }
}

