/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.diagrams.design.editor.actions.menu;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import ro.amiq.dvt.diagrams.DDiagram;
import ro.amiq.dvt.diagrams.editor.DMenuAction;
import ro.amiq.dvt.diagrams.netlist.model.NLGate;
import ro.amiq.dvt.diagrams.netlist.model.NLGateKind;
import ro.amiq.dvt.diagrams.netlist.model.NLInstanceGate;
import ro.amiq.dvt.diagrams.netlist.model.NLPort;
import ro.amiq.dvt.draw.obj.interaction.DSelectable;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.GoToInfo;
import ro.amiq.dvt.model.reflection.GoToInfoWithBreadcrumbElement;
import ro.amiq.dvt.model.reflection.IRfBreadcrumbElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.ui.editor.breadcrumb.BreadcrumbInput;

public abstract class DWaveformViewerMenuAction
extends DMenuAction {
    protected Set<DSelectable> selection;

    protected DWaveformViewerMenuAction(Set<DSelectable> selection, DDiagram diagram, String text) {
        super(diagram, text);
        this.selection = selection;
    }

    protected ElementPath getPathFromBreadcrumb() {
        BreadcrumbInput breadcrumbInput = this.getBreadcrumbInput();
        if (breadcrumbInput == null) {
            return null;
        }
        return breadcrumbInput.getElementPath(true);
    }

    protected ElementPath getElementPathFromPort(NLPort port) {
        NLGate enclosingGate = port.getEnclosingGate();
        if (!(enclosingGate instanceof NLInstanceGate)) {
            return null;
        }
        return this.getElementPathFromGate((NLInstanceGate)enclosingGate);
    }

    protected ElementPath getElementPathFromGate(NLInstanceGate gate) {
        if (gate == null) {
            return null;
        }
        if (gate.getKind() == NLGateKind.LOGIC) {
            gate = gate.getEnclosingGate();
        }
        if (gate == null) {
            return null;
        }
        ElementPath elementPath = this.getPathFromBreadcrumb();
        if (elementPath == null) {
            return null;
        }
        ArrayDeque<String> enclosingGatesPath = new ArrayDeque<String>();
        while (gate != null && !gate.isTopGate()) {
            enclosingGatesPath.addFirst(gate.getName());
            gate = gate.getEnclosingGate();
        }
        return ElementPath.join(elementPath, new ArrayList<String>(enclosingGatesPath));
    }

    protected IRfNamedElement getElementFromPort(NLPort port) {
        Collection<GoToInfo> goToSource = port.getGoToSource();
        if (goToSource == null || goToSource.isEmpty()) {
            return null;
        }
        GoToInfo goToInfo = goToSource.iterator().next();
        if (!(goToInfo instanceof GoToInfoWithBreadcrumbElement)) {
            return null;
        }
        IRfBreadcrumbElement element = ((GoToInfoWithBreadcrumbElement)goToInfo).element;
        if (!(element instanceof IRfNamedElement)) {
            return null;
        }
        return (IRfNamedElement)element;
    }
}

