/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.diagrams.editor;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IReusableEditor;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.contexts.IContextActivation;
import org.eclipse.ui.contexts.IContextService;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.IDVTConstants;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.diagrams.DDiagram;
import ro.amiq.dvt.diagrams.DProgressMonitor;
import ro.amiq.dvt.diagrams.ch.CHActionDiagram;
import ro.amiq.dvt.diagrams.ch.CHDiagram;
import ro.amiq.dvt.diagrams.ch.CHDiagram2;
import ro.amiq.dvt.diagrams.ch.ICHDiagram;
import ro.amiq.dvt.diagrams.ch.utils.CHConfig;
import ro.amiq.dvt.diagrams.design.DSchematicDiagram;
import ro.amiq.dvt.diagrams.design.DTopPathDiagram;
import ro.amiq.dvt.diagrams.editor.DDiagramEditorCommon;
import ro.amiq.dvt.diagrams.editor.DDiagramEditorInput;
import ro.amiq.dvt.diagrams.editor.DDiagramEditorSelection;
import ro.amiq.dvt.diagrams.editor.DMessages;
import ro.amiq.dvt.diagrams.editor.DMouseManager;
import ro.amiq.dvt.diagrams.editor.DSearchManager;
import ro.amiq.dvt.diagrams.editor.DTransitionTableContributor;
import ro.amiq.dvt.diagrams.editor.DiagramBreadcrumbUtils;
import ro.amiq.dvt.diagrams.editor.VHDiagramBreadcrumbUtils;
import ro.amiq.dvt.diagrams.editor.actions.DInspectLayoutDialog;
import ro.amiq.dvt.diagrams.editor.actions.DPinAction;
import ro.amiq.dvt.diagrams.editor.actions.DSaveAsDialog;
import ro.amiq.dvt.diagrams.editor.utils.DEditorToolbarDialogAction;
import ro.amiq.dvt.diagrams.fsm.FSMDiagram;
import ro.amiq.dvt.diagrams.fsm.FSMDiagramConfiguration;
import ro.amiq.dvt.diagrams.fsm.editor.FSMTransitionTable;
import ro.amiq.dvt.diagrams.fsm.editor.FSMTransitionTableData;
import ro.amiq.dvt.diagrams.fsm.editor.actions.menu.DFSMActionMessages;
import ro.amiq.dvt.diagrams.netlist.utils.NLConfig;
import ro.amiq.dvt.diagrams.preferences.DiagramPreferenceAdapter;
import ro.amiq.dvt.draw.DCanvas;
import ro.amiq.dvt.draw.debug.DDebug;
import ro.amiq.dvt.draw.debug.DNullDebug;
import ro.amiq.dvt.draw.obj.base.DObject;
import ro.amiq.dvt.draw.obj.interaction.DSelectable;
import ro.amiq.dvt.draw.obj.primitive.DText;
import ro.amiq.dvt.draw.utils.FontFactory;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.test.Objection;
import ro.amiq.dvt.test.ObjectionManager;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.SimpleDVTNotification;
import ro.amiq.dvt.ui.TextDelayedModifyListener;
import ro.amiq.dvt.ui.Utils;
import ro.amiq.dvt.ui.editor.DVTProjectionViewer;
import ro.amiq.dvt.ui.editor.breadcrumb.AbstractBreadcrumbConfiguration;
import ro.amiq.dvt.ui.editor.breadcrumb.AbstractBreadcrumbUtils;
import ro.amiq.dvt.ui.editor.breadcrumb.AbstractBreadcrumbUtilsCommon;
import ro.amiq.dvt.ui.editor.breadcrumb.AbstractBreadcrumbViewer;
import ro.amiq.dvt.ui.editor.breadcrumb.BreadcrumbInput;
import ro.amiq.dvt.ui.editor.breadcrumb.BreadcrumbSegment;
import ro.amiq.dvt.ui.editor.dhbreadcrumb.DHBreadcrumbViewer;
import ro.amiq.dvt.ui.editor.floatingwidgets.FMouseDownFilterListener;
import ro.amiq.dvt.ui.editor.floatingwidgets.FWidgetFactory;
import ro.amiq.dvt.ui.editor.floatingwidgets.IFNotificationHost;
import ro.amiq.dvt.ui.editor.vhbreadcrumb.VHBreadcrumbUtils;
import ro.amiq.dvt.ui.editor.vhbreadcrumb.VHBreadcrumbViewer;
import ro.amiq.dvt.ui.utils.DVTColorUtil;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;
import ro.amiq.dvt.ui.views.inspect.DVTInspectViewUtils;
import ro.amiq.dvt.ui.views.inspect.InspectViewComponent;
import ro.amiq.dvt.ui.waveviewer.DVTWaveViewIDEFactory;
import ro.amiq.dvt.utils.StoppableJob;

public class DDiagramEditor
extends DDiagramEditorCommon
implements IReusableEditor,
IFNotificationHost {
    public static final String ID = "ro.amiq.dvt.diagrams.editor";
    private static final String DESIGN_DIAGRAM_CONTEXT = "ro.amiq.dvt.diagrams.design.editor.actions.context";
    private static final String FSM_DIAGRAM_CONTEXT = "{0}.diagrams.fsm.editor.actions.context";
    private Composite fNotificationsHostComposite;
    private Composite fControlParent;
    private Composite fTopContainer;
    private DHBreadcrumbViewer fDHBreadcrumbViewer;
    private VHBreadcrumbViewer fVHBreadcrumbViewer;
    private final Listener sashFormResizeListener = new Listener(){

        public void handleEvent(Event event) {
            DDiagramEditor.this.applyInspectLayout();
        }
    };
    private final ISelectionChangedListener inspectSelectionChangedListener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent event) {
            if (event.getSelection().isEmpty()) {
                return;
            }
            Display.getDefault().asyncExec(() -> DDiagramEditor.this.inspectComponent.update(DVTInspectViewUtils.getInstance().createEventFromDiagramSelection((DDiagramEditorSelection)event.getSelection())));
        }
    };
    private final IPropertyChangeListener inspectLayoutPreferenceListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            if ("inspect.diagram_editor_layout".equals(event.getProperty())) {
                DDiagramEditor.this.setInspectLayout((String)event.getNewValue());
            }
        }
    };
    private final IPropertyChangeListener transitionTableEnabledPreferenceListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            if ("designdiagrams.fsm_transition_table_disabled".equals(event.getProperty())) {
                DDiagramEditor.this.setTransitionTableDisabled((Boolean)event.getNewValue());
            }
        }
    };
    private final Action searchFocusAction = new Action("Search"){

        public void run() {
            DDiagramEditor.this.searchText.setFocus();
            DDiagramEditor.this.searchText.selectAll();
        }
    };
    private final Action searchClearAction = new Action("Clear", DVTImages.CLEAR_QUICK_SEARCH){

        public void run() {
            DDiagramEditor.this.searchText.setText("");
            DDiagramEditor.this.canvas.setFocus();
        }
    };
    private final Action searchPreviousAction = new Action("Previous", DVTImages.SEARCH_PREV_A){

        public void run() {
            DDiagramEditor.this.searchManager.previousMatch();
        }
    };
    private final Action searchNextAction = new Action("Next", DVTImages.SEARCH_NEXT_A){

        public void run() {
            DDiagramEditor.this.searchManager.nextMatch();
        }
    };
    private IContextActivation inspectContext;
    private IContextActivation diagramContext;
    private DDiagramEditorCommon.InspectLayout inspectLayout;
    private boolean isPinned = false;
    private ToolBarManager toolBarManager;
    private SashForm sashForm;
    private SashForm sashFormParent;
    private Text searchText;
    private Label searchMatchesLabel;
    private Composite waveformInfoBar;
    private Label waveformInfoText;
    private InspectViewComponent inspectComponent;
    private DSearchManager searchManager;
    private DPinAction pinAction;
    private DEditorToolbarDialogAction inspectLayoutAction;
    private DEditorToolbarDialogAction saveAsAction;
    private StoppableJob updateJob;
    private boolean hideSideEffects;
    private FocusListener fFocusListener;
    private final ListenerList[] selectionChangedListenerLists = new ListenerList[]{staticSelectionChangedListeners, this.selectionChangedListeners};

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        site.setSelectionProvider((ISelectionProvider)this);
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        this.setPinned(false);
    }

    public void createPartControl(Composite parent) {
        this.createNotificationsHostComposite(parent);
        GridLayoutFactory.fillDefaults().numColumns(2).spacing(1, 0).applyTo(this.fControlParent);
        this.toolBarManager = new ToolBarManager(576);
        ToolBar toolBar = this.toolBarManager.createControl(this.fControlParent);
        DVTColorUtil.INSTANCE.setBackground((Control)toolBar, Display.getCurrent().getSystemColor(DiagramPreferenceAdapter.getInstance().getDiagramInvertColors() ? 2 : 1));
        GridDataFactory.fillDefaults().grab(false, true).applyTo((Control)toolBar);
        this.sashFormParent = new SashForm(this.fControlParent, 66048);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.sashFormParent);
        Composite compositeParent = new Composite((Composite)this.sashFormParent, 0);
        GridLayoutFactory.fillDefaults().spacing(0, 1).applyTo(compositeParent);
        this.sashForm = new SashForm(compositeParent, 65792);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.sashForm);
        Composite composite = new Composite((Composite)this.sashForm, 0);
        GridLayoutFactory.fillDefaults().spacing(0, 1).applyTo(composite);
        Composite searchBar = new Composite(composite, 0);
        DVTColorUtil.INSTANCE.setBackground((Control)searchBar, Display.getCurrent().getSystemColor(DiagramPreferenceAdapter.getInstance().getDiagramInvertColors() ? 2 : 1));
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)searchBar);
        GridLayoutFactory.fillDefaults().numColumns(3).applyTo(searchBar);
        this.searchText = new Text(searchBar, 0);
        DVTColorUtil.INSTANCE.setBackground((Control)this.searchText, Display.getCurrent().getSystemColor(DiagramPreferenceAdapter.getInstance().getDiagramInvertColors() ? 2 : 1));
        DVTColorUtil.INSTANCE.setForeground((Control)this.searchText, Display.getCurrent().getSystemColor(DiagramPreferenceAdapter.getInstance().getDiagramInvertColors() ? 1 : 2));
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)this.searchText);
        this.searchText.setMessage("Search...");
        this.searchText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 27) {
                    DDiagramEditor.this.canvas.setFocus();
                } else if (e.keyCode == 13) {
                    DDiagramEditor.this.searchNextAction.run();
                } else if (e.stateMask == 262144 && !Character.isISOControl(e.character)) {
                    e.doit = false;
                }
            }
        });
        TextDelayedModifyListener.install(this.searchText, text -> {
            this.searchClearAction.setEnabled(!text.isEmpty());
            this.searchManager.search(text.trim());
        });
        this.searchMatchesLabel = new Label(searchBar, 131072);
        DVTColorUtil.INSTANCE.setBackground((Control)this.searchMatchesLabel, Display.getCurrent().getSystemColor(DiagramPreferenceAdapter.getInstance().getDiagramInvertColors() ? 2 : 1));
        DVTColorUtil.INSTANCE.setForeground((Control)this.searchMatchesLabel, Display.getCurrent().getSystemColor(33));
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(false, true).hint(100, -1).applyTo((Control)this.searchMatchesLabel);
        this.searchClearAction.setEnabled(false);
        this.searchPreviousAction.setEnabled(false);
        this.searchNextAction.setEnabled(false);
        ToolBarManager searchToolBarManager = new ToolBarManager(256);
        toolBar = searchToolBarManager.createControl(searchBar);
        DVTColorUtil.INSTANCE.setBackground((Control)toolBar, Display.getCurrent().getSystemColor(DiagramPreferenceAdapter.getInstance().getDiagramInvertColors() ? 2 : 1));
        GridDataFactory.fillDefaults().grab(false, true).applyTo((Control)toolBar);
        searchToolBarManager.add((IAction)this.searchClearAction);
        searchToolBarManager.add((IAction)this.searchPreviousAction);
        searchToolBarManager.add((IAction)this.searchNextAction);
        searchToolBarManager.update(true);
        this.waveformInfoBar = new Composite(composite, 0);
        this.waveformInfoBar.setVisible(false);
        DVTColorUtil.INSTANCE.setBackground((Control)this.waveformInfoBar, Display.getCurrent().getSystemColor(DiagramPreferenceAdapter.getInstance().getDiagramInvertColors() ? 2 : 1));
        GridDataFactory.fillDefaults().exclude(true).grab(true, false).applyTo((Control)this.waveformInfoBar);
        GridLayoutFactory.fillDefaults().applyTo(this.waveformInfoBar);
        this.waveformInfoText = new Label(this.waveformInfoBar, 0x1000000);
        DVTColorUtil.INSTANCE.setBackground((Control)this.waveformInfoText, Display.getCurrent().getSystemColor(DiagramPreferenceAdapter.getInstance().getDiagramInvertColors() ? 2 : 1));
        DVTColorUtil.INSTANCE.setForeground((Control)this.waveformInfoText, Display.getCurrent().getSystemColor(DiagramPreferenceAdapter.getInstance().getDiagramInvertColors() ? 1 : 2));
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.waveformInfoText);
        this.waveformInfoText.setToolTipText("Set a Waveform Viewer and place the Primary Cursor to see the signals value.");
        this.canvas = new DCanvas(composite);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.canvas);
        this.inspectComponent = new InspectViewComponent((Composite)this.sashForm);
        this.searchManager = new DSearchManager(this);
        this.mouseManager = new DMouseManager(this);
        this.sashForm.setWeights(new int[]{67, 33});
        this.fsmTransitionTable = new FSMTransitionTable((Composite)this.sashFormParent, this);
        this.fsmTransitionTable.setVisible(false);
        this.setTransitionTableDisabled(DVTPlugin.getDefault().getPreferenceStore().getBoolean("designdiagrams.fsm_transition_table_disabled"));
        DVTPlugin.getDefault().getPreferenceStore().addPropertyChangeListener(this.transitionTableEnabledPreferenceListener);
        this.setInspectLayout(DVTPlugin.getDefault().getCombinedPreferenceStore().getString("inspect.diagram_editor_layout"));
        DVTPlugin.getDefault().getPreferenceStore().addPropertyChangeListener(this.inspectLayoutPreferenceListener);
        this.updateActiveContext();
        this.pinAction = new DPinAction(this);
        this.inspectLayoutAction = new DEditorToolbarDialogAction(this, "Inspect Panel...", DVTImages.INSPECT_LAYOUT, DInspectLayoutDialog::new);
        this.saveAsAction = new DEditorToolbarDialogAction(this, DMessages.DiagramPanel_SaveAs_Button_TT, DVTImages.IMG_TAB_GRAPHVIZ_SAVEAS, DSaveAsDialog::new);
        this.updateToolBarActions();
        this.addCanvasActions();
        this.addGlobalActions();
        FWidgetFactory.INSTANCE.createWidgets(this);
        this.installFNotificationListeners();
        this.updateEditor();
    }

    private void updateActiveContext() {
        IContextService contextService = (IContextService)this.getSite().getService(IContextService.class);
        if (contextService == null) {
            return;
        }
        if (this.diagramContext != null) {
            contextService.deactivateContext(this.diagramContext);
        }
        this.diagramContext = contextService.activateContext(this.computeActiveContextName());
    }

    private String computeActiveContextName() {
        DDiagram diagram = this.getInput().getDiagram();
        if (!(diagram instanceof FSMDiagram)) {
            return DESIGN_DIAGRAM_CONTEXT;
        }
        FSMDiagram fsmDiagram = (FSMDiagram)diagram;
        IRfNamedElement namedElement = fsmDiagram.getNamedElement();
        if (namedElement == null) {
            return DESIGN_DIAGRAM_CONTEXT;
        }
        return MessageFormat.format(FSM_DIAGRAM_CONTEXT, namedElement.getLanguageKind().PLUGIN_ID);
    }

    private void installFNotificationListeners() {
        this.fFocusListener = new FocusListener(){

            public void focusLost(FocusEvent e) {
                FMouseDownFilterListener.INSTANCE.removeDisplayFilter(DDiagramEditor.this.getFNotificationHostCanvas());
            }

            public void focusGained(FocusEvent e) {
                FMouseDownFilterListener.INSTANCE.addDisplayFilter(DDiagramEditor.this.getFNotificationHostCanvas());
            }
        };
        this.canvas.addFocusListener(this.fFocusListener);
        this.canvas.addDisposeListener(e -> {
            if (!(e.widget instanceof Control)) {
                return;
            }
            ((Control)e.widget).removeFocusListener(this.fFocusListener);
            this.fFocusListener = null;
        });
    }

    private void setTransitionTableDisabled(boolean disabled) {
        if (this.fsmTransitionTable.isHidden() == disabled) {
            return;
        }
        this.fsmTransitionTable.hide(disabled);
        DDiagram diagram = this.getInput().getDiagram();
        if (this.fsmTransitionTable.isHidden()) {
            this.removeSelectionChangedListener(this.fsmTransitionTable.getTransitionTableSelectionChangedListener());
            if (diagram instanceof FSMDiagram) {
                ((FSMDiagram)diagram).setTableConstructor(null);
            }
        } else {
            this.fsmTransitionTable.getTransitionTableSelectionChangedListener().selectionChanged(new SelectionChangedEvent((ISelectionProvider)this, (ISelection)this.currentSelection));
            this.addSelectionChangedListener(this.fsmTransitionTable.getTransitionTableSelectionChangedListener());
            if (diagram instanceof FSMDiagram) {
                ((FSMDiagram)diagram).setTableConstructor(new FSMTransitionTableData());
            }
        }
        this.updateEditor();
    }

    public void dispose() {
        DVTPlugin.getDefault().getPreferenceStore().removePropertyChangeListener(this.inspectLayoutPreferenceListener);
        DVTPlugin.getDefault().getPreferenceStore().removePropertyChangeListener(this.transitionTableEnabledPreferenceListener);
        if (this.fDHBreadcrumbViewer != null) {
            this.fDHBreadcrumbViewer.dispose();
        }
        if (this.fVHBreadcrumbViewer != null) {
            this.fVHBreadcrumbViewer.dispose();
        }
        if (this.fsmTransitionTable != null) {
            this.fsmTransitionTable.dispose();
        }
        this.fDHBCCache = null;
        this.fVHBCCache = null;
        if (this.updateJob != null) {
            this.updateJob.cancel();
        }
        FWidgetFactory.INSTANCE.disposeWidgets(this);
        this.canvas.dispose();
        super.dispose();
    }

    private void updateToolBarActions() {
        if (this.toolBarManager == null) {
            return;
        }
        this.toolBarManager.removeAll();
        this.toolBarManager.add((IAction)this.pinAction);
        this.toolBarManager.add((IAction)this.inspectLayoutAction);
        this.toolBarManager.add((IContributionItem)new Separator());
        this.toolBarManager.add((IAction)new Action(DMessages.DiagramPanel_ZoomIn_Button_TT, DVTImages.IMG_GRAPHVIZ_ZOOM_IN){

            public void run() {
                DDiagramEditor.this.canvas.getViewport().zoomIncrementedScaleAboutCenter(5);
            }
        });
        this.toolBarManager.add((IAction)new Action(DMessages.DiagramPanel_ZoomOut_Button_TT, DVTImages.IMG_GRAPHVIZ_ZOOM_OUT){

            public void run() {
                DDiagramEditor.this.canvas.getViewport().zoomIncrementedScaleAboutCenter(-5);
            }
        });
        this.toolBarManager.add((IAction)new Action(DMessages.DiagramPanel_ZoomFitCanvas_Button_TT, DVTImages.IMG_GRAPHVIZ_ZOOM_FIT_CANVAS){

            public void run() {
                DDiagramEditor.this.canvas.getViewport().zoomToFitCanvas();
            }
        });
        this.toolBarManager.add((IContributionItem)new Separator());
        this.toolBarManager.add((IAction)this.saveAsAction);
        this.toolBarManager.add((IContributionItem)new Separator());
        Set<IAction> actions = this.getInput().getToolbarContributor().getToolbarActions(this);
        for (IAction action : actions) {
            this.toolBarManager.add(action);
        }
        this.toolBarManager.update(true);
    }

    private void addGlobalActions() {
        IActionBars actionBars = this.getEditorSite().getActionBars();
        actionBars.setGlobalActionHandler(ActionFactory.FIND.getId(), (IAction)this.searchFocusAction);
        actionBars.setGlobalActionHandler(ActionFactory.DELETE.getId(), (IAction)this.searchClearAction);
        actionBars.setGlobalActionHandler(ActionFactory.PREVIOUS.getId(), (IAction)this.searchPreviousAction);
        actionBars.setGlobalActionHandler(ActionFactory.NEXT.getId(), (IAction)this.searchNextAction);
        actionBars.updateActionBars();
    }

    public void setFocus() {
        this.canvas.setFocus();
        this.handleFloatingNotifications();
        this.updateDiagramBreadcrumb();
    }

    protected void setInputWithNotify(IEditorInput input) {
        super.setInputWithNotify(input);
        this.setTitleToolTip(input.getToolTipText());
        this.setPartName(input.getName());
        this.updateToolBarActions();
        this.updateEditor();
    }

    @Override
    protected boolean canvasReady() {
        return this.canvas != null && !this.canvas.isDisposed();
    }

    @Override
    protected void setCanvasMessage(String message) {
        this.setCanvasContent(DText.createCenteredMultiline(message, FontFactory.getInstance().getFontData("Sans", 32, 0)));
    }

    private DDebug getCanvasDebug() {
        return this.canvasReady() ? this.canvas.getDebug() : new DNullDebug();
    }

    @Override
    public void updateEditor() {
        if (!DVTPlugin.getDefault().collect().c()) {
            return;
        }
        if (!this.canvasReady()) {
            return;
        }
        if (this.updateJob != null && this.updateJob.getState() == 4) {
            return;
        }
        this.updateJob = new StoppableJob("Generating Diagram - " + this.getInput().getName()){

            @Override
            protected IStatus stoppableRun(IProgressMonitor monitor) {
                double lastScale = DDiagramEditor.this.canvas.getViewport().getExpScale();
                DProgressMonitor dMonitor = DProgressMonitor.wrap(monitor, DDiagramEditor.this::setCanvasMessage, () -> DDiagramEditor.access$1(DDiagramEditor.this));
                final DDiagramEditorInput input = DDiagramEditor.this.getInput();
                DDiagramEditor.this.setCanvasMessage("Generating diagram...");
                DObject result = input.getDiagram().getSceneGenerator().generate(dMonitor);
                if (result == null) {
                    if (!dMonitor.isCanceled() && input.hasFailedDiagramAction()) {
                        this.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                            public void done(IJobChangeEvent event) {
                                input.getFailedDiagramAction().run();
                            }
                        });
                    }
                } else {
                    DDiagramEditor.this.setCanvasContent(result, input.getMiscContributor().getFocusedObjects(DDiagramEditor.this, result), lastScale);
                    DDiagramEditor.this.updateDiagramBreadcrumb();
                }
                DDiagramEditor.this.updateFSMTransitionTable(input);
                DDiagramEditor.this.notifyFSMDiagramStartingConfig(input);
                DDiagramEditor.this.mouseManager.clearSelection();
                DDiagramEditor.this.searchManager.refreshSearch();
                ObjectionManager.getInstance().clear(Objection.DIAGRAM_EDITOR);
                return result != null ? Status.OK_STATUS : Status.CANCEL_STATUS;
            }
        };
        this.updateJob.setPriority(30);
        this.updateJob.schedule();
        this.updateActiveContext();
        this.updateWaveformInfoGUI();
    }

    @Override
    protected void updateFSMTransitionTable(DDiagramEditorInput input) {
        DTransitionTableContributor transitionTableContributor = input.getTransitionTableContributor();
        if (transitionTableContributor != DTransitionTableContributor.EMPTY) {
            this.fsmTransitionTable = transitionTableContributor.getTransitionTable(this);
            this.fsmTransitionTable.hide(DVTPlugin.getDefault().getPreferenceStore().getBoolean("designdiagrams.fsm_transition_table_disabled"));
        } else {
            this.fsmTransitionTable.hide(true);
        }
        Utils.safeRunSynchInUIThread(() -> this.fsmTransitionTable.updateTransitionTableView());
    }

    private void notifyFSMDiagramStartingConfig(DDiagramEditorInput input) {
        if (input == null) {
            return;
        }
        DDiagram candidateDiagram = input.getDiagram();
        if (!(candidateDiagram instanceof FSMDiagram)) {
            return;
        }
        FSMDiagramConfiguration config = ((FSMDiagram)candidateDiagram).getConfig();
        if (config == null || !config.contains(FSMDiagramConfiguration.FSMDiagramConfigurationKey.REMOVE_LOOPBACK_TRANSITIONS)) {
            return;
        }
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                new SimpleDVTNotification(DDiagramEditor.this, 256, "FSM Diagram Notification").setText(DFSMActionMessages.explicitLoopbackNotShow).setShowPreferenceKey("designdiagrams.fsm_show_notifications").create();
            }
        });
    }

    private void updateWaveformInfoGUI() {
        DDiagramEditorInput input = this.getInput();
        if (input == null) {
            this.hideWaveformInfoBar();
            return;
        }
        DDiagram diagram = input.getDiagram();
        if (!(diagram instanceof DSchematicDiagram)) {
            this.hideWaveformInfoBar();
            return;
        }
        NLConfig config = ((DSchematicDiagram)diagram).getConfig();
        if (config == null) {
            this.hideWaveformInfoBar();
            return;
        }
        if (!config.getSchematicShowWaveformInfo()) {
            this.hideWaveformInfoBar();
            return;
        }
        this.showWaveformInfoBar();
    }

    private void hideWaveformInfoBar() {
        if (this.waveformInfoBar.isDisposed()) {
            return;
        }
        Object layoutData = this.waveformInfoBar.getLayoutData();
        if (!(layoutData instanceof GridData)) {
            return;
        }
        GridData gridData = (GridData)layoutData;
        gridData.exclude = true;
        this.waveformInfoBar.setVisible(false);
        this.waveformInfoText.setText("");
        this.waveformInfoBar.requestLayout();
    }

    private void showWaveformInfoBar() {
        if (this.waveformInfoBar.isDisposed()) {
            return;
        }
        Object layoutData = this.waveformInfoBar.getLayoutData();
        if (!(layoutData instanceof GridData)) {
            return;
        }
        GridData gridData = (GridData)layoutData;
        String waveformInfoString = DVTWaveViewIDEFactory.getInstance().getWaveformInfoBarString(this.getProject());
        if (waveformInfoString == null) {
            return;
        }
        gridData.exclude = false;
        this.waveformInfoBar.setVisible(true);
        this.waveformInfoText.setText(waveformInfoString);
        this.waveformInfoBar.requestLayout();
    }

    public void setPinned(boolean isPinned) {
        this.isPinned = isPinned;
        if (this.pinAction != null) {
            this.pinAction.setChecked(this.isPinned);
        }
        if (!this.isPinned) {
            DDiagramEditor.diagramEditorsAsStream().filter(editor -> editor != this && !editor.isPinned()).forEach(editor -> editor.setPinned(true));
        }
    }

    public void setHideSideEffects(boolean hideSideEffects) {
        this.hideSideEffects = hideSideEffects;
    }

    public boolean hideSideEffects() {
        return this.hideSideEffects;
    }

    public boolean isPinned() {
        return this.isPinned;
    }

    public DDiagramEditorCommon.InspectLayout getInspectLayout() {
        return this.inspectLayout;
    }

    private void setInspectLayout(DDiagramEditorCommon.InspectLayout layout) {
        if (this.inspectLayout == layout) {
            return;
        }
        this.inspectLayout = layout;
        if (this.inspectLayout == DDiagramEditorCommon.InspectLayout.HIDDEN) {
            this.inspectComponent.setVisible(false);
            this.removeSelectionChangedListener(this.inspectSelectionChangedListener);
            IContextService contextService = (IContextService)this.getSite().getService(IContextService.class);
            if (contextService != null) {
                contextService.deactivateContext(this.inspectContext);
            }
        } else {
            this.inspectComponent.setVisible(true);
            this.inspectSelectionChangedListener.selectionChanged(new SelectionChangedEvent((ISelectionProvider)this, (ISelection)this.currentSelection));
            this.addSelectionChangedListener(this.inspectSelectionChangedListener);
            IContextService contextService = (IContextService)this.getSite().getService(IContextService.class);
            if (contextService != null) {
                this.inspectContext = contextService.activateContext("ro.amiq.dvt.ui.inspect.view.actions.context");
            }
        }
        if (this.inspectLayout == DDiagramEditorCommon.InspectLayout.AUTOMATIC) {
            this.sashForm.addListener(11, this.sashFormResizeListener);
        } else {
            this.sashForm.removeListener(11, this.sashFormResizeListener);
        }
        this.applyInspectLayout();
    }

    private void setInspectLayout(String layoutName) {
        DDiagramEditorCommon.InspectLayout layout = DDiagramEditorCommon.InspectLayout.HIDDEN;
        try {
            layout = DDiagramEditorCommon.InspectLayout.valueOf(layoutName);
        }
        catch (IllegalArgumentException | NullPointerException runtimeException) {
            layout = DDiagramEditorCommon.InspectLayout.HIDDEN;
        }
        this.setInspectLayout(layout);
    }

    private void applyInspectLayout() {
        int orientation = this.sashForm.getOrientation();
        if (this.inspectLayout == DDiagramEditorCommon.InspectLayout.VERTICAL) {
            orientation = 512;
        } else if (this.inspectLayout == DDiagramEditorCommon.InspectLayout.HORIZONTAL) {
            orientation = 256;
        } else if (this.inspectLayout == DDiagramEditorCommon.InspectLayout.AUTOMATIC) {
            Point sashSize = this.sashForm.getSize();
            if (sashSize.x != 0 && sashSize.y != 0) {
                orientation = sashSize.x > sashSize.y ? 256 : 512;
            }
        }
        this.sashForm.setOrientation(orientation);
        this.sashForm.layout();
    }

    public void setSearchMatches(int current, int total) {
        Display.getDefault().asyncExec(() -> {
            if (!this.searchMatchesLabel.isDisposed()) {
                this.searchMatchesLabel.setText(total == 0 ? "" : String.valueOf(current) + " of " + total);
            }
            this.searchPreviousAction.setEnabled(total != 0);
            this.searchNextAction.setEnabled(total != 0);
        });
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    public void doSaveAs() {
        this.saveAsAction.run();
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public boolean isDirty() {
        return false;
    }

    public static Stream<DDiagramEditor> diagramEditorsAsStream() {
        return DDiagramEditor.diagramEditorsAsStream(PlatformUI.getWorkbench().getActiveWorkbenchWindow());
    }

    public static Stream<DDiagramEditor> diagramEditorsAsStream(IWorkbenchWindow activeWorkbenchWindow) {
        if (activeWorkbenchWindow == null) {
            return Stream.empty();
        }
        IWorkbenchPage activePage = activeWorkbenchWindow.getActivePage();
        if (activePage == null) {
            return Stream.empty();
        }
        return Arrays.stream(activePage.findEditors(null, ID, 2)).map(editorReference -> editorReference.getEditor(false)).filter(editorPart -> editorPart instanceof DDiagramEditor).map(editorPart -> (DDiagramEditor)DDiagramEditor.class.cast(editorPart));
    }

    public static IEditorPart openNew(DDiagramEditorInput input) {
        block3: {
            try {
                if (input != null) break block3;
                return null;
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
                return null;
            }
        }
        IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        return activePage.openEditor((IEditorInput)input, ID, true, 0);
    }

    public static void openReuse(DDiagramEditor diagramEditor, DDiagramEditorInput input) {
        try {
            if (input == null) {
                return;
            }
            IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            activePage.reuseEditor((IReusableEditor)diagramEditor, (IEditorInput)input);
            activePage.activate((IWorkbenchPart)diagramEditor);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public static void open(DDiagramEditorInput input) {
        try {
            if (input == null) {
                return;
            }
            IWorkbench workbench = PlatformUI.getWorkbench();
            if (workbench == null) {
                return;
            }
            IWorkbenchWindow activeWorkbenchWindow = workbench.getActiveWorkbenchWindow();
            if (activeWorkbenchWindow == null) {
                return;
            }
            IWorkbenchPage activePage = activeWorkbenchWindow.getActivePage();
            if (activePage == null) {
                return;
            }
            Optional<DDiagramEditor> sameInput = DDiagramEditor.diagramEditorsAsStream().filter(editor -> input.equals(editor.getInput())).findFirst();
            if (sameInput.isPresent()) {
                activePage.activate((IWorkbenchPart)sameInput.get());
                return;
            }
            Optional<DDiagramEditor> unpinnedEditor = DDiagramEditor.diagramEditorsAsStream().filter(editor -> !editor.isPinned()).findFirst();
            if (unpinnedEditor.isPresent()) {
                activePage.reuseEditor((IReusableEditor)unpinnedEditor.get(), (IEditorInput)input);
                activePage.activate((IWorkbenchPart)unpinnedEditor.get());
                return;
            }
            activePage.openEditor((IEditorInput)input, ID, true, 0);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    @Override
    protected void fireSelectionChanged(Set<DSelectable> selection) {
        Display.getDefault().asyncExec(() -> {
            this.currentSelection = new DDiagramEditorSelection(this.getInput().getDiagram(), selection);
            ObjectionManager.getInstance().conditionalClear(selection != null && !selection.isEmpty(), Objection.DIAGRAM_EDITOR_CHANGED_SELECTION);
            final SelectionChangedEvent event = new SelectionChangedEvent((ISelectionProvider)this, (ISelection)this.currentSelection);
            ListenerList[] listenerListArray = this.selectionChangedListenerLists;
            int n = this.selectionChangedListenerLists.length;
            int n2 = 0;
            while (n2 < n) {
                Object[] listeners;
                ListenerList listenerList = listenerListArray[n2];
                Object[] objectArray = listeners = listenerList.getListeners();
                int n3 = listeners.length;
                int n4 = 0;
                while (n4 < n3) {
                    final Object listener = objectArray[n4];
                    SafeRunnable.run((ISafeRunnable)new SafeRunnable(){

                        public void run() {
                            ((ISelectionChangedListener)listener).selectionChanged(event);
                        }
                    });
                    ++n4;
                }
                ++n2;
            }
        });
    }

    @Override
    public Composite getNotificationsHostComposite() {
        return this.fNotificationsHostComposite;
    }

    private void createNotificationsHostComposite(Composite parent) {
        this.fTopContainer = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().spacing(0, 0).applyTo(this.fTopContainer);
        this.fNotificationsHostComposite = new Composite(this.fTopContainer, 0);
        GridDataFactory.fillDefaults().applyTo((Control)this.fNotificationsHostComposite);
        GridLayoutFactory.fillDefaults().spacing(0, 0).applyTo(this.fNotificationsHostComposite);
        this.fControlParent = new Composite(this.fTopContainer, 0);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)this.fControlParent);
        if (parent.getLayout() instanceof FillLayout) {
            this.fControlParent.setLayout((Layout)new FillLayout());
        } else if (parent.getLayout() instanceof GridLayout) {
            GridLayoutFactory.fillDefaults().spacing(0, 0).applyTo(this.fControlParent);
        }
    }

    @Override
    public AbstractBreadcrumbViewer getBreadcrumbViewer(Class<?> breadcrumbType) {
        if (breadcrumbType == DHBreadcrumbViewer.class) {
            return this.fDHBreadcrumbViewer;
        }
        if (breadcrumbType == VHBreadcrumbViewer.class) {
            return this.fVHBreadcrumbViewer;
        }
        return null;
    }

    @Override
    public void createBreadcrumb(Class<?> breadcrumbType, AbstractBreadcrumbConfiguration cursorScope) {
        try {
            if (this.fTopContainer == null || this.fTopContainer.isDisposed()) {
                return;
            }
            AbstractBreadcrumbUtils breadcrumbUtils = this.getBreadcrumbUtils(breadcrumbType);
            if (breadcrumbUtils == null) {
                this.hideBreadcrumb(breadcrumbType);
            } else if (breadcrumbType == DHBreadcrumbViewer.class) {
                this.fDHBreadcrumbViewer = new DHBreadcrumbViewer(this, this.fTopContainer);
            } else if (breadcrumbType == VHBreadcrumbViewer.class) {
                this.fVHBreadcrumbViewer = new VHBreadcrumbViewer(this, this.fTopContainer);
            }
        }
        catch (Throwable e) {
            DVTLogger.INSTANCE.logError(e);
        }
    }

    @Override
    public AbstractBreadcrumbUtils getBreadcrumbUtils(Class<?> breadcrumbType) {
        if (breadcrumbType == DHBreadcrumbViewer.class) {
            return DiagramBreadcrumbUtils.getInstance();
        }
        if (breadcrumbType == VHBreadcrumbViewer.class) {
            DDiagram diagram = this.getInput().getDiagram();
            if (!(diagram instanceof ICHDiagram)) {
                this.hideBreadcrumb(VHBreadcrumbViewer.class);
                return null;
            }
            if (diagram instanceof CHDiagram) {
                return VHDiagramBreadcrumbUtils.getUtils(LanguageKind.VLOG);
            }
            IDVTElementWrapper wrapper = null;
            if (diagram instanceof CHDiagram2) {
                wrapper = ((CHDiagram2)diagram).getWrapper();
            }
            if (diagram instanceof CHActionDiagram) {
                wrapper = ((CHActionDiagram)diagram).getWrapper();
            }
            if (wrapper == null) {
                this.hideBreadcrumb(VHBreadcrumbViewer.class);
                return null;
            }
            VHBreadcrumbUtils utils = VHDiagramBreadcrumbUtils.getUtils(wrapper.getLanguageKind());
            if (utils == null) {
                this.hideBreadcrumb(VHBreadcrumbViewer.class);
            }
            return utils;
        }
        return null;
    }

    public void testSetSelection(ISelection selection) {
        DDiagramEditorSelection dSelection;
        this.currentSelection = dSelection = (DDiagramEditorSelection)selection;
        this.fireSelectionChanged(dSelection.getElements());
        for (DSelectable element : dSelection.getElements()) {
            element.select(true, "");
        }
    }

    @Override
    protected void updateDiagramBreadcrumb() {
        DDiagram diagram = this.getInput().getDiagram();
        if (!AbstractBreadcrumbUtilsCommon.isDiagramWithBreadcrumb(diagram)) {
            if (this.hasBreadcrumb(DHBreadcrumbViewer.class)) {
                this.fDHBreadcrumbViewer.hideBreadcrumb();
            }
            if (this.hasBreadcrumb(VHBreadcrumbViewer.class)) {
                this.fVHBreadcrumbViewer.hideBreadcrumb();
            }
            return;
        }
        if (!(diagram instanceof DTopPathDiagram) && !(diagram instanceof ICHDiagram)) {
            Utils.safeRunSynchInUIThread(() -> this.updateBreadcrumb(DHBreadcrumbViewer.class, null));
            Utils.safeRunSynchInUIThread(() -> this.updateBreadcrumb(VHBreadcrumbViewer.class, null));
            return;
        }
        if (diagram instanceof DTopPathDiagram) {
            IResource resource;
            List<BreadcrumbSegment> breadcrumb;
            NLConfig config;
            if (this.hasBreadcrumb(VHBreadcrumbViewer.class)) {
                Display.getDefault().asyncExec(() -> this.fVHBreadcrumbViewer.hideBreadcrumb());
            }
            if ((config = ((DTopPathDiagram)diagram).getConfig()) == null) {
                return;
            }
            List<BreadcrumbSegment> list = breadcrumb = config.getBreadcrumbInput() != null ? config.getBreadcrumbInput().getInputSegments() : null;
            if (breadcrumb == null) {
                return;
            }
            if (this.getInput().getDiagram() != null && (resource = (IResource)this.getInput().getAdapter(IResource.class)) != null) {
                try {
                    BreadcrumbInput bcInput = new BreadcrumbInput(this.getProject(), breadcrumb, this.getBreadcrumbUtils(DHBreadcrumbViewer.class).getBreadcrumbSerializer());
                    resource.setSessionProperty(IDVTConstants.DH_BREADCRUMB_QN, (Object)bcInput);
                }
                catch (CoreException e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                }
            }
            Utils.safeRunSynchInUIThread(() -> this.updateBreadcrumb(DHBreadcrumbViewer.class, null));
        } else if (diagram instanceof ICHDiagram) {
            IResource resource;
            List<BreadcrumbSegment> breadcrumb;
            CHConfig config;
            if (this.hasBreadcrumb(DHBreadcrumbViewer.class)) {
                Display.getDefault().asyncExec(() -> this.fDHBreadcrumbViewer.hideBreadcrumb());
            }
            if ((config = ((ICHDiagram)diagram).getConfig()) == null) {
                return;
            }
            BreadcrumbInput breadcrumbInput = config.getBreadcrumbInput();
            List<BreadcrumbSegment> list = breadcrumb = breadcrumbInput == null ? null : breadcrumbInput.getInputSegments();
            if (breadcrumb == null) {
                return;
            }
            if (this.getInput().getDiagram() != null && (resource = (IResource)this.getInput().getAdapter(IResource.class)) != null) {
                try {
                    AbstractBreadcrumbUtils breadcrumbUtils = this.getBreadcrumbUtils(VHBreadcrumbViewer.class);
                    if (breadcrumbUtils == null) {
                        return;
                    }
                    BreadcrumbInput bcInput = new BreadcrumbInput(this.getProject(), breadcrumb, breadcrumbUtils.getBreadcrumbSerializer());
                    resource.setSessionProperty(IDVTConstants.VH_BREADCRUMB_QN, (Object)bcInput);
                }
                catch (CoreException e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                }
            }
            Utils.safeRunSynchInUIThread(() -> this.updateBreadcrumb(VHBreadcrumbViewer.class, null));
        }
    }

    public void close() {
        Display.getDefault().asyncExec(() -> {
            boolean bl = this.getSite().getPage().closeEditor((IEditorPart)this, false);
        });
    }

    @Override
    public Canvas getFNotificationHostCanvas() {
        return this.canvas;
    }

    public DVTProjectionViewer getFNotificationHostTextViewer() {
        return null;
    }

    static /* synthetic */ DDebug access$1(DDiagramEditor dDiagramEditor) {
        return dDiagramEditor.getCanvasDebug();
    }
}

