/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.diagrams.editor;

import java.util.Set;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.part.EditorPart;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.diagrams.editor.DDiagramEditorInput;
import ro.amiq.dvt.diagrams.editor.DDiagramEditorSelection;
import ro.amiq.dvt.diagrams.editor.DMouseManager;
import ro.amiq.dvt.diagrams.fsm.editor.FSMTransitionTable;
import ro.amiq.dvt.draw.DCanvas;
import ro.amiq.dvt.draw.obj.base.DObject;
import ro.amiq.dvt.draw.obj.interaction.DSelectable;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.editor.breadcrumb.BreadcrumbInput;
import ro.amiq.dvt.ui.editor.breadcrumb.IDVTBreadcrumbHost;
import ro.amiq.dvt.ui.editor.dhbreadcrumb.DHBreadcrumbViewer;
import ro.amiq.dvt.ui.editor.vhbreadcrumb.VHBreadcrumbViewer;

public abstract class DDiagramEditorCommon
extends EditorPart
implements ISelectionProvider,
IDVTBreadcrumbHost {
    protected DCanvas canvas;
    protected DDiagramEditorSelection currentSelection = new DDiagramEditorSelection();
    protected ListenerList selectionChangedListeners = new ListenerList(1);
    protected DMouseManager mouseManager;
    protected FSMTransitionTable fsmTransitionTable;
    protected BreadcrumbInput fDHBCCache;
    protected BreadcrumbInput fVHBCCache;
    protected static final ListenerList staticSelectionChangedListeners = new ListenerList(1);

    public static void addStaticSelectionChangedListener(ISelectionChangedListener listener) {
        staticSelectionChangedListeners.add((Object)listener);
    }

    public static void removeStaticSelectionChangedListeners(ISelectionChangedListener listener) {
        staticSelectionChangedListeners.remove((Object)listener);
    }

    public void setInput(IEditorInput input) {
        DDiagramEditorInput diagramEditorInput = null;
        diagramEditorInput = input instanceof DDiagramEditorInput ? (DDiagramEditorInput)input : (DDiagramEditorInput)input.getAdapter(DDiagramEditorInput.class);
        this.setInputWithNotify(diagramEditorInput);
    }

    public DDiagramEditorInput getInput() {
        return (DDiagramEditorInput)this.getEditorInput();
    }

    public ISelection getSelection() {
        return this.currentSelection;
    }

    public void setSelection(ISelection selection) {
        DVTLogger.INSTANCE.logError((Throwable)new UnsupportedOperationException());
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListeners.add((Object)listener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListeners.remove((Object)listener);
    }

    protected void addCanvasActions() {
        this.canvas.getClickHandler().addListener(this.mouseManager);
    }

    protected void setCanvasContent(DObject content) {
        this.setCanvasContent(content, null, 0.0);
    }

    protected void setCanvasContent(DObject content, DObject[] focused, double lastScale) {
        if (this.canvasReady()) {
            if (focused != null) {
                this.canvas.setContent(content, focused, lastScale);
            } else {
                this.canvas.setContent(content);
            }
        }
    }

    public DCanvas getCanvas() {
        return this.canvas;
    }

    public DMouseManager getMouseManager() {
        return this.mouseManager;
    }

    public FSMTransitionTable getTransitionTable() {
        return this.fsmTransitionTable;
    }

    @Override
    public void setBCCache(BreadcrumbInput bcInput, Class<?> breadcrumbType) {
        if (breadcrumbType == DHBreadcrumbViewer.class) {
            this.fDHBCCache = bcInput;
        }
        if (breadcrumbType == VHBreadcrumbViewer.class) {
            this.fVHBCCache = bcInput;
        }
    }

    @Override
    public BreadcrumbInput getBCCache(Class<?> breadcrumbType) {
        if (breadcrumbType == DHBreadcrumbViewer.class) {
            return this.fDHBCCache;
        }
        if (breadcrumbType == VHBreadcrumbViewer.class) {
            return this.fVHBCCache;
        }
        return null;
    }

    @Override
    public LanguageKind getLanguageKind() {
        return LanguageKind.VLOG;
    }

    protected abstract boolean canvasReady();

    protected abstract void setCanvasMessage(String var1);

    protected abstract void fireSelectionChanged(Set<DSelectable> var1);

    protected abstract void updateDiagramBreadcrumb();

    protected abstract void updateFSMTransitionTable(DDiagramEditorInput var1);

    public abstract void updateEditor();

    public static enum InspectLayout {
        HIDDEN,
        VERTICAL,
        HORIZONTAL,
        AUTOMATIC;

    }
}

