/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.diagrams.editor;

import java.io.File;
import java.net.URI;
import java.nio.file.Paths;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ui.IURIEditorInput;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.diagrams.ch.editor.CHEditorFactory;
import ro.amiq.dvt.diagrams.ch.utils.CHConfig;
import ro.amiq.dvt.diagrams.editor.DDiagramEditorInput;

public class DDiagramEditorInputAdapter
implements IAdapterFactory {
    private static final Class<?>[] ADAPTER_LIST = new Class[]{DDiagramEditorInput.class};
    private static final String EXTENSION_CHD = "chd";

    public Class<?>[] getAdapterList() {
        return ADAPTER_LIST;
    }

    public Object getAdapter(Object adaptableObject, Class adapterType) {
        if (adapterType != DDiagramEditorInput.class) {
            return null;
        }
        if (!(adaptableObject instanceof IURIEditorInput)) {
            return null;
        }
        LanguageKind languageKind = LanguageKind.VLOG;
        IFile iFile = (IFile)Platform.getAdapterManager().getAdapter(adaptableObject, IFile.class);
        if (iFile != null && iFile.getLocation() != null && this.isValidExtension(iFile.getName())) {
            return CHEditorFactory.newFileDiagram(iFile.getProject(), iFile.getLocation().toFile(), new CHConfig(null, languageKind), 2).createEditorInput();
        }
        URI uri = ((IURIEditorInput)adaptableObject).getURI();
        if (uri == null) {
            return null;
        }
        File file = null;
        try {
            file = Paths.get(uri).toFile();
        }
        catch (Exception exception) {
            return null;
        }
        if (file == null || !this.isValidExtension(file.getName())) {
            return null;
        }
        return CHEditorFactory.newFileDiagram(null, file, new CHConfig(null, languageKind), 2).createEditorInput();
    }

    private boolean isValidExtension(String fileName) {
        return fileName.length() >= 4 && !EXTENSION_CHD.equalsIgnoreCase(fileName.substring(fileName.length() - 4));
    }
}

