/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.diagrams.editor;

import java.util.Optional;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IReusableEditor;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import ro.amiq.dvt.diagrams.editor.DDiagramEditor;
import ro.amiq.dvt.diagrams.editor.DDiagramEditorInput;
import ro.amiq.dvt.diagrams.editor.DDiagramEditorUtilsCommon;
import ro.amiq.dvt.startup.core.DVTLogger;

public class DDiagramEditorUtils
extends DDiagramEditorUtilsCommon {
    private static DDiagramEditorUtils INSTANCE;
    private static final Object SYNC_OBJECT;

    static {
        SYNC_OBJECT = new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DDiagramEditorUtils getInstance() {
        if (INSTANCE == null) {
            Object object = SYNC_OBJECT;
            synchronized (object) {
                INSTANCE = new DDiagramEditorUtils();
            }
        }
        return INSTANCE;
    }

    @Override
    public IEditorPart openNew(DDiagramEditorInput input) {
        block3: {
            try {
                if (input != null) break block3;
                return null;
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
                return null;
            }
        }
        IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        return activePage.openEditor((IEditorInput)input, "ro.amiq.dvt.diagrams.editor", true, 0);
    }

    @Override
    public void openReuse(DDiagramEditor diagramEditor, DDiagramEditorInput input) {
        try {
            if (input == null) {
                return;
            }
            IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            activePage.reuseEditor((IReusableEditor)diagramEditor, (IEditorInput)input);
            activePage.activate((IWorkbenchPart)diagramEditor);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    @Override
    public void open(DDiagramEditorInput input) {
        try {
            if (input == null) {
                return;
            }
            IWorkbench workbench = PlatformUI.getWorkbench();
            if (workbench == null) {
                return;
            }
            IWorkbenchWindow activeWorkbenchWindow = workbench.getActiveWorkbenchWindow();
            if (activeWorkbenchWindow == null) {
                return;
            }
            IWorkbenchPage activePage = activeWorkbenchWindow.getActivePage();
            if (activePage == null) {
                return;
            }
            Optional<DDiagramEditor> sameInput = DDiagramEditor.diagramEditorsAsStream().filter(editor -> input.equals(editor.getInput())).findFirst();
            if (sameInput.isPresent()) {
                activePage.activate((IWorkbenchPart)sameInput.get());
                return;
            }
            Optional<DDiagramEditor> unpinnedEditor = DDiagramEditor.diagramEditorsAsStream().filter(editor -> !editor.isPinned()).findFirst();
            if (unpinnedEditor.isPresent()) {
                activePage.reuseEditor((IReusableEditor)unpinnedEditor.get(), (IEditorInput)input);
                activePage.activate((IWorkbenchPart)unpinnedEditor.get());
                return;
            }
            activePage.openEditor((IEditorInput)input, "ro.amiq.dvt.diagrams.editor", true, 0);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    @Override
    protected IWorkbenchWindow getActiveWorkbenchWindow() {
        return PlatformUI.getWorkbench().getActiveWorkbenchWindow();
    }
}

