/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.diagrams.editor;

import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.keys.IBindingService;
import ro.amiq.dvt.diagrams.DDiagram;
import ro.amiq.dvt.diagrams.editor.DDiagramEditor;
import ro.amiq.dvt.diagrams.editor.DDiagramEditorFactory;
import ro.amiq.dvt.diagrams.editor.DMenuActionCommon;
import ro.amiq.dvt.diagrams.editor.DiagramBreadcrumbUtils;
import ro.amiq.dvt.ui.editor.breadcrumb.BreadcrumbSegment;
import ro.amiq.dvt.ui.editor.breadcrumb.IDVTBreadcrumbHost;
import ro.amiq.dvt.utils.DVTFileUtils;

public abstract class DMenuAction
extends DMenuActionCommon {
    private static final SelectionListener LISTENER = new SelectionListener(){

        public void widgetSelected(SelectionEvent e) {
            Object action;
            Object source = e.getSource();
            if (source instanceof MenuItem && (action = ((MenuItem)source).getData()) instanceof Runnable) {
                ((Runnable)action).run();
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }
    };
    private final Image image;

    protected DMenuAction(DDiagram diagram, String text) {
        this(diagram, text, null);
    }

    protected DMenuAction(DDiagram diagram, String text, Image image) {
        if (text == null) {
            throw new IllegalArgumentException();
        }
        this.diagram = diagram;
        this.text = text;
        this.image = image;
    }

    @Override
    public void create(Menu menu) {
        MenuItem menuItem = new MenuItem(menu, 8);
        menuItem.setText(this.text);
        menuItem.setImage(this.image);
        menuItem.setEnabled(this.isEnabled());
        menuItem.setData(this::run);
        menuItem.addSelectionListener(LISTENER);
    }

    @Override
    protected IDVTBreadcrumbHost getEditor() {
        IEditorPart activeEditor = DVTFileUtils.getInstance().getActiveEditor();
        if (!(activeEditor instanceof DDiagramEditor)) {
            return null;
        }
        return (DDiagramEditor)activeEditor;
    }

    public static String getNameWithKeyBinding(String actionTitle, String commandId) {
        StringBuilder label = new StringBuilder();
        label.append(actionTitle);
        String keyBinding = null;
        IBindingService bindingService = (IBindingService)PlatformUI.getWorkbench().getAdapter(IBindingService.class);
        if (bindingService != null) {
            keyBinding = bindingService.getBestActiveBindingFormattedFor(commandId);
        }
        if (keyBinding != null) {
            label.append("\t").append(keyBinding);
        }
        return label.toString();
    }

    @Override
    protected IProject getProject() {
        IDVTBreadcrumbHost activeEditor = this.getEditor();
        if (activeEditor == null) {
            return null;
        }
        return activeEditor.getProject();
    }

    @Override
    protected List<BreadcrumbSegment> getBreadcrumbSegments() {
        return DiagramBreadcrumbUtils.getInstance().getBreadcrumbSegments();
    }

    @Override
    protected void openEditor(DDiagramEditorFactory editorFactory) {
        if (editorFactory == null) {
            return;
        }
        editorFactory.openEditor();
    }

    @Override
    protected void openEditor(DDiagramEditorFactory editorFactory, boolean openNewEditor) {
        if (editorFactory == null) {
            return;
        }
        if (openNewEditor) {
            editorFactory.openNewEditor();
        } else {
            editorFactory.openEditor();
        }
    }

    @Override
    protected void openReuseEditor(DDiagramEditorFactory factory, DDiagramEditor diagramEditor) {
        factory.openReuseEditor(diagramEditor);
    }
}

