/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.diagrams.editor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import ro.amiq.dvt.diagrams.DDiagram;
import ro.amiq.dvt.diagrams.design.DSchematicDiagram;
import ro.amiq.dvt.diagrams.editor.DDiagramEditor;
import ro.amiq.dvt.diagrams.editor.DDiagramEditorFactory;
import ro.amiq.dvt.diagrams.editor.DMenuItem;
import ro.amiq.dvt.diagrams.editor.DiagramBreadcrumbUtils;
import ro.amiq.dvt.diagrams.netlist.model.NLAbstractBase;
import ro.amiq.dvt.diagrams.netlist.model.NLELInstanceGate;
import ro.amiq.dvt.diagrams.netlist.model.NLInstanceGate;
import ro.amiq.dvt.diagrams.netlist.model.NLPort;
import ro.amiq.dvt.elaboration.core.ELInstance;
import ro.amiq.dvt.elaboration.core.ELManager;
import ro.amiq.dvt.elaboration.model.DiagramInstanceWrapper;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.IRfBreadcrumbElement;
import ro.amiq.dvt.model.reflection.IRfInstanceElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.RfMixedLangManager;
import ro.amiq.dvt.ui.editor.breadcrumb.BreadcrumbInput;
import ro.amiq.dvt.ui.editor.breadcrumb.BreadcrumbSegment;
import ro.amiq.dvt.ui.editor.breadcrumb.IDVTBreadcrumbHost;
import ro.amiq.dvt.ui.editor.dhbreadcrumb.DHBreadcrumbViewer;

public abstract class DMenuActionCommon
implements DMenuItem {
    protected DDiagram diagram;
    protected String text;

    public DDiagram getDiagram() {
        return this.diagram;
    }

    public TopInstanceResult getBreadcrumbUpwardsOf(NLInstanceGate initialTop) {
        ELManager elManager = RfMixedLangManager.getInstance().getELManager(this.getProject());
        if (elManager == null) {
            return null;
        }
        BreadcrumbInput breadcrumbInput = this.getBreadcrumbInput();
        if (breadcrumbInput == null) {
            return null;
        }
        BreadcrumbInput target = breadcrumbInput.getParentInputExcludingGenerates();
        if (target == null) {
            return null;
        }
        IRfBreadcrumbElement breadcrumbLeafSegment = target.getLeafSegment();
        if (!(breadcrumbLeafSegment instanceof ElementPath)) {
            return null;
        }
        if (ElementPath.$ROOT_NAME_PATH.equals(breadcrumbLeafSegment)) {
            return null;
        }
        ELInstance instanceFor = elManager.getMemory().instanceFor(((ElementPath)breadcrumbLeafSegment).toElaborationForm());
        if (instanceFor == null) {
            return null;
        }
        IRfInstanceElement instance = instanceFor.getDescription();
        ElementPath instancePath = target.getElementPath();
        return new TopInstanceResult(instancePath, instance, target.getInputSegments(), Collections.singletonList(initialTop));
    }

    public TopInstanceResult getBreadcrumbDownwardOf(NLAbstractBase element, Set<NLAbstractBase> originalElements) {
        IDVTBreadcrumbHost activeEditor = this.getEditor();
        if (activeEditor == null) {
            return null;
        }
        NLInstanceGate enclosingGate = null;
        enclosingGate = element instanceof NLPort ? element.getEnclosingGate().getEnclosingGateExcludingGenerateBlocks() : (NLInstanceGate)element.getEnclosingGateExcludingGenerateBlocks();
        ArrayList<NLAbstractBase> copyElements = new ArrayList<NLAbstractBase>();
        for (NLAbstractBase copyElement : originalElements) {
            if (element instanceof NLPort) {
                copyElements.add(copyElement.getEnclosingGate());
                continue;
            }
            copyElements.add(copyElement);
        }
        List<BreadcrumbSegment> breadcrumbSegments = null;
        BreadcrumbInput breadcrumbInput = this.getBreadcrumbInput();
        if (breadcrumbInput != null) {
            List<BreadcrumbSegment> gatePathElements;
            List<BreadcrumbSegment> inputPathElements = breadcrumbInput.getInputSegments();
            if (inputPathElements == null) {
                inputPathElements = new ArrayList<BreadcrumbSegment>(2);
            }
            if ((gatePathElements = enclosingGate.getPathSegments()) != null) {
                Collections.reverse(gatePathElements);
                if (!inputPathElements.isEmpty()) {
                    gatePathElements.removeAll(inputPathElements);
                }
                inputPathElements.addAll(gatePathElements);
                breadcrumbSegments = inputPathElements;
            }
        }
        IRfNamedElement instanceOrDesign = null;
        instanceOrDesign = enclosingGate instanceof NLELInstanceGate ? enclosingGate.getMapping(DiagramInstanceWrapper.class).getDescription() : enclosingGate.getMapping(IRfNamedElement.class);
        if (breadcrumbSegments == null) {
            return new TopInstanceResult(null, instanceOrDesign, null, copyElements);
        }
        BreadcrumbSegment breadcrumbSegment = (BreadcrumbSegment)breadcrumbSegments.get(breadcrumbSegments.size() - 1);
        if (breadcrumbSegment == null) {
            return new TopInstanceResult(null, instanceOrDesign, null, copyElements);
        }
        IRfBreadcrumbElement elementPath = breadcrumbSegment.getElement();
        if (!(elementPath instanceof ElementPath)) {
            return new TopInstanceResult(null, instanceOrDesign, null, copyElements);
        }
        return new TopInstanceResult((ElementPath)elementPath, instanceOrDesign, breadcrumbSegments, copyElements);
    }

    protected BreadcrumbInput getBreadcrumbInput() {
        return DiagramBreadcrumbUtils.getBreadcrumbInput(DHBreadcrumbViewer.class, this.getEditor());
    }

    public int getDepth(DDiagram diagram) {
        if (diagram instanceof DSchematicDiagram) {
            return ((DSchematicDiagram)diagram).getDepth();
        }
        return 1;
    }

    public abstract void run();

    protected abstract IProject getProject();

    protected abstract IDVTBreadcrumbHost getEditor();

    protected abstract List<BreadcrumbSegment> getBreadcrumbSegments();

    protected abstract void openEditor(DDiagramEditorFactory var1);

    protected abstract void openEditor(DDiagramEditorFactory var1, boolean var2);

    protected abstract void openReuseEditor(DDiagramEditorFactory var1, DDiagramEditor var2);

    public static class TopInstanceResult {
        private ElementPath topInstancePath;
        private IRfNamedElement topNamedElement;
        private List<BreadcrumbSegment> breadcrumbSegments;
        private List<NLAbstractBase> copyElement;

        public TopInstanceResult(ElementPath instancePath, IRfNamedElement namedElement, List<BreadcrumbSegment> newBreadcrumbSegments, List<NLAbstractBase> copyElement) {
            this.topInstancePath = instancePath;
            this.topNamedElement = namedElement;
            this.breadcrumbSegments = newBreadcrumbSegments;
            this.copyElement = copyElement;
        }

        public ElementPath getInstancePath() {
            return this.topInstancePath;
        }

        public IRfNamedElement getNamedElement() {
            return this.topNamedElement;
        }

        public List<BreadcrumbSegment> getBreadcrumbSegments() {
            return this.breadcrumbSegments;
        }

        public List<NLAbstractBase> getCopyElements() {
            return this.copyElement;
        }
    }
}

