/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.diagrams.editor;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import ro.amiq.dvt.diagrams.DConstants;
import ro.amiq.dvt.diagrams.editor.DDiagramEditor;
import ro.amiq.dvt.diagrams.editor.DMenuItem;
import ro.amiq.dvt.diagrams.editor.DMouseManagerCommon;
import ro.amiq.dvt.diagrams.editor.DSelectionContributor;
import ro.amiq.dvt.draw.DCanvas;
import ro.amiq.dvt.draw.handlers.DClickEvent;
import ro.amiq.dvt.draw.obj.base.DObject;
import ro.amiq.dvt.draw.obj.interaction.DSelectable;

public class DMouseManager
extends DMouseManagerCommon
implements DisposeListener {
    private final DCanvas canvas;
    private final Menu menu;

    public DMouseManager(DDiagramEditor diagramEditor) {
        this.diagramEditor = diagramEditor;
        this.canvas = this.diagramEditor.getCanvas();
        this.canvas.addDisposeListener(this);
        this.menu = new Menu((Control)this.canvas);
        this.currentSelection = new HashMap();
        this.selectionChanged = false;
    }

    @Override
    public void handleEvent(DClickEvent event) {
        if (event.getButton() != 1 && event.getButton() != 3 || event.getStateMask() != 0 && event.getStateMask() != SWT.MOD1) {
            return;
        }
        this.handleEvent(event.getLastHit(DSelectable.class), event.getButton(), event.getStateMask(), event.getPoint(), event);
    }

    public void testHandleEvent(DSelectable hit, boolean addSelection) {
        this.handleEvent(hit, 1, addSelection ? SWT.MOD1 : 0, new Point(0, 0), null);
    }

    @Override
    protected void handleEvent(DSelectable hit, int button, int mask, Point point, DClickEvent event) {
        Map<Object, Object> selection = null;
        selection = hit == null ? Collections.emptyMap() : this.diagramEditor.getInput().getSelectionContributor().getSelectedObjects(this.diagramEditor, hit);
        if (mask == 0) {
            if (button == 1) {
                this.internalSetSelection(selection);
            } else if (!(button != 3 || hit != null && DSelectionContributor.getMainSelection(this.currentSelection).contains(hit))) {
                this.internalSetSelection(selection);
            }
        } else if (mask == SWT.MOD1) {
            if (button == 1) {
                this.xorSelection(selection);
            } else if (button == 3) {
                if (DSelectionContributor.getMainSelection(selection).isEmpty()) {
                    this.internalSetSelection(selection);
                } else if (hit == null || !DSelectionContributor.getMainSelection(this.currentSelection).contains(hit)) {
                    this.xorSelection(selection);
                }
            }
        }
        this.promoteLastSelection(hit);
        if (DConstants.DEBUG) {
            this.diagramEditor.getCanvas().getDebug().clear("editor/selection");
            for (Map.Entry entry : this.currentSelection.entrySet()) {
                for (DSelectable object : (Set)entry.getValue()) {
                    if (!(object instanceof DObject)) continue;
                    this.diagramEditor.getCanvas().getDebug().log("editor/selection/" + (String)entry.getKey() + "/" + ((DObject)((Object)object)).nameString(), ((DObject)((Object)object)).valueString());
                }
            }
        }
        if (event == null) {
            if (button == 3) {
                this.showMenu(point, this.diagramEditor.getInput().getMenuContributor().getMenuItems(this.diagramEditor, DSelectionContributor.getMainSelection(this.currentSelection)));
            }
        } else {
            Runnable mkcRunnable = null;
            if (!event.getKeyCodes().isEmpty()) {
                mkcRunnable = this.diagramEditor.getInput().getMKCContributor().getMKCActions(this.diagramEditor, DSelectionContributor.getMainSelection(this.currentSelection), event.getButton(), event.getStateMask(), event.getKeyCodes());
            }
            if (mkcRunnable != null) {
                this.canvas.getDisplay().syncExec(mkcRunnable);
            } else if (event.getButton() == 3) {
                this.showMenu(event.getPoint(), this.diagramEditor.getInput().getMenuContributor().getMenuItems(this.diagramEditor, DSelectionContributor.getMainSelection(this.currentSelection)));
            }
        }
        this.fireSelectionChanged();
        this.diagramEditor.getCanvas().getRenderer().render();
    }

    private void showMenu(final Point location, final List<DMenuItem> dMenuItems) {
        if (dMenuItems == null || dMenuItems.isEmpty()) {
            return;
        }
        if (this.canvas.isDisposed()) {
            return;
        }
        this.canvas.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                if (DMouseManager.this.canvas.isDisposed()) {
                    return;
                }
                DMouseManager.this.disposeMenuItems(DMouseManager.this.menu.getItems());
                for (DMenuItem dMenuItem : dMenuItems) {
                    dMenuItem.create(DMouseManager.this.menu);
                }
                DMouseManager.this.menu.setLocation(DMouseManager.this.canvas.toDisplay(location));
                DMouseManager.this.menu.setVisible(true);
            }
        });
    }

    private void disposeMenuItems(MenuItem[] items) {
        MenuItem[] menuItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            MenuItem item = menuItemArray[n2];
            Menu submenu = item.getMenu();
            if (submenu != null) {
                this.disposeMenuItems(submenu.getItems());
                submenu.dispose();
            }
            item.dispose();
            ++n2;
        }
    }

    public void widgetDisposed(DisposeEvent e) {
        if (this.menu != null && !this.menu.isDisposed()) {
            this.menu.dispose();
        }
    }
}

