/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.diagrams.editor;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.swt.graphics.Point;
import ro.amiq.dvt.diagrams.editor.DDiagramEditor;
import ro.amiq.dvt.diagrams.editor.DSelectionContributor;
import ro.amiq.dvt.draw.handlers.DClickEvent;
import ro.amiq.dvt.draw.handlers.DClickListener;
import ro.amiq.dvt.draw.obj.interaction.DSelectable;
import ro.amiq.dvt.test.Objection;
import ro.amiq.dvt.test.ObjectionManager;

public abstract class DMouseManagerCommon
implements DClickListener {
    protected DDiagramEditor diagramEditor;
    protected Map<String, Set<DSelectable>> currentSelection;
    protected boolean selectionChanged;

    protected abstract void handleEvent(DSelectable var1, int var2, int var3, Point var4, DClickEvent var5);

    protected Map<String, Set<DSelectable>> getSelection(DSelectable hit) {
        if (hit == null) {
            return Collections.emptyMap();
        }
        return this.diagramEditor.getInput().getSelectionContributor().getSelectedObjects(this.diagramEditor, hit);
    }

    public void setSelection(Map<String, Set<DSelectable>> selection) {
        this.selectionChanged = true;
        this.internalSetSelection(selection);
        this.fireSelectionChanged();
    }

    public void clearSelection() {
        this.internalSetSelection(Collections.emptyMap());
        this.fireSelectionChanged();
    }

    protected void internalSetSelection(Map<String, Set<DSelectable>> selection) {
        String type;
        if (this.currentSelection.equals(selection)) {
            ObjectionManager.getInstance().conditionalClear(selection != null && !selection.isEmpty(), Objection.DIAGRAM_EDITOR_CHANGED_SELECTION);
            return;
        }
        for (Map.Entry<String, Set<DSelectable>> entry : this.currentSelection.entrySet()) {
            type = entry.getKey();
            for (DSelectable object : entry.getValue()) {
                if (object == null) continue;
                object.select(false, type);
            }
        }
        this.currentSelection.clear();
        for (Map.Entry<String, Set<DSelectable>> entry : selection.entrySet()) {
            type = entry.getKey();
            LinkedHashSet<DSelectable> currentSelectionByType = new LinkedHashSet<DSelectable>();
            for (DSelectable object : entry.getValue()) {
                if (object == null) continue;
                object.select(true, type);
                currentSelectionByType.add(object);
            }
            this.currentSelection.put(type, currentSelectionByType);
        }
        this.selectionChanged = true;
    }

    protected void xorSelection(Map<String, Set<DSelectable>> selection) {
        if (selection.isEmpty()) {
            return;
        }
        for (Map.Entry<String, Set<DSelectable>> entry : selection.entrySet()) {
            String type = entry.getKey();
            Set<DSelectable> currentSelectionByType = this.currentSelection.get(type);
            if (currentSelectionByType == null) {
                currentSelectionByType = new LinkedHashSet<DSelectable>();
                this.currentSelection.put(type, currentSelectionByType);
            }
            for (DSelectable object : entry.getValue()) {
                if (currentSelectionByType.contains(object)) {
                    object.select(false, type);
                    currentSelectionByType.remove(object);
                    continue;
                }
                object.select(true, type);
                currentSelectionByType.add(object);
            }
        }
        this.selectionChanged = true;
    }

    protected void promoteLastSelection(DSelectable lastSelection) {
        if (lastSelection == null) {
            return;
        }
        for (Set<DSelectable> selections : this.currentSelection.values()) {
            if (!selections.contains(lastSelection)) continue;
            selections.remove(lastSelection);
            selections.add(lastSelection);
        }
    }

    protected void fireSelectionChanged() {
        if (!this.selectionChanged) {
            return;
        }
        this.selectionChanged = false;
        this.diagramEditor.fireSelectionChanged(DSelectionContributor.getMainSelection(this.currentSelection));
    }
}

