/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.diagrams.editor;

import java.util.ArrayList;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import ro.amiq.dvt.diagrams.editor.DDiagramEditor;
import ro.amiq.dvt.diagrams.editor.DSearchManagerCommon;
import ro.amiq.dvt.draw.obj.base.DObject;

public class DSearchManager
extends DSearchManagerCommon
implements DisposeListener {
    private final ThreadPoolExecutor searchExecutor;

    public DSearchManager(DDiagramEditor diagramEditor) {
        this.diagramEditor = diagramEditor;
        this.diagramEditor.getCanvas().addDisposeListener(this);
        this.searchExecutor = new ThreadPoolExecutor(0, 1, 30L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadPoolExecutor.DiscardPolicy());
        this.matchedObjects = new ArrayList();
        this.currentMatch = -1;
        this.query = "";
    }

    private void execute(Runnable runnable) {
        if (this.searchExecutor.isShutdown()) {
            return;
        }
        this.searchExecutor.execute(runnable);
    }

    public void widgetDisposed(DisposeEvent e) {
        this.searchExecutor.shutdownNow();
        this.diagramEditor.getCanvas().removeDisposeListener(this);
    }

    public void search(String query) {
        this.execute(() -> this.internalSearch(query));
    }

    public void refreshSearch() {
        this.execute(this::internalRefreshSearch);
    }

    public void previousMatch() {
        this.execute(this::internalPreviousMatch);
    }

    public void nextMatch() {
        this.execute(this::internalNextMatch);
    }

    @Override
    protected void updateDiagram() {
        this.diagramEditor.getCanvas().getViewport().zoomToCurrentContentObject((DObject)this.matchedObjects.get(this.currentMatch));
        this.diagramEditor.setSearchMatches(this.currentMatch + 1, this.matchedObjects.size());
    }

    @Override
    protected void renderDiagram() {
        this.diagramEditor.getCanvas().getRenderer().render();
        this.diagramEditor.setSearchMatches(this.currentMatch + 1, this.matchedObjects.size());
    }

    @Override
    protected boolean isCanceled() {
        return false;
    }
}

