/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.diagrams.editor;

import java.util.Comparator;
import java.util.List;
import org.eclipse.swt.graphics.Rectangle;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.diagrams.editor.DDiagramEditor;
import ro.amiq.dvt.draw.obj.base.DGroup;
import ro.amiq.dvt.draw.obj.base.DObject;
import ro.amiq.dvt.draw.obj.interaction.DSearchable;
import ro.amiq.dvt.ui.views.ViewsUtils;

public abstract class DSearchManagerCommon {
    protected static final Comparator<DSearchable> TOPOLOGICAL_COMPARATOR = new Comparator<DSearchable>(){
        private static final int RESOLUTION = 150;

        @Override
        public int compare(DSearchable o1, DSearchable o2) {
            Rectangle ob1 = ((DObject)((Object)o1)).getBounds();
            Rectangle ob2 = ((DObject)((Object)o2)).getBounds();
            int result = Integer.compare(ob1.y / 150, ob2.y / 150);
            if (result != 0) {
                return result;
            }
            result = Integer.compare(ob1.x / 150, ob2.x / 150);
            if (result != 0) {
                return result;
            }
            result = Integer.compare(ob1.y, ob2.y);
            if (result != 0) {
                return result;
            }
            result = Integer.compare(ob1.x, ob2.x);
            return result;
        }
    };
    protected DDiagramEditor diagramEditor;
    protected List<DSearchable> matchedObjects;
    protected int currentMatch;
    protected String query;

    public DDiagramEditor getDiagramEditor() {
        return this.diagramEditor;
    }

    protected void findMatches(DObject object, String query, List<DSearchable> matches) {
        List<DObject> children;
        String text;
        if (object instanceof DSearchable && (text = ((DSearchable)((Object)object)).getSearchText()) != null && ViewsUtils.matchCamelCaseOrRegex(ViewsUtils.createCamelCaseOrRegexMatcher(query, true, false), text.trim())) {
            matches.add((DSearchable)((Object)object));
        }
        if (object instanceof DGroup && (children = ((DGroup)object).getChildren()) != null) {
            for (DObject child : children) {
                this.findMatches(child, query, matches);
            }
        }
    }

    protected void internalPreviousMatch() {
        if (this.matchedObjects.isEmpty()) {
            return;
        }
        this.selectMatch(this.currentMatch <= 0 ? this.matchedObjects.size() - 1 : this.currentMatch - 1);
    }

    protected void internalNextMatch() {
        if (this.matchedObjects.isEmpty()) {
            return;
        }
        this.selectMatch(this.currentMatch >= this.matchedObjects.size() - 1 ? 0 : this.currentMatch + 1);
    }

    protected void internalSearch(String newQuery) {
        if (newQuery.equals(this.query)) {
            return;
        }
        this.query = newQuery;
        this.internalRefreshSearch();
    }

    private void selectMatch(int match) {
        if (match != this.currentMatch) {
            if (this.currentMatch != -1) {
                this.matchedObjects.get(this.currentMatch).highlightSearchMatch(DSearchable.Highlight.MATCH);
            }
            if (match != -1) {
                this.matchedObjects.get(match).highlightSearchMatch(DSearchable.Highlight.CURRENT_MACH);
            }
            this.currentMatch = match;
        }
        this.updateDiagram();
    }

    protected void internalRefreshSearch() {
        DObject content;
        for (DSearchable matchedObject : this.matchedObjects) {
            if (this.isCanceled()) {
                return;
            }
            matchedObject.highlightSearchMatch(DSearchable.Highlight.NONE);
        }
        this.matchedObjects.clear();
        this.currentMatch = -1;
        if (!this.query.isEmpty() && (content = this.diagramEditor.getCanvas().getContent()) != null) {
            this.findMatches(content, this.query, this.matchedObjects);
            this.matchedObjects.sort(TOPOLOGICAL_COMPARATOR);
            for (DSearchable matchedObject : this.matchedObjects) {
                if (this.isCanceled()) {
                    return;
                }
                matchedObject.highlightSearchMatch(DSearchable.Highlight.MATCH);
            }
        }
        this.renderDiagram();
        if (DVTPlugin.getDefault().getPreferenceStore().getBoolean("diagram.search_jump_to_first_match")) {
            this.internalNextMatch();
        }
    }

    protected abstract void updateDiagram();

    protected abstract void renderDiagram();

    protected abstract boolean isCanceled();
}

