/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.diagrams.editor;

import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IActionDelegate2;
import org.eclipse.ui.IWorkbenchWindowPulldownDelegate2;
import ro.amiq.dvt.diagrams.editor.IDiagramToolbarMenuItemProvider;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.editor.actions.DVTEditorActionDelegate;

public class DVTDiagramActionDelegate
extends DVTEditorActionDelegate
implements IActionDelegate2,
IWorkbenchWindowPulldownDelegate2 {
    public static final String DIAGR_TOOLBAR_MENU_ITEM_EXTENSION_POINT_ID = "ro.amiq.dvt.diagramToolbarMenuItemContributors";
    public static final String DIAGR_TOOLBAR_MENU_ITEM_ELEMENT_1 = "diagramToolbarMenuItemContributor";
    public static final String DIAGR_TOOLBAR_MENU_ITEM_ELEMENT_2 = "toolbarMenuItemContributor";
    private Menu fToolbarMenu;
    private Menu fMenuMenu;
    private IStructuredSelection fSelection;
    private boolean fRecreateMenu;

    @Override
    public void dispose() {
        super.dispose();
        this.fSelection = null;
        if (this.fToolbarMenu != null) {
            this.fToolbarMenu.dispose();
        }
        if (this.fMenuMenu != null) {
            this.fMenuMenu.dispose();
        }
    }

    @Override
    public void run(IAction action) {
        Shell parent = this.getWindow().getShell();
        this.getMenu((Control)parent).setVisible(true);
    }

    @Override
    public void selectionChanged(IAction action, ISelection selection) {
        this.fSelection = null;
        this.fRecreateMenu = true;
        super.selectionChanged(action, selection);
        if (selection instanceof IStructuredSelection) {
            this.fSelection = (IStructuredSelection)selection;
            return;
        }
        IResource resource = this.getResource();
        if (resource == null) {
            return;
        }
        if (resource instanceof IFile) {
            this.fSelection = new StructuredSelection((Object)((IFile)resource).getParent());
            return;
        }
        this.fSelection = new StructuredSelection((Object)resource);
    }

    public void populateMenu(Menu menu) {
        MenuItem[] items;
        if (menu == null || menu.isDisposed()) {
            return;
        }
        MenuItem[] menuItemArray = items = menu.getItems();
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            MenuItem item = menuItemArray[n2];
            item.dispose();
            ++n2;
        }
        ArrayList<IDiagramToolbarMenuItemProvider> providers = new ArrayList<IDiagramToolbarMenuItemProvider>();
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(DIAGR_TOOLBAR_MENU_ITEM_EXTENSION_POINT_ID);
        IExtension[] iExtensionArray = extensionPoint.getExtensions();
        int n3 = iExtensionArray.length;
        int n4 = 0;
        while (n4 < n3) {
            IExtension extension = iExtensionArray[n4];
            IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
            int n5 = iConfigurationElementArray.length;
            int n6 = 0;
            while (n6 < n5) {
                IConfigurationElement configurationElement = iConfigurationElementArray[n6];
                if (!DIAGR_TOOLBAR_MENU_ITEM_ELEMENT_1.equals(configurationElement.getName()) && !DIAGR_TOOLBAR_MENU_ITEM_ELEMENT_2.equals(configurationElement.getName())) {
                    DVTLogger.INSTANCE.logError((Throwable)new Exception("Invalid element: " + configurationElement + "for extension point: " + DIAGR_TOOLBAR_MENU_ITEM_EXTENSION_POINT_ID));
                }
                try {
                    IDiagramToolbarMenuItemProvider provider = (IDiagramToolbarMenuItemProvider)configurationElement.createExecutableExtension("class");
                    providers.add(provider);
                }
                catch (CoreException e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                }
                ++n6;
            }
            ++n4;
        }
        Collections.sort(providers);
        for (IDiagramToolbarMenuItemProvider provider : providers) {
            provider.addMenuEntry(menu, this.fSelection, this.getWindow());
        }
    }

    public Menu getMenu(Control parent) {
        if (this.fToolbarMenu != null) {
            this.fToolbarMenu.dispose();
        }
        this.fToolbarMenu = new Menu(parent);
        this.populateMenu(this.fToolbarMenu);
        return this.fToolbarMenu;
    }

    public Menu getMenu(Menu parent) {
        if (this.fMenuMenu == null) {
            this.fMenuMenu = new Menu(parent);
        }
        this.populateMenu(this.fMenuMenu);
        this.fMenuMenu.addMenuListener((MenuListener)new MenuAdapter(){

            public void menuShown(MenuEvent e) {
                if (DVTDiagramActionDelegate.this.fRecreateMenu) {
                    Menu m = (Menu)e.widget;
                    MenuItem[] items = m.getItems();
                    int i = 0;
                    while (i < items.length) {
                        items[i].dispose();
                        ++i;
                    }
                    DVTDiagramActionDelegate.this.populateMenu(m);
                    DVTDiagramActionDelegate.this.fRecreateMenu = false;
                }
            }
        });
        return this.fMenuMenu;
    }

    public void runWithEvent(IAction action, Event e) {
        Widget item = e.widget;
        if (item instanceof ToolItem) {
            ToolItem ti = (ToolItem)item;
            Menu menu = this.getMenu((Control)ti.getParent());
            if (menu == null) {
                return;
            }
            Rectangle rect = ti.getBounds();
            Point point = ti.getParent().toDisplay(new Point(rect.x, rect.y + rect.height));
            menu.setLocation(point.x, point.y);
            menu.setVisible(true);
        }
    }

    public void init(IAction action) {
    }
}

