/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.diagrams.editor;

import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import ro.amiq.dvt.IDVTConstants;
import ro.amiq.dvt.diagrams.editor.DDiagramEditor;
import ro.amiq.dvt.diagrams.editor.DDiagramEditorInput;
import ro.amiq.dvt.diagrams.editor.DiagramBreadcrumbUtilsCommon;
import ro.amiq.dvt.model.reflection.IRfDesignElement;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.Utils;
import ro.amiq.dvt.ui.actions.breadcrumb.BreadcrumbMode;
import ro.amiq.dvt.ui.editor.breadcrumb.AbstractBreadcrumbConfiguration;
import ro.amiq.dvt.ui.editor.breadcrumb.AbstractBreadcrumbViewer;
import ro.amiq.dvt.ui.editor.breadcrumb.BreadcrumbInput;
import ro.amiq.dvt.ui.editor.breadcrumb.BreadcrumbSegment;
import ro.amiq.dvt.ui.editor.breadcrumb.IDVTBreadcrumbHost;
import ro.amiq.dvt.ui.editor.dhbreadcrumb.DHBreadcrumbViewer;

public class DiagramBreadcrumbUtils
extends DiagramBreadcrumbUtilsCommon {
    private static DiagramBreadcrumbUtils INSTANCE;

    public static synchronized DiagramBreadcrumbUtils getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new DiagramBreadcrumbUtils();
        }
        return INSTANCE;
    }

    @Override
    public BreadcrumbInput computeBreadcrumbInput(IDVTBreadcrumbHost activeEditor, AbstractBreadcrumbConfiguration configuration, boolean enabled) {
        block10: {
            try {
                if (activeEditor instanceof DDiagramEditor) break block10;
                return null;
            }
            catch (CoreException e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
                return null;
            }
        }
        DDiagramEditor diagramEditor = (DDiagramEditor)activeEditor;
        IRfDesignElement designElemInFile = this.getDesignElementInFile(diagramEditor);
        if (designElemInFile == null) {
            return BreadcrumbInput.REMOVE_BREADCRUMB;
        }
        BreadcrumbInput inputFromMeta = this.getInputFromMeta(diagramEditor);
        if (inputFromMeta == BreadcrumbInput.CLEAR) {
            diagramEditor.setBCCache(null, DHBreadcrumbViewer.class);
        } else if (this.validateInput(inputFromMeta)) {
            diagramEditor.setBCCache(inputFromMeta, DHBreadcrumbViewer.class);
            return inputFromMeta;
        }
        BreadcrumbInput inputFromCache = this.getInputFromCache(diagramEditor);
        if (this.validateInput(inputFromCache)) {
            return inputFromCache;
        }
        BreadcrumbInput inputAfterCloneOrSplit = this.getInputAfterCloneOrSplit(diagramEditor);
        if (inputAfterCloneOrSplit != null && inputAfterCloneOrSplit.getInputSegments() != null) {
            return inputAfterCloneOrSplit;
        }
        BreadcrumbInput inputFromFile = this.getInputFromFile(designElemInFile, diagramEditor, enabled);
        if (inputFromFile != null) {
            diagramEditor.setBCCache(inputFromFile, DHBreadcrumbViewer.class);
            return inputFromFile;
        }
        return null;
    }

    private BreadcrumbInput getInputFromMeta(DDiagramEditor activeEditor) throws CoreException {
        DDiagramEditorInput editorInput = activeEditor.getInput();
        if (editorInput == null) {
            return null;
        }
        IResource adapter = (IResource)editorInput.getAdapter(IResource.class);
        if (adapter == null) {
            return null;
        }
        BreadcrumbInput result = (BreadcrumbInput)adapter.getSessionProperty(IDVTConstants.DH_BREADCRUMB_QN);
        adapter.setSessionProperty(IDVTConstants.DH_BREADCRUMB_QN, null);
        return result;
    }

    private BreadcrumbInput getInputFromCache(DDiagramEditor editor) {
        BreadcrumbInput bcCache = editor.getBCCache(DHBreadcrumbViewer.class);
        if (bcCache == null) {
            return null;
        }
        return new BreadcrumbInput(editor.getProject(), bcCache.getInputSegments(), editor.getBreadcrumbUtils(DHBreadcrumbViewer.class).getBreadcrumbSerializer());
    }

    private BreadcrumbInput getInputAfterCloneOrSplit(DDiagramEditor diagramEditor) {
        if (diagramEditor.getBCCache(DHBreadcrumbViewer.class) != null) {
            return null;
        }
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench == null) {
            return null;
        }
        IWorkbenchWindow activeWorkbenchWindow = workbench.getActiveWorkbenchWindow();
        if (activeWorkbenchWindow == null) {
            return null;
        }
        IWorkbenchPage workbenchPage = activeWorkbenchWindow.getActivePage();
        if (workbenchPage == null) {
            return null;
        }
        IEditorPart editorPart = workbenchPage.getActiveEditor();
        if (!(editorPart instanceof DDiagramEditor)) {
            return null;
        }
        DDiagramEditor diagramEditor2 = (DDiagramEditor)editorPart;
        BreadcrumbInput bcCache = diagramEditor2.getBCCache(DHBreadcrumbViewer.class);
        if (bcCache != null) {
            diagramEditor.setBCCache(bcCache, DHBreadcrumbViewer.class);
        }
        return this.getInputFromCache(diagramEditor2);
    }

    public List<BreadcrumbSegment> getBreadcrumbSegments() {
        IDVTBreadcrumbHost editorWithBreadcrumb = this.getActiveEditorWithBreadcrumb();
        if (editorWithBreadcrumb == null) {
            return null;
        }
        if (!editorWithBreadcrumb.hasBreadcrumbViewer(DHBreadcrumbViewer.class)) {
            return null;
        }
        AbstractBreadcrumbViewer breadcrumbViewer = editorWithBreadcrumb.getBreadcrumbViewer(DHBreadcrumbViewer.class);
        if (!(breadcrumbViewer instanceof DHBreadcrumbViewer)) {
            return null;
        }
        return this.getBreadcrumbSegments(((DHBreadcrumbViewer)breadcrumbViewer).getInput());
    }

    private IDVTBreadcrumbHost getActiveEditorWithBreadcrumb() {
        IWorkbenchWindow activeWorkbenchWindow = Utils.getActiveWorkbenchWindow();
        if (activeWorkbenchWindow == null) {
            return null;
        }
        IWorkbenchPage activePage = activeWorkbenchWindow.getActivePage();
        if (activePage == null) {
            return null;
        }
        IEditorPart activeEditor = activePage.getActiveEditor();
        if (!(activeEditor instanceof IDVTBreadcrumbHost)) {
            return null;
        }
        return (IDVTBreadcrumbHost)activeEditor;
    }

    @Override
    protected IProject getProject() {
        IDVTBreadcrumbHost editorWithBreadcrumb = this.getActiveEditorWithBreadcrumb();
        if (editorWithBreadcrumb == null) {
            return null;
        }
        return editorWithBreadcrumb.getProject();
    }

    @Override
    public String getBCType() {
        return BreadcrumbMode.DESIGN.getName();
    }

    @Override
    protected boolean shouldInhibitDesignBreadcrumb(IDVTBreadcrumbHost editor) {
        return false;
    }
}

