/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.diagrams.editor;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import ro.amiq.dvt.diagrams.DDiagram;
import ro.amiq.dvt.diagrams.design.DTopPathDiagram;
import ro.amiq.dvt.diagrams.editor.DDiagramEditor;
import ro.amiq.dvt.diagrams.editor.DDiagramEditorInput;
import ro.amiq.dvt.elaboration.core.ELInstance;
import ro.amiq.dvt.elaboration.core.ELManager;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.IRfDesignElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.RfMixedLangManager;
import ro.amiq.dvt.ui.editor.breadcrumb.BreadcrumbInput;
import ro.amiq.dvt.ui.editor.breadcrumb.BreadcrumbSegment;
import ro.amiq.dvt.ui.editor.dhbreadcrumb.DHBreadcrumbUtils;

public abstract class DiagramBreadcrumbUtilsCommon
extends DHBreadcrumbUtils {
    public List<BreadcrumbSegment> getBreadcrumbSegments(BreadcrumbInput breadcrumbInput) {
        if (breadcrumbInput == null) {
            return null;
        }
        List<BreadcrumbSegment> breadcrumbSegments = breadcrumbInput.getInputSegments();
        if (breadcrumbSegments == null || breadcrumbSegments.isEmpty()) {
            return null;
        }
        ArrayList<BreadcrumbSegment> actualSegments = new ArrayList<BreadcrumbSegment>();
        for (BreadcrumbSegment segment : breadcrumbSegments) {
            if (ElementPath.$ROOT_NAME_PATH.equals(segment.getElement())) continue;
            String lastSegment = ((ElementPath)segment.getElement()).lastSegment();
            ElementPath element = ElementPath.from(lastSegment, ".");
            actualSegments.add(new BreadcrumbSegment(element));
        }
        return actualSegments;
    }

    protected boolean validateInput(BreadcrumbInput breadcrumbInput) {
        if (breadcrumbInput == null) {
            return false;
        }
        return breadcrumbInput.validate();
    }

    protected BreadcrumbInput getInputFromFile(IRfDesignElement designElemInFile, DDiagramEditor activeEditor, boolean enabled) {
        IProject project = activeEditor.getProject();
        if (project == null) {
            return null;
        }
        ELManager elManager = RfMixedLangManager.getInstance().getELManager(project);
        if (elManager == null) {
            return null;
        }
        List<ELInstance> elInstances = elManager.getMemory().getInstancesFor(designElemInFile, !IRfNamedElement.ElementKind.VHDL_ARCHITECTURE.equals((Object)designElemInFile.getKind()), 2);
        if (elInstances.isEmpty()) {
            return null;
        }
        this.showNotifications(activeEditor, false, designElemInFile, elInstances.size() > 1, enabled);
        return new BreadcrumbInput(project, this.toBreadcrumbInput(elInstances.get(0).getHierarchyPath(), activeEditor), this.getBreadcrumbSerializer());
    }

    protected IRfDesignElement getDesignElementInFile(DDiagramEditor editor) {
        IProject project = this.getProject();
        if (project == null) {
            return null;
        }
        ELManager elManager = RfMixedLangManager.getInstance().getELManager(project);
        if (elManager == null) {
            return null;
        }
        DDiagramEditorInput diagramEditorInput = editor.getInput();
        if (diagramEditorInput == null) {
            return null;
        }
        DDiagram diagram = diagramEditorInput.getDiagram();
        if (!(diagram instanceof DTopPathDiagram)) {
            return null;
        }
        ElementPath elementPath = ((DTopPathDiagram)diagram).getTopPath();
        if (elementPath == null || elementPath.isEmpty()) {
            return null;
        }
        ELInstance instanceFor = elManager.getMemory().instanceFor(elementPath);
        if (instanceFor == null) {
            return null;
        }
        IRfNamedElement binding = instanceFor.getBinding(true);
        if (!(binding instanceof IRfDesignElement)) {
            return null;
        }
        return (IRfDesignElement)binding;
    }

    protected abstract IProject getProject();
}

