/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.diagrams.editor;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.editor.vhbreadcrumb.IVHUtilsContributor;
import ro.amiq.dvt.ui.editor.vhbreadcrumb.VHBreadcrumbUtils;

public class VHDiagramBreadcrumbUtils {
    public static final Map<LanguageKind, VHBreadcrumbUtils> utilsCache = new EnumMap<LanguageKind, VHBreadcrumbUtils>(LanguageKind.class);
    public static final String DVT_VH_DIAGRAM_BREADCRUMB_UTILS_CONTRIBUTOR_EXTENSION_POINT_ID = "ro.amiq.dvt.dvtVhDiagramBreadcrumbUtilsContributor";
    public static final String DVT_VH_DIAGRAM_BREADCRUMB_UTILS_CONTRIBUTOR_ELEMENT = "dvtVhDiagramBreadcrumbUtilsContributor";

    public static VHBreadcrumbUtils getUtils(LanguageKind nature) {
        if (utilsCache.containsKey((Object)nature)) {
            return utilsCache.get((Object)nature);
        }
        IVHUtilsContributor contributor = VHDiagramBreadcrumbUtils.getContributorByDesignElemNature(nature);
        if (contributor == null) {
            return null;
        }
        VHBreadcrumbUtils langUtils = contributor.getUtils();
        if (langUtils == null) {
            return null;
        }
        utilsCache.put(nature, langUtils);
        return langUtils;
    }

    private static IVHUtilsContributor getContributorByDesignElemNature(LanguageKind nature) {
        if (nature == null) {
            return null;
        }
        for (IVHUtilsContributor contributor : VHDiagramBreadcrumbUtils.getVHUtilsContributors()) {
            if (!nature.equals((Object)contributor.getNature())) continue;
            return contributor;
        }
        return null;
    }

    private static List<IVHUtilsContributor> getVHUtilsContributors() {
        ArrayList<IVHUtilsContributor> delegates = new ArrayList<IVHUtilsContributor>();
        try {
            IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(DVT_VH_DIAGRAM_BREADCRUMB_UTILS_CONTRIBUTOR_EXTENSION_POINT_ID);
            IExtension[] iExtensionArray = extensionPoint.getExtensions();
            int n = iExtensionArray.length;
            int n2 = 0;
            while (n2 < n) {
                IExtension extension = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
                int n3 = iConfigurationElementArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement configurationElement = iConfigurationElementArray[n4];
                    if (!DVT_VH_DIAGRAM_BREADCRUMB_UTILS_CONTRIBUTOR_ELEMENT.equals(configurationElement.getName())) {
                        DVTLogger.INSTANCE.logError((Throwable)new Exception("Invalid element: " + configurationElement + "for extension point: " + DVT_VH_DIAGRAM_BREADCRUMB_UTILS_CONTRIBUTOR_EXTENSION_POINT_ID));
                    }
                    IVHUtilsContributor quickFixContributor = (IVHUtilsContributor)configurationElement.createExecutableExtension("class");
                    delegates.add(quickFixContributor);
                    ++n4;
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return delegates;
    }
}

