/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.diagrams.editor.actions;

import java.util.ArrayList;
import org.eclipse.jface.fieldassist.ContentProposal;
import org.eclipse.jface.fieldassist.IContentProposal;

public abstract class DAbstractProposalComputer {
    private final String expression;
    private final int offset;
    private final ArrayList<IContentProposal> priorityProposals;
    private final ArrayList<IContentProposal> proposals;
    private final boolean isEscape;

    public DAbstractProposalComputer(String expression, int offset) {
        int expressionStart = 0;
        int expressionEnd = 0;
        if (expression.contains("\n")) {
            expressionStart = expression.lastIndexOf("\n", offset - 1) + 1;
            expressionEnd = expression.indexOf("\n", offset) >= 0 ? expression.indexOf("\n", offset) : expression.length();
            this.expression = expression.substring(expressionStart, expressionEnd);
        } else {
            this.expression = expression;
        }
        this.offset = offset - expressionStart;
        this.proposals = new ArrayList();
        this.priorityProposals = new ArrayList();
        boolean isEscape = false;
        int i = offset - 1;
        while (i >= 0) {
            if (expression.charAt(i) != '\\') break;
            isEscape = !isEscape;
            --i;
        }
        this.isEscape = isEscape;
    }

    public abstract IContentProposal[] computeProposals();

    public void addKeywordProposal(String proposal, int cursorPosition, int start, String prolog, String displayString, String additionalInfo) {
        if (!(prolog = prolog.toLowerCase()).isEmpty() && !proposal.startsWith(prolog) || this.getOffset() < start) {
            return;
        }
        if (!this.isEscape && prolog.endsWith("\\") && proposal.startsWith("\\")) {
            this.getProposals().add((IContentProposal)new ContentProposal(proposal, displayString, additionalInfo, cursorPosition));
            return;
        }
        int i = 1;
        while (i <= cursorPosition) {
            String prefix = proposal.substring(0, i);
            if (prolog.endsWith(prefix)) {
                String postfix = proposal.substring(cursorPosition);
                String epilog = this.getExpression().toLowerCase().substring(this.getOffset());
                if (epilog.startsWith(postfix)) {
                    this.getPriorityProposals().add((IContentProposal)new ContentProposal(proposal.substring(i, cursorPosition), displayString, additionalInfo, cursorPosition - i));
                } else {
                    this.getPriorityProposals().add((IContentProposal)new ContentProposal(proposal.substring(i), displayString, additionalInfo, cursorPosition - i));
                }
                return;
            }
            ++i;
        }
        this.getProposals().add((IContentProposal)new ContentProposal(proposal, displayString, additionalInfo, cursorPosition));
    }

    public void addTypeProposal(String proposal, int cursorPosition, String displayString, String additionalInfo) {
        String prolog = "";
        if (this.getExpression().contains(",")) {
            try {
                prolog = this.getExpression().substring(this.getExpression().lastIndexOf(",", this.getOffset()) + 1, this.getOffset()).trim().toLowerCase();
            }
            catch (Exception exception) {
                prolog = "";
            }
        } else if (this.getExpression().toLowerCase().trim().startsWith("show")) {
            prolog = this.getExpression().substring(this.getExpression().toLowerCase().indexOf("show") + 4, this.getOffset()).trim();
        } else if (this.getExpression().toLowerCase().trim().startsWith("hide")) {
            prolog = this.getExpression().substring(this.getExpression().toLowerCase().indexOf("hide") + 4, this.getOffset()).trim();
        } else if (this.getExpression().toLowerCase().trim().startsWith("color")) {
            prolog = this.getExpression().substring(this.getExpression().toLowerCase().indexOf("color") + 5, this.getOffset()).trim();
        } else {
            return;
        }
        if (!prolog.isEmpty() && !proposal.startsWith(prolog) || prolog.length() >= proposal.length()) {
            return;
        }
        if (!this.isEscape && prolog.endsWith("\\") && proposal.startsWith("\\")) {
            this.getProposals().add((IContentProposal)new ContentProposal(proposal, displayString, additionalInfo, cursorPosition));
            return;
        }
        int i = 1;
        while (i <= cursorPosition) {
            String prefix = proposal.substring(0, i);
            if (prolog.endsWith(prefix)) {
                String postfix = proposal.substring(cursorPosition);
                String epilog = this.getExpression().substring(this.getOffset());
                if (epilog.startsWith(postfix)) {
                    this.getPriorityProposals().add((IContentProposal)new ContentProposal(proposal.substring(i, cursorPosition), displayString, additionalInfo, cursorPosition - i));
                } else {
                    this.getPriorityProposals().add((IContentProposal)new ContentProposal(proposal.substring(i), displayString, additionalInfo, cursorPosition - i));
                }
                return;
            }
            ++i;
        }
        this.getProposals().add((IContentProposal)new ContentProposal(proposal, displayString, additionalInfo, cursorPosition));
    }

    public String getExpression() {
        return this.expression;
    }

    public int getOffset() {
        return this.offset;
    }

    public ArrayList<IContentProposal> getPriorityProposals() {
        return this.priorityProposals;
    }

    public ArrayList<IContentProposal> getProposals() {
        return this.proposals;
    }
}

