/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.diagrams.editor.actions;

import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import ro.amiq.dvt.diagrams.ch.editor.actions.DCHFiltersDialog;
import ro.amiq.dvt.diagrams.editor.DDiagramEditor;
import ro.amiq.dvt.diagrams.editor.utils.DEditorDialog;
import ro.amiq.dvt.diagrams.filters.DDiagramFiltersTextInput;
import ro.amiq.dvt.diagrams.filters.DiagramFiltersUtils;
import ro.amiq.dvt.diagrams.filters.IDiagramFiltersValidator;
import ro.amiq.dvt.ui.DVTImages;

public abstract class DFiltersDialogAbstract
extends DEditorDialog {
    public static final Pattern RGB_PATTERN_1 = Pattern.compile("#?[0-9a-fA-F]{6}");
    public static final Pattern RGB_PATTERN_2 = Pattern.compile("#?[0-9a-fA-F]{3}");
    public static final Pattern RGB_PATTERN_3 = Pattern.compile("(\\d){1,3},\\s*(\\d){1,3},\\s*(\\d){1,3}");
    public Combo filterSetCombo;
    public String currentFiltersName;
    public Composite newSetComposite;
    public GridData newSetGridData;
    public Text filterSetNameText;
    public Button OKButton;
    public Map<String, DiagramFiltersUtils.FilterBundle> filterSets;
    public StyledText filterText;
    private Button newSetButton;
    public Button duplicateSetButton;
    public Button deleteSetButton;
    public final String NONE = "None";
    private boolean duplicate;

    protected DFiltersDialogAbstract(DDiagramEditor diagramEditor, Point location) {
        super(diagramEditor, location, true);
    }

    public abstract void selectSet(String var1);

    public abstract void selectNone();

    public abstract void saveFilters(Map<String, DiagramFiltersUtils.FilterBundle> var1);

    public abstract void saveSet(String var1);

    public abstract void openEditor(boolean var1);

    public abstract void createAdditionalButtons(Composite var1);

    public abstract IContentProposalProvider getContentProposalProvider();

    public abstract String getTooltipText();

    public abstract String getLineRegex();

    public abstract List<String> getKindNames();

    @Override
    protected void createMainArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)composite);
        GridLayoutFactory.fillDefaults().numColumns(5).applyTo(composite);
        Label filtersetLabel = new Label(composite, 0);
        filtersetLabel.setText("Filters");
        GridDataFactory.fillDefaults().align(1, 0x1000000).grab(false, false).applyTo((Control)filtersetLabel);
        this.filterSetCombo = new Combo(composite, 12);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)this.filterSetCombo);
        this.filterSetCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                DFiltersDialogAbstract.this.saveSet(DFiltersDialogAbstract.this.filterText.getText());
                DFiltersDialogAbstract.this.selectSet(DFiltersDialogAbstract.this.filterSetCombo.getText());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.newSetButton = this.createButton(composite, 8, GridDataFactory.fillDefaults().align(0x1000000, 0x1000000).grab(false, false), DVTImages.imageCache.getImage(DVTImages.NEW_CONFIG), () -> this.newSet(new DiagramFiltersUtils.FilterBundle(), false));
        this.newSetButton.setToolTipText("New");
        this.duplicateSetButton = this.createButton(composite, 8, GridDataFactory.fillDefaults().align(0x1000000, 0x1000000).grab(false, false), DVTImages.imageCache.getImage(DVTImages.DUPLICATE_CONFIG), () -> this.duplicateSet());
        this.duplicateSetButton.setToolTipText("Duplicate");
        this.deleteSetButton = this.createButton(composite, 8, GridDataFactory.fillDefaults().align(0x1000000, 0x1000000).grab(false, false), DVTImages.imageCache.getImage(DVTImages.DELETE_CONFIG), () -> this.deleteSet());
        this.deleteSetButton.setToolTipText("Delete");
        this.createNewSetComposite(composite);
        IDiagramFiltersValidator validator = new IDiagramFiltersValidator(){

            @Override
            public void updateStatus(IStatus status) {
                DFiltersDialogAbstract.this.updateStatus(status);
            }

            @Override
            public String getTooltipText() {
                return DFiltersDialogAbstract.this.getTooltipText();
            }

            @Override
            public String getLineRegex() {
                return DFiltersDialogAbstract.this.getLineRegex();
            }

            @Override
            public List<String> getKindNames() {
                return DFiltersDialogAbstract.this.getKindNames();
            }

            @Override
            public IContentProposalProvider getContentProposalProvider() {
                return DFiltersDialogAbstract.this.getContentProposalProvider();
            }
        };
        this.filterText = new DDiagramFiltersTextInput((IDiagramFiltersValidator)validator, (Composite)composite, (int)2626).filterText;
        this.createAdditionalButtons(composite);
    }

    private void createNewSetComposite(Composite parent) {
        this.newSetComposite = new Composite(parent, 0);
        this.newSetGridData = GridDataFactory.fillDefaults().align(4, 4).grab(true, false).create();
        this.newSetGridData.horizontalSpan = 5;
        this.newSetComposite.setLayoutData((Object)this.newSetGridData);
        GridLayoutFactory.fillDefaults().numColumns(3).applyTo(this.newSetComposite);
        this.newSetGridData.exclude = true;
        this.newSetComposite.setVisible(false);
        Label filterSetNameLabel = new Label(this.newSetComposite, 0);
        filterSetNameLabel.setText("Name");
        GridDataFactory.fillDefaults().align(1, 0x1000000).grab(false, false).applyTo((Control)filterSetNameLabel);
        this.filterSetNameText = new Text(this.newSetComposite, 2052);
        GridDataFactory.fillDefaults().minSize(150, 1).align(4, 4).grab(true, true).applyTo((Control)this.filterSetNameText);
        Composite buttonsComposite = new Composite(this.newSetComposite, 0);
        GridData buttonsGridData = GridDataFactory.fillDefaults().align(4, 4).grab(true, false).create();
        buttonsComposite.setLayoutData((Object)buttonsGridData);
        GridLayoutFactory.fillDefaults().numColumns(2).equalWidth(true).applyTo(buttonsComposite);
        this.createButton(buttonsComposite, 8, "Cancel", () -> this.toggleNewSetComposite());
        this.OKButton = this.createButton(buttonsComposite, 8, "Ok", () -> this.addNewFilterSet());
        this.OKButton.setEnabled(false);
        this.filterSetNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (DFiltersDialogAbstract.this.filterSetNameText.getText().isEmpty() || DFiltersDialogAbstract.this.filterSets.keySet().contains(DFiltersDialogAbstract.this.filterSetNameText.getText().trim())) {
                    DFiltersDialogAbstract.this.OKButton.setEnabled(false);
                } else {
                    DFiltersDialogAbstract.this.OKButton.setEnabled(true);
                }
            }
        });
    }

    private void addNewFilterSet() {
        DiagramFiltersUtils.FilterBundle bundle;
        String newName = this.filterSetNameText.getText();
        DiagramFiltersUtils.FilterBundle filterBundle = bundle = this.duplicate ? this.filterSets.get(this.filterSetCombo.getText()) : new DiagramFiltersUtils.FilterBundle();
        bundle.reducePorts = this.duplicate ? bundle.reducePorts : this instanceof DCHFiltersDialog;
        this.filterSets.put(newName.trim(), bundle);
        this.filterText.setText(bundle.filterSetContents);
        this.filterSetCombo.add(newName);
        this.filterSetCombo.setText(newName);
        this.selectSet(this.filterSetCombo.getText());
        this.saveFilters(this.filterSets);
    }

    public void toggleNewSetComposite() {
        this.newSetGridData.exclude = !this.newSetGridData.exclude;
        this.newSetComposite.setVisible(!this.newSetGridData.exclude);
        this.newSetComposite.getParent().pack();
        if (this.newSetGridData.exclude) {
            return;
        }
        this.filterSetNameText.setText("new filters");
        this.filterSetNameText.selectAll();
        this.filterSetNameText.setFocus();
    }

    private void newSet(DiagramFiltersUtils.FilterBundle filterBundle, boolean duplicate) {
        if (filterBundle == null) {
            return;
        }
        this.duplicate = duplicate;
        this.toggleNewSetComposite();
        this.saveSet(this.filterSets.get(this.currentFiltersName) != null ? this.filterSets.get((Object)this.currentFiltersName).filterSetContents : "");
    }

    private void duplicateSet() {
        this.newSet(this.filterSets.get(this.filterSetCombo.getText()), true);
    }

    private void deleteSet() {
        String toRemove = this.filterSetCombo.getText();
        if ("None".equals(toRemove)) {
            return;
        }
        this.filterSets.remove(toRemove);
        this.filterSetCombo.remove(toRemove);
        this.selectSet("None");
        this.saveFilters(this.filterSets);
    }

    @Override
    protected void createBottomArea(Composite parent) {
        Composite buttonsComposite = this.createButtonsComposite(parent, 3);
        this.createButton(buttonsComposite, 8, "Cancel", () -> {
            boolean bl = this.close();
        });
        this.createButton(buttonsComposite, 8, "New", () -> this.openEditor(true));
        this.createButton(buttonsComposite, 8, "Apply", () -> this.openEditor(false));
    }
}

