/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.diagrams.editor.actions;

import org.eclipse.jface.action.Action;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import ro.amiq.dvt.diagrams.DDiagram;
import ro.amiq.dvt.diagrams.design.DRefactoringConnectDiagram;
import ro.amiq.dvt.diagrams.design.editor.DDesignEditorFactory;
import ro.amiq.dvt.diagrams.editor.DDiagramEditor;
import ro.amiq.dvt.diagrams.editor.DDiagramEditorInput;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.RefactoringConnectDiagramDVTNotification;
import ro.amiq.dvt.ui.refactor.designelement.DVTRefactorDesignElementUtils;
import ro.amiq.dvt.ui.views.ViewsUtils;
import ro.amiq.dvt.ui.views.refactoring.RefactoringConnectView;

public class DHideSideEffectsAction
extends Action {
    private DDiagramEditor diagramEditor;

    public DHideSideEffectsAction(DDiagramEditor diagramEditor) {
        super("Show Side Effects", 2);
        this.setImageDescriptor(DVTImages.REFACTORING_CONNECT_HIDE_SIDE_EFFECTS);
        this.diagramEditor = diagramEditor;
        this.setChecked(diagramEditor.hideSideEffects());
    }

    public void run() {
        RefactoringConnectView view = (RefactoringConnectView)ViewsUtils.getViewById("ro.amiq.dvt.ui.views.RefactoringConnectView", true);
        if (view == null) {
            return;
        }
        String[] rootNode = DVTRefactorDesignElementUtils.computeCommonAncestor(view.getSrcPath(), view.getDstPath());
        DDesignEditorFactory newRefactoringConnectDiagram = DDesignEditorFactory.getInstance().newRefactoringConnectDiagram(view.getProject(), view.getResult(), view.getInfo(), view.getSrcPath(), view.getDstPath(), view.getSrcPort(), view.getDstPort(), rootNode, this.diagramEditor.hideSideEffects());
        this.diagramEditor.setHideSideEffects(!this.diagramEditor.hideSideEffects());
        DDiagramEditor diagramEditor = view.getEditor();
        if (diagramEditor != null) {
            newRefactoringConnectDiagram.openReuseEditor(diagramEditor);
            return;
        }
        IEditorPart editor = newRefactoringConnectDiagram.openNewEditor();
        if (!(editor instanceof DDiagramEditor)) {
            return;
        }
        ((DDiagramEditor)editor).setPinned(false);
        IEditorInput ddEditorInput = ((DDiagramEditor)editor).getEditorInput();
        if (!(ddEditorInput instanceof DDiagramEditorInput)) {
            return;
        }
        DDiagram dDiagram = ((DDiagramEditorInput)ddEditorInput).getDiagram();
        if (!(dDiagram instanceof DRefactoringConnectDiagram)) {
            return;
        }
        view.setEditor((DDiagramEditor)editor);
        new RefactoringConnectDiagramDVTNotification((DDiagramEditor)editor, 256, "Refactoring connect preview", view).create();
    }
}

