/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.diagrams.editor.actions;

import org.apache.commons.lang.WordUtils;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.diagrams.editor.DDiagramEditor;
import ro.amiq.dvt.diagrams.editor.DDiagramEditorCommon;
import ro.amiq.dvt.diagrams.editor.utils.DEditorDialog;

public class DInspectLayoutDialog
extends DEditorDialog {
    private Button[] radios;

    public DInspectLayoutDialog(DDiagramEditor diagramEditor, Point location) {
        super(diagramEditor, location, false);
    }

    @Override
    protected void createMainArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)composite);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(composite);
        this.createRadioComposite(composite);
    }

    private void createRadioComposite(Composite paren) {
        Composite composite = new Composite(paren, 0);
        GridDataFactory.fillDefaults().align(1, 1).grab(false, false).applyTo((Control)composite);
        GridLayoutFactory.fillDefaults().applyTo(composite);
        DDiagramEditorCommon.InspectLayout[] inspectLayouts = DDiagramEditorCommon.InspectLayout.values();
        this.radios = new Button[inspectLayouts.length];
        int i = 0;
        while (i < inspectLayouts.length) {
            this.radios[i] = this.createButton(composite, 16, WordUtils.capitalizeFully((String)inspectLayouts[i].name()), () -> this.apply());
            ++i;
        }
    }

    private void apply() {
        DDiagramEditorCommon.InspectLayout[] inspectLayouts = DDiagramEditorCommon.InspectLayout.values();
        int i = 0;
        while (i < inspectLayouts.length) {
            if (this.radios[i].getSelection()) {
                DVTPlugin.getDefault().getPreferenceStore().setValue("inspect.diagram_editor_layout", inspectLayouts[i].toString());
                break;
            }
            ++i;
        }
        this.close();
    }

    @Override
    protected void setDefaults() {
        this.radios[this.getDiagramEditor().getInspectLayout().ordinal()].setSelection(true);
    }
}

