/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.diagrams.editor.actions;

import java.io.File;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Scale;
import org.eclipse.swt.widgets.Text;
import ro.amiq.dvt.diagrams.editor.DDiagramEditor;
import ro.amiq.dvt.diagrams.editor.utils.DEditorDialog;
import ro.amiq.dvt.draw.DExporter;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.dvt.utils.StoppableJob;

public class DSaveAsDialog
extends DEditorDialog {
    private static final long MAX_BITMAP_SIZE = 100000000L;
    private static final int MIN_MAX_ZOOM = 2;
    private static final int DEFAULT_START_ZOOM = 100;
    private static final int DEFAULT_MAX_ZOOM = 400;
    private static final IStatus LARGE_IMAGE_STATUS = new Status(4, "ro.amiq.dvt", "Image is to large, try saving it as SVG.");
    private static final IStatus EMPTY_FILE_STATUS = new Status(4, "ro.amiq.dvt", "Enter a file name.");
    private static final IStatus EMPTY_DIRECTORY_STATUS = new Status(4, "ro.amiq.dvt", "Enter a directory name.");
    private static final IStatus DIRECTORY_IS_FILE_STATUS = new Status(4, "ro.amiq.dvt", "A file with the same name as the directory exists.");
    private static final IStatus DIRECTORY_IS_NOT_WRITABLE_STATUS = new Status(4, "ro.amiq.dvt", "Directory is not writable.");
    private static final IStatus FILE_EXISTS_AS_RO_STATUS = new Status(4, "ro.amiq.dvt", "A file with the same name exists and it is read-only.");
    private static final IStatus FILE_EXISTS_STATUS = new Status(2, "ro.amiq.dvt", "A file with the same name exists, it will be overwritten.");
    private static final IStatus NON_EXISTING_DIRECTORY_STATUS = new Status(2, "ro.amiq.dvt", "Directory doesn't exist, it will be created.");
    private final String diagramName;
    private final Rectangle diagramBounds;
    private final int minZoom;
    private final int maxZoom;
    private final int startZoom;
    private Text fileText;
    private Combo extensionCombo;
    private Text directoryText;
    private Button browseButton;
    private Scale zoomScale;
    private Label zoomValueLabel;
    private Label sizeValueLabel;
    private Button saveButton;

    public DSaveAsDialog(DDiagramEditor diagramEditor, Point location) {
        super(diagramEditor, location, true);
        this.diagramName = this.niceString(diagramEditor.getInput().getDiagram().getName());
        this.diagramBounds = diagramEditor.getCanvas().getContent().getBounds();
        int computedMaxZoom = (int)Math.round(Math.floor(Math.min(400.0, 100.0 * Math.sqrt(1.0E8 / (double)((long)this.diagramBounds.width * (long)this.diagramBounds.height)))));
        this.maxZoom = computedMaxZoom < 2 ? 1 : computedMaxZoom;
        this.minZoom = computedMaxZoom < 2 ? 0 : 1;
        this.startZoom = Math.min(100, this.maxZoom);
    }

    @Override
    protected void createMainArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)composite);
        GridLayoutFactory.fillDefaults().numColumns(3).applyTo(composite);
        Label fileLabel = new Label(composite, 0);
        GridDataFactory.fillDefaults().align(4, 0x1000000).applyTo((Control)fileLabel);
        fileLabel.setText("Name:");
        this.fileText = new Text(composite, 2052);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).minSize(300, -1).applyTo((Control)this.fileText);
        this.extensionCombo = new Combo(composite, 12);
        GridDataFactory.fillDefaults().align(4, 0x1000000).applyTo((Control)this.extensionCombo);
        Label directoryLabel = new Label(composite, 0);
        GridDataFactory.fillDefaults().align(4, 0x1000000).applyTo((Control)directoryLabel);
        directoryLabel.setText("Directory:");
        this.directoryText = new Text(composite, 2052);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).minSize(300, -1).applyTo((Control)this.directoryText);
        this.browseButton = new Button(composite, 8);
        GridDataFactory.fillDefaults().align(4, 0x1000000).applyTo((Control)this.browseButton);
        this.browseButton.setText("Browse...");
        Label zoomLabel = new Label(composite, 0);
        GridDataFactory.fillDefaults().align(4, 0x1000000).applyTo((Control)zoomLabel);
        zoomLabel.setText("Zoom:");
        this.zoomScale = new Scale(composite, 2304);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).minSize(300, -1).applyTo((Control)this.zoomScale);
        this.zoomScale.setIncrement(1);
        this.zoomScale.setPageIncrement(1);
        this.zoomValueLabel = new Label(composite, 0);
        GridDataFactory.fillDefaults().align(4, 0x1000000).applyTo((Control)this.zoomValueLabel);
        this.zoomValueLabel.setText("");
        Label sizeLabel = new Label(composite, 0);
        GridDataFactory.fillDefaults().align(4, 1).applyTo((Control)sizeLabel);
        sizeLabel.setText("Size:");
        this.sizeValueLabel = new Label(composite, 0);
        GridDataFactory.fillDefaults().align(4, 0x1000000).span(2, 1).applyTo((Control)this.sizeValueLabel);
        this.sizeValueLabel.setText("");
    }

    @Override
    protected void createBottomArea(Composite parent) {
        Composite buttonsComposite = this.createButtonsComposite(parent, 2);
        this.createButton(buttonsComposite, 8, "Cancel", () -> {
            boolean bl = this.close();
        });
        this.saveButton = this.createButton(buttonsComposite, 8, "Save", () -> this.save());
    }

    @Override
    protected void updateButtonsForStatus(IStatus status) {
        if (this.saveButton != null && !this.saveButton.isDisposed()) {
            this.saveButton.setEnabled(!status.matches(4));
        }
    }

    @Override
    protected void setDefaults() {
        this.fileText.setText(this.diagramName);
        DExporter[] exporters = DExporter.getAvailableExporters();
        this.extensionCombo.setData((Object)exporters);
        DExporter defaultExporter = this.isLargeImage() ? DExporter.SVG : DExporter.PNG;
        int i = 0;
        while (i < exporters.length) {
            this.extensionCombo.add(exporters[i].getExtension());
            if (exporters[i] == defaultExporter) {
                this.extensionCombo.select(i);
            }
            ++i;
        }
        this.directoryText.setText(DVTFileUtils.getInstance().getLastDirectory());
        this.zoomScale.setMinimum(this.minZoom);
        this.zoomScale.setMaximum(this.maxZoom);
        this.zoomScale.setSelection(this.startZoom);
        this.updateZoomValueLabel();
        this.updateSizeValueLabel();
        this.enableZoomWidgets();
        this.validate();
    }

    @Override
    protected void addListeners() {
        ModifyListener modifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DSaveAsDialog.this.validate();
            }
        };
        this.fileText.addModifyListener(modifyListener);
        this.directoryText.addModifyListener(modifyListener);
        this.extensionCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DSaveAsDialog.this.updateSizeValueLabel();
                DSaveAsDialog.this.enableZoomWidgets();
                DSaveAsDialog.this.validate();
            }
        });
        this.browseButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                this.widgetDefaultSelected(e);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                DSaveAsDialog.this.openDirectoryBrowser();
                DSaveAsDialog.this.validate();
            }
        });
        this.zoomScale.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                this.widgetDefaultSelected(e);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                DSaveAsDialog.this.updateSizeValueLabel();
                DSaveAsDialog.this.updateZoomValueLabel();
            }
        });
    }

    private void openDirectoryBrowser() {
        DirectoryDialog dialog = new DirectoryDialog(this.getShell());
        dialog.setFilterPath(DVTFileUtils.getInstance().getLastDirectory());
        this.disableClose(true);
        String directoryName = dialog.open();
        this.disableClose(false);
        if (directoryName == null) {
            return;
        }
        this.directoryText.setText(directoryName);
        DVTFileUtils.getInstance().setLastDirectory(directoryName);
    }

    private void updateZoomValueLabel() {
        int zoom = this.zoomScale.getSelection();
        this.zoomValueLabel.setText(String.valueOf(Integer.toString(zoom)) + "%");
        this.zoomValueLabel.pack();
    }

    private void updateSizeValueLabel() {
        StringBuilder sizeText = new StringBuilder();
        if (this.getSelectedExporter().isBitmap()) {
            int zoom = this.zoomScale.getSelection();
            sizeText.append(Long.toString((long)this.diagramBounds.width * (long)zoom / 100L)).append(" x ").append(Long.toString((long)this.diagramBounds.height * (long)zoom / 100L)).append(" px (scaled)").append("\n").append(Integer.toString(this.diagramBounds.width)).append(" x ").append(Integer.toString(this.diagramBounds.height)).append(" px (original)");
        } else {
            sizeText.append("scalable\n");
        }
        this.sizeValueLabel.setText(sizeText.toString());
        this.sizeValueLabel.pack();
    }

    private void enableZoomWidgets() {
        boolean enabled = this.getSelectedExporter().isBitmap() && !this.isLargeImage();
        this.zoomScale.setEnabled(enabled);
        this.zoomValueLabel.setEnabled(enabled);
    }

    private DExporter getSelectedExporter() {
        return ((DExporter[])this.extensionCombo.getData())[this.extensionCombo.getSelectionIndex()];
    }

    private boolean isLargeImage() {
        return this.maxZoom < 2;
    }

    private void validate() {
        if (this.getSelectedExporter().isBitmap() && this.isLargeImage()) {
            this.updateStatus(LARGE_IMAGE_STATUS);
            return;
        }
        String fileName = this.fileText.getText();
        if (fileName == null || fileName.isEmpty()) {
            this.updateStatus(EMPTY_FILE_STATUS);
            return;
        }
        String directoryName = this.directoryText.getText();
        if (directoryName == null || directoryName.isEmpty()) {
            this.updateStatus(EMPTY_DIRECTORY_STATUS);
            return;
        }
        File directory = new File(directoryName);
        if (!directory.exists()) {
            this.updateStatus(NON_EXISTING_DIRECTORY_STATUS);
            return;
        }
        if (!directory.isDirectory()) {
            this.updateStatus(DIRECTORY_IS_FILE_STATUS);
            return;
        }
        if (!directory.canWrite() || !directory.canExecute()) {
            this.updateStatus(DIRECTORY_IS_NOT_WRITABLE_STATUS);
            return;
        }
        String extension = this.extensionCombo.getItem(this.extensionCombo.getSelectionIndex());
        File file = new File(directory, String.valueOf(fileName) + extension);
        if (file.exists()) {
            if (!file.canWrite()) {
                this.updateStatus(FILE_EXISTS_AS_RO_STATUS);
                return;
            }
            this.updateStatus(FILE_EXISTS_STATUS);
            return;
        }
        this.updateStatus(Status.OK_STATUS);
    }

    private String niceString(String string) {
        if (string == null) {
            return "untitled";
        }
        StringBuilder sb = new StringBuilder();
        int pc = 95;
        int cc = 95;
        int i = 0;
        while (i < string.length()) {
            cc = string.charAt(i);
            if (Character.isLetterOrDigit((char)cc)) {
                sb.append(Character.toLowerCase((char)cc));
                pc = cc;
            } else if (pc != 95) {
                sb.append('_');
                pc = 95;
            }
            ++i;
        }
        return sb.toString();
    }

    private void save() {
        final String fileName = this.fileText.getText();
        final DExporter exporter = this.getSelectedExporter();
        final String directoryName = this.directoryText.getText();
        final double expScale = (double)this.zoomScale.getSelection() / 100.0;
        this.close();
        StoppableJob job = new StoppableJob("Saving Diagram"){

            @Override
            protected IStatus stoppableRun(IProgressMonitor monitor) {
                AtomicReference exceptionRef = new AtomicReference();
                try {
                    monitor.beginTask(fileName, -1);
                    Display.getDefault().syncExec(() -> {
                        try {
                            exporter.export(new File(directoryName, String.valueOf(fileName) + exporter.getExtension()), DSaveAsDialog.this.getDiagramEditor().getCanvas().getContent(), expScale, null);
                        }
                        catch (Exception e) {
                            DVTLogger.INSTANCE.logError((Throwable)e);
                            exceptionRef.set(e);
                        }
                    });
                    if (exceptionRef.get() != null) {
                        Status status = new Status(4, "ro.amiq.dvt", "Error while saving diagram.", (Throwable)exceptionRef.get());
                        return status;
                    }
                }
                finally {
                    monitor.done();
                }
                return Status.OK_STATUS;
            }
        };
        job.setPriority(30);
        job.setUser(true);
        job.schedule();
    }
}

