/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.diagrams.editor.actions;

import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import ro.amiq.dvt.diagrams.editor.DDiagramEditor;
import ro.amiq.dvt.diagrams.editor.DMessages;
import ro.amiq.dvt.diagrams.editor.utils.DEditorDialog;
import ro.amiq.dvt.diagrams.uml.utils.FilteredList;
import ro.amiq.dvt.diagrams.uml.utils.MouseEnhancedFilteredList;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.utils.DVTColorUtil;

public abstract class DSelectPanelAbstract
extends DEditorDialog {
    protected MouseEnhancedFilteredList leftPanel;
    protected MouseEnhancedFilteredList rightPanel;
    private LabelProvider leftPanelProvider;
    private LabelProvider rightPanelProvider;
    private Button addButton;
    private Button removeButton;
    private Button addAllButton;
    private Button removeAllButton;
    private Text rightPanelFilterTextBox;
    private Text leftPanelFilterTextBox;
    protected Composite fPanelContainer;
    protected static final Object[] NO_DATA = new Object[]{"No data."};

    public DSelectPanelAbstract(DDiagramEditor diagramEditor, Point location, boolean hasStatusLine) {
        super(diagramEditor, location, hasStatusLine);
    }

    @Override
    public void createMainArea(Composite parent) {
        GridLayout gl = new GridLayout(1, false);
        gl.marginWidth = 0;
        parent.setLayout((Layout)gl);
        this.fPanelContainer = new Composite(parent, 0);
        this.fPanelContainer.setLayoutData((Object)new GridData(4, 4, true, true));
        this.fPanelContainer.setLayout((Layout)new GridLayout(3, false));
        Composite leftContainer = new Composite(this.fPanelContainer, 0);
        leftContainer.setLayoutData((Object)new GridData(4, 4, true, true));
        gl = new GridLayout();
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        leftContainer.setLayout((Layout)gl);
        this.leftPanelFilterTextBox = new Text(leftContainer, 2048);
        this.leftPanelFilterTextBox.setLayoutData((Object)new GridData(4, 128, true, false));
        this.leftPanelFilterTextBox.setText("");
        this.leftPanel = this.createSpecificPanelProviders(leftContainer, true);
        GridData gridData = new GridData(4, 4, true, true);
        gridData.widthHint = 300;
        this.leftPanel.setLayoutData(gridData);
        this.leftPanel.addMouseListener(this.getMouseListener(this.leftPanel));
        this.leftPanel.addSelectionListener(this.getSelectionListener(this.leftPanel));
        this.leftPanelFilterTextBox.addModifyListener(this.getModifyListener(this.leftPanelFilterTextBox, this.leftPanel));
        Composite buttonContainer = new Composite(this.fPanelContainer, 0);
        buttonContainer.setLayoutData((Object)new GridData(0x1000000, 128, false, false));
        RowLayout rl = new RowLayout(512);
        rl.center = true;
        buttonContainer.setLayout((Layout)rl);
        this.createFiltersLabel(buttonContainer);
        Composite separator = new Composite(buttonContainer, 0);
        separator.setLayoutData((Object)new RowData(31, 100));
        this.addButton = new Button(buttonContainer, 8);
        this.addButton.setLayoutData((Object)new RowData(31, 31));
        this.addButton.setImage(DVTImages.imageCache.getImage(DVTImages.ARROW_LEFT_RIGHT_IMG));
        this.addButton.setToolTipText(DMessages.SelectPanel_Add_Button_TT);
        this.addButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                Object[] selection = DSelectPanelAbstract.this.leftPanel.getSelection();
                DSelectPanelAbstract.this.addItems(selection);
                DSelectPanelAbstract.this.leftPanel.setSelection(new Object[0]);
            }
        });
        this.removeButton = new Button(buttonContainer, 8);
        this.removeButton.setLayoutData((Object)new RowData(31, 31));
        this.removeButton.setImage(DVTImages.imageCache.getImage(DVTImages.ARROW_RIGHT_LEFT_IMG));
        this.removeButton.setToolTipText(DMessages.SelectPanel_Remove_Button_TT);
        this.removeButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                Object[] selection = DSelectPanelAbstract.this.rightPanel.getSelection();
                DSelectPanelAbstract.this.removeItems(selection);
                DSelectPanelAbstract.this.rightPanel.setSelection(new Object[0]);
            }
        });
        Composite separator2 = new Composite(buttonContainer, 0);
        separator2.setLayoutData((Object)new RowData(31, 100));
        this.addAllButton = new Button(buttonContainer, 8);
        this.addAllButton.setLayoutData((Object)new RowData(31, 31));
        this.addAllButton.setImage(DVTImages.imageCache.getImage(DVTImages.DARROW_LEFT_RIGHT_IMG));
        this.addAllButton.setToolTipText(DMessages.SelectPanel_Add_All_Button_TT);
        this.addAllButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                DSelectPanelAbstract.this.addAll();
            }
        });
        this.removeAllButton = new Button(buttonContainer, 8);
        this.removeAllButton.setLayoutData((Object)new RowData(31, 31));
        this.removeAllButton.setImage(DVTImages.imageCache.getImage(DVTImages.DARROW_RIGHT_LEFT_IMG));
        this.removeAllButton.setToolTipText(DMessages.SelectPanel_Remove_All_Button_TT);
        this.removeAllButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                DSelectPanelAbstract.this.removeAll();
            }
        });
        Composite rightContainer = new Composite(this.fPanelContainer, 0);
        rightContainer.setLayoutData((Object)new GridData(4, 4, true, true));
        gl = new GridLayout();
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        rightContainer.setLayout((Layout)gl);
        this.rightPanelFilterTextBox = new Text(rightContainer, 2048);
        this.rightPanelFilterTextBox.setLayoutData((Object)new GridData(4, 128, true, false));
        this.rightPanelFilterTextBox.setText("");
        this.rightPanel = this.createSpecificPanelProviders(rightContainer, false);
        gridData = new GridData(4, 4, true, true);
        gridData.widthHint = 300;
        this.rightPanel.setLayoutData(gridData);
        this.rightPanel.addMouseListener(this.getMouseListener(this.rightPanel));
        this.rightPanel.addSelectionListener(this.getSelectionListener(this.rightPanel));
        this.rightPanelFilterTextBox.addModifyListener(this.getModifyListener(this.rightPanelFilterTextBox, this.rightPanel));
        this.addStatusBar();
        this.addButtons(this.fPanelContainer);
        this.setInput();
    }

    public abstract MouseEnhancedFilteredList createSpecificPanelProviders(Composite var1, boolean var2);

    public abstract void addStatusBar();

    public abstract void addItems(Object[] var1);

    public abstract void removeItems(Object[] var1);

    public abstract void addAll();

    public abstract void removeAll();

    public abstract void setInput();

    public abstract MouseListener getMouseListener(FilteredList var1);

    public abstract SelectionListener getSelectionListener(FilteredList var1);

    public abstract void addButtons(Composite var1);

    public abstract void openEditor(boolean var1);

    public LabelProvider getRightPanelProvider() {
        return this.rightPanelProvider;
    }

    public void setRightPanelProvider(LabelProvider rightPanelProvider) {
        this.rightPanelProvider = rightPanelProvider;
    }

    public LabelProvider getLeftPanelProvider() {
        return this.leftPanelProvider;
    }

    public void setLeftPanelProvider(LabelProvider leftPanelProvider) {
        this.leftPanelProvider = leftPanelProvider;
    }

    public void createFiltersLabel(Composite buttonContainer) {
    }

    @Override
    protected void createBottomArea(Composite parent) {
        Composite buttonsComposite = this.createButtonsComposite(parent, 3);
        this.createButton(buttonsComposite, 8, "Cancel", () -> {
            boolean bl = this.close();
        });
        this.createButton(buttonsComposite, 8, "New", () -> this.openEditor(true));
        this.createButton(buttonsComposite, 8, "Apply", () -> this.openEditor(false));
    }

    private ModifyListener getModifyListener(final Text filterTextBox, final FilteredList panel) {
        return new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String text = ((Text)e.widget).getText();
                panel.setFilter(text);
                DVTColorUtil.INSTANCE.setForeground((Control)filterTextBox, JFaceResources.getColorRegistry().get("ro.amiq.dvt.ui.filter.foregroundColor"));
                if (filterTextBox.getText().length() == 0) {
                    DVTColorUtil.INSTANCE.setBackground((Control)filterTextBox, JFaceResources.getColorRegistry().get("ro.amiq.dvt.ui.filter.emptyBackgroundColor"));
                } else {
                    DVTColorUtil.INSTANCE.setBackground((Control)filterTextBox, JFaceResources.getColorRegistry().get("ro.amiq.dvt.ui.filter.backgroundColor"));
                }
            }
        };
    }
}

