/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.diagrams.editor.actions;

import org.apache.commons.lang.WordUtils;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.diagrams.editor.DDiagramEditor;
import ro.amiq.dvt.diagrams.editor.utils.DEditorDialog;
import ro.amiq.dvt.diagrams.fsm.editor.actions.menu.DFSMActionMessages;
import ro.amiq.dvt.diagrams.tables.TableExportFormat;

public class DTransitionTableLayoutDialog
extends DEditorDialog {
    private static final int HIDE = 0;
    private static final int SHOW = 1;
    private Button[] radios;
    private Combo exportTableFormat;

    public DTransitionTableLayoutDialog(DDiagramEditor diagramEditor, Point location) {
        super(diagramEditor, location, false);
    }

    @Override
    protected void createMainArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)composite);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(composite);
        this.createRadioComposite(composite);
        Label separator = new Label(parent, 258);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).span(2, 1).applyTo((Control)separator);
        this.createExportTableFormatComposite(parent);
    }

    private void createExportTableFormatComposite(Composite parent) {
        Composite rowsComposite = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).equalWidth(true).applyTo(rowsComposite);
        Label label = new Label(rowsComposite, 0);
        GridDataFactory.fillDefaults().align(1, 0x1000000).grab(false, false).applyTo((Control)label);
        label.setText(DFSMActionMessages.exportTableFormat);
        TableExportFormat[] values = TableExportFormat.values();
        IPreferenceStore store = DVTPlugin.getDefault().getPreferenceStore();
        TableExportFormat currentValue = TableExportFormat.valueOf(store.getString("designdiagrams.fsm_export_table_format"));
        this.exportTableFormat = new Combo(rowsComposite, 2056);
        this.exportTableFormat.setData((Object)values);
        this.exportTableFormat.setEnabled(!DVTPlugin.getDefault().getPreferenceStore().getBoolean("designdiagrams.fsm_transition_table_disabled"));
        int i = 0;
        while (i < values.length) {
            TableExportFormat value = values[i];
            this.exportTableFormat.add(((Object)((Object)value)).toString());
            if (value == currentValue) {
                this.exportTableFormat.select(i);
            }
            ++i;
        }
        this.exportTableFormat.addModifyListener(e -> {
            TableExportFormat newValue = values[this.exportTableFormat.getSelectionIndex()];
            store.setValue("designdiagrams.fsm_export_table_format", newValue.toString());
        });
    }

    private void createRadioComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridDataFactory.fillDefaults().align(1, 1).grab(false, false).applyTo((Control)composite);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(composite);
        this.radios = new Button[2];
        this.radios[0] = this.createButton(composite, 16, WordUtils.capitalizeFully((String)"Hide"), () -> this.apply());
        this.radios[1] = this.createButton(composite, 16, WordUtils.capitalizeFully((String)"Show"), () -> this.apply());
    }

    private void apply() {
        if (this.radios[1].getSelection()) {
            DVTPlugin.getDefault().getPreferenceStore().setValue("designdiagrams.fsm_transition_table_disabled", false);
        } else {
            DVTPlugin.getDefault().getPreferenceStore().setValue("designdiagrams.fsm_transition_table_disabled", true);
        }
        this.exportTableFormat.setEnabled(DVTPlugin.getDefault().getPreferenceStore().getBoolean("designdiagrams.fsm_transition_table_disabled"));
        this.close();
    }

    @Override
    protected void setDefaults() {
        int index = this.getDiagramEditor().getTransitionTable().isHidden() ? 0 : 1;
        this.radios[index].setSelection(true);
    }
}

