/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.diagrams.editor.utils;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.LegacyActionTools;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.PopupDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.Geometry;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.dialogs.PreferencesUtil;
import ro.amiq.dvt.diagrams.editor.DDiagramEditor;
import ro.amiq.dvt.diagrams.editor.utils.DEditorDialogFactory;
import ro.amiq.dvt.draw.DCanvas;
import ro.amiq.dvt.startup.core.DVTUiUtils;
import ro.amiq.dvt.ui.utils.DVTColorUtil;

public abstract class DEditorDialog
extends PopupDialog {
    private static final String SELECTION_RUNNABLE = "selection.runnable";
    private static final SelectionListener SELECTION_LISTENER = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            DEditorDialog.runWidgetSelectedAction(e.widget);
        }
    };
    private final DDiagramEditor diagramEditor;
    private final Point location;
    private Composite contentsComposite;
    private boolean hasStatusLine;
    private IStatus lastStatus;
    private MessageLine statusLine;
    private volatile boolean disableClose;

    public DEditorDialog(DDiagramEditor diagramEditor, Point location, boolean hasStatusLine) {
        super(diagramEditor.getCanvas().getShell(), 0, true, false, false, false, false, null, null);
        this.diagramEditor = diagramEditor;
        this.location = location;
        this.hasStatusLine = hasStatusLine;
        if (this.hasStatusLine) {
            this.lastStatus = new Status(0, "org.eclipse.jface", 0, "", null);
        }
    }

    protected final Control createContents(Composite parent) {
        this.contentsComposite = new Composite(parent, 0);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.contentsComposite);
        GridLayoutFactory.fillDefaults().margins(5, 5).spacing(5, 5).applyTo(this.contentsComposite);
        this.createMainArea(this.contentsComposite);
        if (this.hasStatusLine) {
            this.createStatusLineArea(this.contentsComposite);
        }
        this.createBottomArea(this.contentsComposite);
        this.setDefaults();
        this.addListeners();
        Dialog.applyDialogFont((Control)this.contentsComposite);
        return this.contentsComposite;
    }

    private void createStatusLineArea(Composite parent) {
        this.statusLine = new MessageLine(parent);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.statusLine);
        this.statusLine.setErrorStatus(this.lastStatus);
    }

    protected void createMainArea(Composite parent) {
    }

    protected void createBottomArea(Composite parent) {
    }

    protected Composite createBottomComposite(Composite parent, int columns) {
        Composite composite = new Composite(parent, 0);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)composite);
        GridLayoutFactory.fillDefaults().extendedMargins(0, 0, 10, 0).numColumns(columns).equalWidth(false).applyTo(composite);
        return composite;
    }

    protected Composite createButtonsComposite(Composite parent, int columns) {
        Composite composite = new Composite(parent, 0);
        GridDataFactory.fillDefaults().align(0x1000008, 0x1000000).grab(false, false).applyTo((Control)composite);
        GridLayoutFactory.fillDefaults().numColumns(columns).equalWidth(true).applyTo(composite);
        return composite;
    }

    protected void addListeners() {
    }

    protected void setDefaults() {
    }

    protected void createPreferencesLink(final String preferencesDiagramPageID, Composite composite) {
        Link link = new Link(composite, 0);
        GridDataFactory.fillDefaults().align(1, 0x1000000).grab(true, false).applyTo((Control)link);
        link.setText("<a href=\"link\">Preferences...</a>");
        DVTUiUtils.setPlatformLinkColor((Link)link);
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DEditorDialog.this.close();
                Display.getDefault().asyncExec(() -> {
                    int n = PreferencesUtil.createPreferenceDialogOn((Shell)DEditorDialog.this.getShell(), (String)preferencesDiagramPageID, null, null).open();
                });
            }
        });
    }

    protected Button createButton(Composite composite, int style, String text, Runnable action) {
        return this.createButton(composite, style, GridDataFactory.fillDefaults().grab(true, true), text, action);
    }

    protected Button createButton(Composite composite, int style, GridDataFactory gridDataFactory, String text, Runnable action) {
        return this.createButton(composite, style, gridDataFactory, text, null, action);
    }

    protected Button createButton(Composite composite, int style, GridDataFactory gridDataFactory, Image image, Runnable action) {
        return this.createButton(composite, style, gridDataFactory, null, image, action);
    }

    protected Button createButton(Composite composite, int style, GridDataFactory gridDataFactory, String text, Image image, Runnable action) {
        Button button = new Button(composite, style);
        if (text != null) {
            button.setText(text);
        }
        if (image != null) {
            button.setImage(image);
        }
        if (gridDataFactory != null) {
            gridDataFactory.applyTo((Control)button);
        }
        if (action != null) {
            button.setData(SELECTION_RUNNABLE, (Object)action);
            button.addSelectionListener(SELECTION_LISTENER);
        }
        return button;
    }

    protected void createSeparator(Composite parent, int style) {
        Label separator = new Label(parent, 2 | style);
        boolean horizontalGrab = style == 256;
        int horizontalAlign = horizontalGrab ? 4 : 0x1000000;
        boolean verticalGrab = !horizontalGrab;
        int verticalAlign = verticalGrab ? 4 : 0x1000000;
        GridDataFactory.fillDefaults().align(horizontalAlign, verticalAlign).grab(horizontalGrab, verticalGrab).applyTo((Control)separator);
    }

    protected void updateStatus(IStatus status) {
        if (!this.hasStatusLine) {
            return;
        }
        this.lastStatus = status;
        if (this.statusLine != null && !this.statusLine.isDisposed()) {
            this.updateButtonsForStatus(status);
            this.statusLine.setErrorStatus(status);
        }
    }

    protected void updateButtonsForStatus(IStatus status) {
    }

    protected void disableClose(boolean disable) {
        this.disableClose = disable;
    }

    protected Control getFocusControl() {
        return this.contentsComposite;
    }

    public boolean close() {
        if (this.disableClose) {
            return false;
        }
        if (DEditorDialogFactory.onScreenDialog == this) {
            DEditorDialogFactory.onScreenDialog = null;
        }
        return super.close();
    }

    protected DDiagramEditor getDiagramEditor() {
        return this.diagramEditor;
    }

    public Point getLocation() {
        return this.location;
    }

    protected Point getInitialLocation(Point initialSize) {
        if (this.location == null) {
            DCanvas canvas = this.diagramEditor.getCanvas();
            Point size = canvas.getSize();
            Point location = canvas.toDisplay(0, 0);
            Point centerPoint = Geometry.centerPoint((Rectangle)new Rectangle(location.x, location.y, size.x, size.y));
            return new Point(centerPoint.x - initialSize.x / 2, centerPoint.y - initialSize.y * 2 / 3);
        }
        return this.location;
    }

    protected static void runWidgetSelectedAction(Widget widget) {
        Object action = widget.getData(SELECTION_RUNNABLE);
        if (action == null) {
            return;
        }
        ((Runnable)action).run();
    }

    private static class MessageLine
    extends CLabel {
        public MessageLine(Composite parent) {
            super(parent, 16384);
        }

        private Image findImage(IStatus status) {
            if (status.isOK()) {
                return null;
            }
            if (status.matches(4)) {
                return JFaceResources.getImage((String)"dialog_message_error_image");
            }
            if (status.matches(2)) {
                return JFaceResources.getImage((String)"dialog_messasge_warning_image");
            }
            if (status.matches(1)) {
                return JFaceResources.getImage((String)"dialog_messasge_info_image");
            }
            return null;
        }

        public void setErrorStatus(IStatus status) {
            String message;
            if (status != null && !status.isOK() && (message = status.getMessage()) != null && message.length() > 0) {
                this.setText(LegacyActionTools.escapeMnemonics((String)message));
                this.setImage(this.findImage(status));
                DVTColorUtil.INSTANCE.setBackground((Control)this, DVTColorUtil.INSTANCE.getBackground((Control)this.getParent()), true);
                return;
            }
            DVTColorUtil.INSTANCE.setBackground((Control)this, DVTColorUtil.INSTANCE.getBackground((Control)this.getParent()), true);
            this.setText("");
            this.setImage(null);
        }
    }
}

