/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.diagrams.filters;

import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.IControlContentAdapter2;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.fieldassist.ContentAssistCommandAdapter;
import org.eclipse.ui.progress.UIJob;
import ro.amiq.dvt.diagrams.design.editor.actions.DDesignFiltersContentAssistProvider;
import ro.amiq.dvt.diagrams.editor.actions.DFiltersDialogAbstract;
import ro.amiq.dvt.diagrams.filters.IDiagramFiltersValidator;
import ro.amiq.dvt.draw.utils.ColorFactory;
import ro.amiq.dvt.draw.utils.ColorMap;
import ro.amiq.dvt.utils.DVTStringUtil;

public class DDiagramFiltersTextInput {
    public StyledText filterText;
    private final IDiagramFiltersValidator validator;
    private static final RGB ERROR_COLOR = ColorFactory.getInstance().getRGB(255, 130, 130);
    private static final String R_PATTERN = "\\R";
    private final DelayedUIJob filterTextValidateJob = new DelayedUIJob(this::validateFilterText);

    public DDiagramFiltersTextInput(IDiagramFiltersValidator validator, Composite parent, int style) {
        this.validator = validator;
        this.filterText = new StyledText(parent, style);
        FontMetrics fontMetrics = this.getFontMetrics(parent);
        int width = Dialog.convertWidthInCharsToPixels((FontMetrics)fontMetrics, (int)60);
        int height = Dialog.convertHeightInCharsToPixels((FontMetrics)fontMetrics, (int)10);
        GridDataFactory.fillDefaults().hint(width, height).minSize(width, height).span(5, 1).align(4, 4).grab(true, true).applyTo((Control)this.filterText);
        this.filterText.setToolTipText(validator.getTooltipText());
        this.filterText.addCaretListener(event -> this.scheduleValidateFilterText());
        this.filterText.addModifyListener(event -> this.scheduleValidateFilterText());
        IContentProposalProvider provider = this.getContentProposalProvider();
        if (provider != null) {
            StyledTextContentAdapter contentAdapter = new StyledTextContentAdapter();
            new ContentAssistCommandAdapter((Control)this.filterText, (IControlContentAdapter)contentAdapter, provider, "org.eclipse.ui.edit.text.contentAssist.proposals", new char[0], true);
        }
    }

    public void validateFilterText() {
        if (this.filterText == null || this.filterText.isDisposed()) {
            return;
        }
        String text = this.filterText.getText();
        if (text == null) {
            return;
        }
        int currentLine = this.filterText.getLineAtOffset(this.filterText.getCaretOffset());
        String[] splitText = text.split(R_PATTERN, -1);
        String errorMessage = null;
        int i = 0;
        while (i < splitText.length) {
            String message = this.validateLine(splitText[i]);
            if (message == null) {
                this.filterText.setLineBackground(i, 1, null);
            } else {
                this.filterText.setLineBackground(i, 1, ColorFactory.getInstance().getColor(ERROR_COLOR));
                if (currentLine == i) {
                    errorMessage = message;
                }
            }
            ++i;
        }
        if (errorMessage != null) {
            this.validator.updateStatus((IStatus)new Status(4, "ro.amiq.dvt", errorMessage));
        } else {
            this.validator.updateStatus(Status.OK_STATUS);
        }
    }

    public String validateLine(String line) {
        if (line == null) {
            return null;
        }
        if ((line = line.trim()).isEmpty() || line.startsWith("#")) {
            return null;
        }
        if (!(line.startsWith("show") || line.startsWith("hide") || line.startsWith("color"))) {
            return "Filter must begin with either \"show\", \"hide\", or \"color\"!";
        }
        String expression = "";
        String elementKinds = "";
        boolean missingMatching = false;
        if ((line = line.toLowerCase()).matches(this.validator.getLineRegex())) {
            return "Whitespace not allowed in filter expression: " + line.substring(line.indexOf("matching") + 8).trim() + "!";
        }
        if (line.startsWith("show")) {
            if (line.toLowerCase().contains("matching")) {
                elementKinds = line.substring(4, line.indexOf("matching"));
                expression = line.substring(line.indexOf("matching") + 8).trim();
            } else {
                elementKinds = line.substring(4);
                missingMatching = true;
            }
        } else if (line.startsWith("hide")) {
            if (line.toLowerCase().contains("matching")) {
                elementKinds = line.substring(4, line.indexOf("matching"));
                expression = line.substring(line.indexOf("matching") + 8).trim();
            } else {
                elementKinds = line.substring(4);
                missingMatching = true;
            }
        } else if (line.startsWith("color")) {
            if (line.toLowerCase().contains("matching")) {
                elementKinds = line.substring(5, line.indexOf("matching"));
                expression = line.substring(line.indexOf("matching") + 8).trim();
                if (line.contains("using")) {
                    expression = line.substring(line.indexOf("matching") + 8, line.indexOf("using")).trim();
                    String hexRGB = line.substring(line.indexOf("using") + 5).trim();
                    if (!(DVTStringUtil.matches(DFiltersDialogAbstract.RGB_PATTERN_1, hexRGB) || DVTStringUtil.matches(DFiltersDialogAbstract.RGB_PATTERN_2, hexRGB) || DVTStringUtil.matches(DFiltersDialogAbstract.RGB_PATTERN_3, hexRGB) || ColorMap.get(hexRGB) != null || hexRGB.equals("random"))) {
                        return "Invalid color code or name!";
                    }
                }
            } else {
                elementKinds = line.substring(5);
                missingMatching = true;
            }
        }
        String[] kinds = missingMatching ? line.substring(line.startsWith("color") ? 5 : 4).split(",") : elementKinds.split(",");
        if (kinds.length == 1 && kinds[0].trim().isEmpty()) {
            return "At least one element kind must be specified!";
        }
        String[] stringArray = kinds;
        int n = kinds.length;
        int n2 = 0;
        while (n2 < n) {
            String kind = stringArray[n2];
            if (!(kind = kind.trim()).isEmpty() && !this.validator.getKindNames().contains(kind)) {
                return "Non-valid element kind: " + kind;
            }
            ++n2;
        }
        if (missingMatching) {
            return "Keyword \"matching\" is missing!";
        }
        if (expression.trim().isEmpty()) {
            return "Filter expression is empty!";
        }
        try {
            Pattern.compile(expression.trim());
        }
        catch (Exception exception) {
            return "Invalid regex expression: " + expression.trim();
        }
        return null;
    }

    private void scheduleValidateFilterText() {
        this.filterTextValidateJob.cancel();
        this.filterTextValidateJob.schedule(1000L);
    }

    private FontMetrics getFontMetrics(Composite composite) {
        GC gc = new GC((Drawable)composite);
        gc.setFont(JFaceResources.getDialogFont());
        FontMetrics fontMetrics = gc.getFontMetrics();
        gc.dispose();
        return fontMetrics;
    }

    public IContentProposalProvider getContentProposalProvider() {
        return DDesignFiltersContentAssistProvider.getInstance();
    }

    private static final class DelayedUIJob
    extends UIJob {
        private final Runnable runnable;

        public DelayedUIJob(Runnable runnable) {
            super("DelayedUIJob");
            this.setPriority(50);
            this.setSystem(true);
            this.runnable = runnable;
        }

        public IStatus runInUIThread(IProgressMonitor monitor) {
            this.runnable.run();
            return Status.OK_STATUS;
        }
    }

    private static final class StyledTextContentAdapter
    implements IControlContentAdapter,
    IControlContentAdapter2 {
        private StyledTextContentAdapter() {
        }

        public String getControlContents(Control control) {
            return ((StyledText)control).getText();
        }

        public void setControlContents(Control control, String text, int cursorPosition) {
            ((StyledText)control).setText(text);
            ((StyledText)control).setSelection(cursorPosition, cursorPosition);
        }

        public void insertControlContents(Control control, String text, int cursorPosition) {
            Point selection = ((StyledText)control).getSelection();
            ((StyledText)control).insert(text);
            if (cursorPosition <= text.length()) {
                ((StyledText)control).setSelection(selection.x + cursorPosition, selection.x + cursorPosition);
            }
        }

        public int getCursorPosition(Control control) {
            return ((StyledText)control).getCaretOffset();
        }

        public Rectangle getInsertionBounds(Control control) {
            StyledText text = (StyledText)control;
            Point caretOrigin = text.getLocationAtOffset(text.getCaretOffset());
            return new Rectangle(caretOrigin.x + text.getClientArea().x, caretOrigin.y + text.getClientArea().y + 3, 1, text.getLineHeight());
        }

        public void setCursorPosition(Control control, int position) {
            ((StyledText)control).setSelection(new Point(position, position));
        }

        public Point getSelection(Control control) {
            return ((StyledText)control).getSelection();
        }

        public void setSelection(Control control, Point range) {
            ((StyledText)control).setSelection(range);
        }
    }
}

