/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.diagrams.filters;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import ro.amiq.dvt.DVTPlugin;

public class DiagramFiltersUtils {
    public static Map<String, FilterBundle> getFiltersBundle(String prefConstName) {
        String serializedFilterSets = DVTPlugin.getDefault().getPreferenceStore().getString(prefConstName);
        if (serializedFilterSets == null || serializedFilterSets.isEmpty()) {
            return Collections.emptyMap();
        }
        String[] filterSetsAsStrings = serializedFilterSets.split("NEW_SET");
        LinkedHashMap<String, FilterBundle> filterSets = new LinkedHashMap<String, FilterBundle>();
        String[] stringArray = filterSetsAsStrings;
        int n = filterSetsAsStrings.length;
        int n2 = 0;
        while (n2 < n) {
            String set = stringArray[n2];
            if (!set.trim().isEmpty()) {
                String[] setParts = set.split("\n");
                if (setParts.length == 1) {
                    filterSets.put(setParts[0].trim(), new FilterBundle());
                } else {
                    int start = 1;
                    boolean reducePorts = false;
                    boolean reduceGates = false;
                    boolean reduceBlocks = false;
                    boolean hidePlainAssigns = false;
                    if ("reducePorts".equals(setParts[start])) {
                        reducePorts = true;
                        ++start;
                    }
                    if (setParts.length > start && "reduceGates".equals(setParts[start])) {
                        reduceGates = true;
                        ++start;
                    }
                    if (setParts.length > start && "reduceBlocks".equals(setParts[start])) {
                        reduceBlocks = true;
                        ++start;
                    }
                    if (setParts.length > start && "hidePlainAssigns".equals(setParts[start])) {
                        hidePlainAssigns = true;
                    }
                    StringBuilder sb = new StringBuilder();
                    int i = ++start;
                    while (i < setParts.length) {
                        sb.append(setParts[i]);
                        sb.append("\n");
                        ++i;
                    }
                    filterSets.put(setParts[0].trim(), new FilterBundle(sb.toString(), reducePorts, reduceGates, reduceBlocks, hidePlainAssigns));
                }
            }
            ++n2;
        }
        return filterSets;
    }

    public static void saveFilters(Map<String, FilterBundle> filterSets, String prefConstName, boolean override) {
        if (filterSets == null || filterSets.isEmpty()) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, FilterBundle> entry : filterSets.entrySet()) {
            String setName = entry.getKey();
            if ("None".equals(setName)) continue;
            sb.append(setName);
            sb.append("\n");
            FilterBundle filterBundle = entry.getValue();
            DiagramFiltersUtils.buildString(sb, filterBundle);
            sb.append("NEW_SET");
        }
        if (override) {
            DVTPlugin.getDefault().getPreferenceStore().setValue(prefConstName, sb.toString());
        } else {
            String currentValue = DVTPlugin.getDefault().getPreferenceStore().getString(prefConstName);
            String toAdd = sb.toString();
            toAdd = DiagramFiltersUtils.checkSameNamedFilters(currentValue, toAdd);
            DVTPlugin.getDefault().getPreferenceStore().setValue(prefConstName, String.valueOf(currentValue) + toAdd);
        }
    }

    private static String checkSameNamedFilters(String first, String second) {
        List<String> firstSets = Arrays.asList(first.split("NEW_SET"));
        String[] secondSets = second.split("NEW_SET");
        HashSet<String> names = new HashSet<String>();
        boolean isUniqueSet = false;
        for (String set : firstSets) {
            if (set.trim().isEmpty()) continue;
            names.add(set.split("\n")[0].trim());
        }
        String[] stringArray = secondSets;
        int n = secondSets.length;
        int n2 = 0;
        while (n2 < n) {
            String set;
            set = stringArray[n2];
            if (!set.trim().isEmpty() && !firstSets.contains(set)) {
                String setName;
                isUniqueSet = true;
                String newSetName = setName = set.split("\n")[0].trim();
                boolean isDuplicate = false;
                while (!names.add(newSetName)) {
                    newSetName = String.valueOf(newSetName) + "'";
                    isDuplicate = true;
                }
                if (isDuplicate) {
                    second = second.replaceFirst(setName, newSetName);
                }
            }
            ++n2;
        }
        return isUniqueSet ? second : "";
    }

    private static void buildString(StringBuilder sb, FilterBundle filterBundle) {
        if (filterBundle != null) {
            sb.append(filterBundle.reducePorts ? "reducePorts\n" : "");
            sb.append(filterBundle.reduceGates ? "reduceGates\n" : "");
            sb.append(filterBundle.reduceBlocks ? "reduceBlocks\n" : "");
            sb.append(filterBundle.hidePlainAssigns ? "hidePlainAssigns\n" : "");
            sb.append(filterBundle.filterSetContents != null ? filterBundle.filterSetContents : "");
        }
    }

    public static class FilterBundle {
        public String filterSetContents;
        public boolean reducePorts;
        public boolean reduceGates;
        public boolean reduceBlocks;
        public boolean hidePlainAssigns;

        public FilterBundle(String contents, boolean reducePorts, boolean reduceGates, boolean reduceBlocks, boolean hidePlainAssigns) {
            this.filterSetContents = contents;
            this.reducePorts = reducePorts;
            this.reduceGates = reduceGates;
            this.reduceBlocks = reduceBlocks;
            this.hidePlainAssigns = hidePlainAssigns;
        }

        public FilterBundle() {
            this("", false, false, false, false);
        }

        public String serializeBundle() {
            StringBuilder sb = new StringBuilder();
            DiagramFiltersUtils.buildString(sb, this);
            return sb.toString();
        }
    }
}

