/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.diagrams.fsm;

import de.cau.cs.kieler.core.kgraph.KEdge;
import de.cau.cs.kieler.core.kgraph.KGraphElement;
import de.cau.cs.kieler.core.kgraph.KLabel;
import de.cau.cs.kieler.core.kgraph.KLabeledGraphElement;
import de.cau.cs.kieler.core.kgraph.KNode;
import de.cau.cs.kieler.core.kgraph.KPort;
import de.cau.cs.kieler.core.properties.IProperty;
import de.cau.cs.kieler.kiml.klayoutdata.KEdgeLayout;
import de.cau.cs.kieler.kiml.klayoutdata.KIdentifier;
import de.cau.cs.kieler.kiml.klayoutdata.KLayoutDataFactory;
import de.cau.cs.kieler.kiml.klayoutdata.KShapeLayout;
import de.cau.cs.kieler.kiml.options.Direction;
import de.cau.cs.kieler.kiml.options.EdgeLabelPlacement;
import de.cau.cs.kieler.kiml.options.EdgeType;
import de.cau.cs.kieler.kiml.options.HierarchyHandling;
import de.cau.cs.kieler.kiml.options.LayoutOptions;
import de.cau.cs.kieler.kiml.options.NodeLabelPlacement;
import de.cau.cs.kieler.kiml.options.PortConstraints;
import de.cau.cs.kieler.kiml.options.PortSide;
import de.cau.cs.kieler.kiml.options.SizeConstraint;
import de.cau.cs.kieler.kiml.options.SizeOptions;
import de.cau.cs.kieler.kiml.util.KimlUtil;
import de.cau.cs.kieler.klay.layered.p2layers.LayeringStrategy;
import de.cau.cs.kieler.klay.layered.p3order.CrossingMinimizationStrategy;
import de.cau.cs.kieler.klay.layered.p4nodes.NodePlacementStrategy;
import de.cau.cs.kieler.klay.layered.properties.GreedySwitchType;
import de.cau.cs.kieler.klay.layered.properties.LayerConstraint;
import de.cau.cs.kieler.klay.layered.properties.Properties;
import de.cau.cs.kieler.klay.layered.properties.SelfLoopPlacement;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import ro.amiq.dvt.diagrams.fsm.FSMDiagramConfiguration;
import ro.amiq.dvt.diagrams.fsm.editor.actions.TransitionLabelType;
import ro.amiq.dvt.diagrams.fsm.model.FSMInput;
import ro.amiq.dvt.diagrams.fsm.rendering.FSMRenderingUtils;
import ro.amiq.dvt.diagrams.klay.model.KLaySize;
import ro.amiq.dvt.diagrams.klay.model.KLayWrapper;
import ro.amiq.dvt.draw.utils.FontFactory;
import ro.amiq.dvt.fsm.debug.FSMDebugUtils;
import ro.amiq.dvt.fsm.model.IFSMBase;
import ro.amiq.dvt.fsm.model.IFSMCondition;
import ro.amiq.dvt.fsm.model.IFSMInput;
import ro.amiq.dvt.fsm.model.IFSMState;
import ro.amiq.dvt.fsm.model.IFSMTransition;
import ro.amiq.dvt.fsm.utils.FSMUtils;
import ro.amiq.dvt.model.reflection.NotNull;

public class FSMDiagramAdapter {
    private final FSMDiagramConfiguration config;
    public final String layoutAlgorithm;

    public FSMDiagramAdapter(FSMDiagramConfiguration config) {
        this.config = config;
        this.layoutAlgorithm = "de.cau.cs.kieler.klay.layered";
    }

    public void setKNodeInfo(KNode node, IFSMState state) {
        this.setKIdentifier((KGraphElement)node, this.getKIdentifier(state));
        FSMRenderingUtils.renderGate(node, state, this.config);
        this.setKLabels((KLabeledGraphElement)node, state);
        KShapeLayout nodeShapeLayout = (KShapeLayout)node.getData(KShapeLayout.class);
        EnumSet<NodeLabelPlacement> nodeLabelPlacement = this.getKNodeLabelPlacement();
        this.setKNodeLayoutOptions(nodeShapeLayout, nodeLabelPlacement, this.getKNodeSizeOptions(), this.getKNodeSizeConstraint(), this.getKNodeHierarchyHandling(), this.getKNodePortContraints());
        this.setLNodeLayeredOptions(nodeShapeLayout, this.getKNodeLayerConstraint(state));
    }

    private float getKNodeLabelSpacing() {
        return 2.0f;
    }

    private PortConstraints getKNodePortContraints() {
        return this.config.get(FSMDiagramConfiguration.FSMDiagramConfigurationKey.ENFORCE_TRANSITION_PORTS) == FSMDiagramConfiguration.EnforceTransitionPortsOption.NONE ? PortConstraints.FREE : PortConstraints.FIXED_SIDE;
    }

    private HierarchyHandling getKNodeHierarchyHandling() {
        return HierarchyHandling.INHERIT;
    }

    public float setKNodesSpacingInfo(Collection<KNode> kNodes) {
        if (this.config.contains(FSMDiagramConfiguration.FSMDiagramConfigurationKey.SHOW_STATE_AS_CIRCLE)) {
            return this.setKNodeCircleSpacingInfo(kNodes);
        }
        return this.setKNodeRectangleSpacing(kNodes);
    }

    private float setKNodeCircleSpacingInfo(Collection<KNode> kNodes) {
        if (kNodes == null || kNodes.isEmpty()) {
            return 0.0f;
        }
        float labelSpacing = this.getKNodeLabelSpacing();
        float max = 0.0f;
        for (KNode kNode : kNodes) {
            KLaySize local = this.getKNodeSpacingInfo(kNode, labelSpacing);
            float localMax = Math.max(local.height, local.width);
            if (!(localMax > max)) continue;
            max = localMax;
        }
        FSMDebugUtils.debugLevelThree("Found max dimension to be " + max, new Object[0]);
        for (KNode kNode : kNodes) {
            KShapeLayout nodeLayout = (KShapeLayout)kNode.getData(KShapeLayout.class);
            if (nodeLayout == null) continue;
            nodeLayout.setProperty(LayoutOptions.MIN_WIDTH, (Object)Float.valueOf(max));
            nodeLayout.setProperty(LayoutOptions.MIN_HEIGHT, (Object)Float.valueOf(max));
        }
        return max;
    }

    private float setKNodeRectangleSpacing(Collection<KNode> kNodes) {
        if (kNodes == null || kNodes.isEmpty()) {
            return 0.0f;
        }
        float labelSpacing = this.getKNodeLabelSpacing();
        float max = 0.0f;
        for (KNode kNode : kNodes) {
            KShapeLayout nodeLayout = (KShapeLayout)kNode.getData(KShapeLayout.class);
            if (nodeLayout == null) continue;
            KLaySize local = this.getKNodeSpacingInfo(kNode, labelSpacing);
            float localMax = Math.max(local.height, local.width);
            if (localMax > max) {
                max = localMax;
            }
            nodeLayout.setProperty(LayoutOptions.MIN_WIDTH, (Object)Float.valueOf(local.width));
            nodeLayout.setProperty(LayoutOptions.MIN_HEIGHT, (Object)Float.valueOf(local.height));
        }
        return max;
    }

    private KLaySize getKNodeSpacingInfo(KNode node, float labelSpacing) {
        if (node == null) {
            return KLaySize.of(0.0f, 0.0f);
        }
        KShapeLayout nodeLayout = (KShapeLayout)node.getData(KShapeLayout.class);
        if (nodeLayout == null) {
            return KLaySize.of(0.0f, 0.0f);
        }
        nodeLayout.setProperty(LayoutOptions.LABEL_SPACING, (Object)Float.valueOf(labelSpacing));
        KLaySize nLSpace = this.computeSpaceForNodeLabels((List<KLabel>)node.getLabels(), labelSpacing);
        return nLSpace;
    }

    private KLaySize computeSpaceForNodeLabels(List<KLabel> nodeLabels, float labelSpacing) {
        KLaySize size = KLaySize.of(0.0f, 0.0f);
        if (nodeLabels == null || nodeLabels.isEmpty()) {
            return size;
        }
        for (KLabel nodeLabel : nodeLabels) {
            KShapeLayout labelLayout = (KShapeLayout)nodeLabel.getData(KShapeLayout.class);
            float lWidth = labelLayout.getWidth() + labelSpacing;
            float lHeight = labelLayout.getHeight() + labelSpacing;
            if (size.width < lWidth) {
                size.width = lWidth;
            }
            size.height += lHeight;
        }
        return size;
    }

    private LayerConstraint getKNodeLayerConstraint(IFSMState state) {
        if (!FSMUtils.isStartState(state)) {
            return null;
        }
        LayerConstraint layer = this.config.get(FSMDiagramConfiguration.FSMDiagramConfigurationKey.ENFORCE_INITIAL_STATE_LAYER);
        return layer != null ? layer : LayerConstraint.NONE;
    }

    private EnumSet<SizeConstraint> getKNodeSizeConstraint() {
        return EnumSet.of(SizeConstraint.MINIMUM_SIZE, SizeConstraint.NODE_LABELS);
    }

    private EnumSet<SizeOptions> getKNodeSizeOptions() {
        return EnumSet.of(SizeOptions.DEFAULT_MINIMUM_SIZE);
    }

    private void setKNodeLayoutOptions(KShapeLayout nodeLayout, EnumSet<NodeLabelPlacement> nodeLabelPlacement, EnumSet<SizeOptions> nodeSizeOptions, EnumSet<SizeConstraint> nodeSizeContraints, HierarchyHandling hierarchyHandling, PortConstraints portConstraints) {
        if (nodeLayout == null) {
            return;
        }
        nodeLayout.setProperty(LayoutOptions.DIRECTION, (Object)this.config.get(FSMDiagramConfiguration.FSMDiagramConfigurationKey.DIRECTION));
        nodeLayout.setProperty(LayoutOptions.EDGE_ROUTING, (Object)this.config.get(FSMDiagramConfiguration.FSMDiagramConfigurationKey.EDGE_ROUTING));
        nodeLayout.setProperty(LayoutOptions.ALGORITHM, (Object)this.layoutAlgorithm);
        nodeLayout.setProperty(LayoutOptions.NODE_LABEL_PLACEMENT, nodeLabelPlacement);
        nodeLayout.setProperty(LayoutOptions.SIZE_OPTIONS, nodeSizeOptions);
        nodeLayout.setProperty(LayoutOptions.SIZE_CONSTRAINT, nodeSizeContraints);
        nodeLayout.setProperty(LayoutOptions.PORT_CONSTRAINTS, (Object)portConstraints);
        nodeLayout.setProperty(LayoutOptions.HIERARCHY_HANDLING, (Object)hierarchyHandling);
    }

    private void setLNodeLayeredOptions(KShapeLayout nodeLayout, LayerConstraint layerConstraint) {
        if (nodeLayout == null) {
            return;
        }
        nodeLayout.setProperty(Properties.FEEDBACK_EDGES, (Object)true);
        nodeLayout.setProperty(Properties.SPLINE_SELF_LOOP_PLACEMENT, (Object)SelfLoopPlacement.EQUALLY_DISTRIBUTED);
        nodeLayout.setProperty(Properties.LAYER_CONSTRAINT, (Object)layerConstraint);
    }

    private EnumSet<NodeLabelPlacement> getKNodeLabelPlacement() {
        return NodeLabelPlacement.insideCenter();
    }

    public void setRootKNodeInfo(String title, KNode root) {
        if (root == null) {
            return;
        }
        FSMRenderingUtils.renderDummyGate(root);
        this.setKIdentifier((KGraphElement)root, title);
        KShapeLayout layout = (KShapeLayout)root.getData(KShapeLayout.class);
        if (layout == null) {
            return;
        }
        this.setRootKNodeLayoutOptions(layout);
        this.setRootLNodeLayeredOptions(layout, this.getRootKNodePlacement());
        this.setRootKNodeSpacingOptions(layout);
    }

    private NodePlacementStrategy getRootKNodePlacement() {
        NodePlacementStrategy nodePlacementStrategy = this.config.get(FSMDiagramConfiguration.FSMDiagramConfigurationKey.NODE_PLACEMENT_STRATEGY);
        return nodePlacementStrategy != null ? nodePlacementStrategy : NodePlacementStrategy.BRANDES_KOEPF;
    }

    private void setRootKNodeLayoutOptions(KShapeLayout nodeLayout) {
        if (nodeLayout == null) {
            return;
        }
        nodeLayout.setProperty(LayoutOptions.DIRECTION, (Object)this.config.get(FSMDiagramConfiguration.FSMDiagramConfigurationKey.DIRECTION));
        nodeLayout.setProperty(LayoutOptions.EDGE_ROUTING, (Object)this.config.get(FSMDiagramConfiguration.FSMDiagramConfigurationKey.EDGE_ROUTING));
        nodeLayout.setProperty(LayoutOptions.ALGORITHM, (Object)this.layoutAlgorithm);
        nodeLayout.setProperty(LayoutOptions.EXPAND_NODES, (Object)true);
        nodeLayout.setProperty(LayoutOptions.HIERARCHY_HANDLING, (Object)HierarchyHandling.INCLUDE_CHILDREN);
    }

    private void setRootLNodeLayeredOptions(KShapeLayout nodeLayout, NodePlacementStrategy nodePlacementStrategy) {
        if (nodeLayout == null) {
            return;
        }
        nodeLayout.setProperty(Properties.NODE_PLACER, (Object)nodePlacementStrategy);
        nodeLayout.setProperty(Properties.GREEDY_SWITCH_TYPE, (Object)GreedySwitchType.TWO_SIDED_BEST_OF_UP_OR_DOWN);
        nodeLayout.setProperty(Properties.NODE_LAYERING, (Object)LayeringStrategy.NETWORK_SIMPLEX);
        nodeLayout.setProperty(Properties.CROSS_MIN, (Object)CrossingMinimizationStrategy.LAYER_SWEEP);
        nodeLayout.setProperty(Properties.FEEDBACK_EDGES, (Object)true);
        nodeLayout.setProperty(Properties.SPLINE_SELF_LOOP_PLACEMENT, (Object)SelfLoopPlacement.EQUALLY_DISTRIBUTED);
    }

    private void setRootKNodeSpacingOptions(KShapeLayout nodeLayout) {
        if (nodeLayout == null) {
            return;
        }
        float labelSpacing = this.getKNodeLabelSpacing();
        nodeLayout.setProperty(LayoutOptions.SPACING, (Object)this.config.get(FSMDiagramConfiguration.FSMDiagramConfigurationKey.SPACING));
        nodeLayout.setProperty(LayoutOptions.LABEL_SPACING, (Object)Float.valueOf(labelSpacing));
        nodeLayout.setProperty((IProperty)Properties.EDGE_NODE_SPACING_FACTOR, (Object)this.config.get(FSMDiagramConfiguration.FSMDiagramConfigurationKey.EDGE_NODE_SPACING_FACTOR));
        nodeLayout.setProperty((IProperty)Properties.EDGE_SPACING_FACTOR, (Object)this.config.get(FSMDiagramConfiguration.FSMDiagramConfigurationKey.EDGE_SPACING_FACTOR));
        nodeLayout.setProperty(Properties.OBJ_SPACING_IN_LAYER_FACTOR, (Object)this.config.get(FSMDiagramConfiguration.FSMDiagramConfigurationKey.OBJ_SPACING_IN_LAYER_FACTOR));
    }

    private void setKLabels(KLabeledGraphElement parent, IFSMBase object) {
        if (parent == null || object == null) {
            return;
        }
        if (object instanceof IFSMState) {
            String text;
            IFSMState state = (IFSMState)object;
            String string = text = state.isDefault() ? state.getNiceID().toUpperCase() : state.getNiceID();
            if (text == null) {
                return;
            }
            this.setKLabel(object, text, parent);
        } else if (object instanceof IFSMTransition) {
            if (this.config.get(FSMDiagramConfiguration.FSMDiagramConfigurationKey.SHOW_TRANSITION_LABELS) != TransitionLabelType.CONDITION) {
                return;
            }
            IFSMInput input = ((IFSMTransition)object).getSourceInput();
            if (input instanceof FSMInput && ((FSMInput)input).hasConditions()) {
                for (IFSMCondition condition : ((FSMInput)input).getConditions()) {
                    if (FSMUtils.isEmptyCondition(condition)) continue;
                    String text = condition.toString();
                    if (text == null) {
                        return;
                    }
                    this.setKLabel(condition, text, parent);
                }
            }
        }
    }

    public void setKLabel(IFSMBase object, String text, KLabeledGraphElement parent) {
        if (text == null) {
            return;
        }
        KLabel label = KimlUtil.createInitializedLabel((KLabeledGraphElement)parent);
        if (object != null) {
            label.getData().add((Object)KLayWrapper.of(object));
        }
        String padding = "  ";
        label.setText(String.valueOf(padding) + text + padding);
        this.setKLabelInfo(label, object);
    }

    private void setKLabelInfo(KLabel label, IFSMBase object) {
        this.setKIdentifier((KGraphElement)label, this.getKIdentifier(object));
        FSMRenderingUtils.renderLabel(label, object);
        this.setKLabelLayoutOptions((KShapeLayout)label.getData(KShapeLayout.class), this.getKLabelFixedSize(label));
    }

    private void setKLabelLayoutOptions(KShapeLayout layout, Point size) {
        if (layout == null) {
            return;
        }
        layout.setSize((float)size.x, (float)size.y);
    }

    private Point getKLabelFixedSize(KLabel label) {
        if (label == null) {
            return new Point(0, 0);
        }
        FontData fontData = FSMRenderingUtils.getFontData(label);
        if (fontData == null) {
            return new Point(0, 0);
        }
        return FontFactory.getInstance().stringExtent(label.getText(), fontData);
    }

    public void setKEdgeInfo(KEdge edge, IFSMTransition transition) {
        this.setKIdentifier((KGraphElement)edge, this.getKIdentifier(transition));
        FSMRenderingUtils.renderEdge(edge, transition, this.config);
        this.setKLabels((KLabeledGraphElement)edge, transition);
        this.setKEdgeLayoutOptions((KEdgeLayout)edge.getData(KEdgeLayout.class), this.getKEdgeType(transition), this.getKEdgeThickness(transition), this.getKEdgeLabelPlacement(transition));
    }

    private EdgeLabelPlacement getKEdgeLabelPlacement(IFSMTransition transition) {
        return EdgeLabelPlacement.CENTER;
    }

    private void setKEdgeLayoutOptions(KEdgeLayout edgeLayout, EdgeType edgeType, float edgeThicknes, EdgeLabelPlacement edgeLabelPlacement) {
        if (edgeLayout == null) {
            return;
        }
        if (edgeType != null) {
            edgeLayout.setProperty(LayoutOptions.EDGE_TYPE, (Object)edgeType);
        }
        edgeLayout.setProperty(LayoutOptions.EDGE_ROUTING, (Object)this.config.get(FSMDiagramConfiguration.FSMDiagramConfigurationKey.EDGE_ROUTING));
        edgeLayout.setProperty(LayoutOptions.THICKNESS, (Object)Float.valueOf(Math.max(edgeThicknes, 1.0f)));
        edgeLayout.setProperty(LayoutOptions.EDGE_LABEL_PLACEMENT, (Object)(edgeLabelPlacement != null ? edgeLabelPlacement : EdgeLabelPlacement.CENTER));
    }

    private float getKEdgeThickness(IFSMTransition transition) {
        return 1.0f;
    }

    private EdgeType getKEdgeType(IFSMTransition transition) {
        return EdgeType.DIRECTED;
    }

    private void setKIdentifier(KGraphElement kElement, String id) {
        KIdentifier identifier = (KIdentifier)kElement.getData(KIdentifier.class);
        if (identifier != null) {
            return;
        }
        identifier = KLayoutDataFactory.eINSTANCE.createKIdentifier();
        identifier.setId(id);
        kElement.getData().add((Object)identifier);
    }

    @NotNull
    private String getKIdentifier(IFSMBase element) {
        if (element instanceof IFSMState) {
            return ((IFSMState)element).getID();
        }
        if (element instanceof IFSMTransition) {
            return element.toString();
        }
        if (element instanceof IFSMCondition) {
            return element.toString();
        }
        return "";
    }

    public void setKPortInfo(KPort port, String portID, boolean isOutgoing) {
        this.setKIdentifier((KGraphElement)port, portID);
        FSMRenderingUtils.renderPort(port, this.config);
        this.setKPortLayoutOptions((KShapeLayout)port.getData(KShapeLayout.class), this.getKPortSide(isOutgoing));
    }

    private void setKPortLayoutOptions(KShapeLayout portLayout, PortSide side) {
        if (portLayout == null) {
            return;
        }
        portLayout.setProperty(LayoutOptions.PORT_SIDE, (Object)(side != null ? side : PortSide.UNDEFINED));
        portLayout.setSize(0.0f, 0.0f);
    }

    private PortSide getKPortSide(boolean isOutgoing) {
        if (this.config.get(FSMDiagramConfiguration.FSMDiagramConfigurationKey.ENFORCE_TRANSITION_PORTS) == FSMDiagramConfiguration.EnforceTransitionPortsOption.NONE) {
            return PortSide.UNDEFINED;
        }
        Direction diagramDirection = this.config.get(FSMDiagramConfiguration.FSMDiagramConfigurationKey.DIRECTION);
        switch (diagramDirection) {
            case DOWN: {
                return isOutgoing ? PortSide.SOUTH : PortSide.NORTH;
            }
            case UP: {
                return isOutgoing ? PortSide.NORTH : PortSide.SOUTH;
            }
            case LEFT: {
                return isOutgoing ? PortSide.WEST : PortSide.EAST;
            }
            case RIGHT: {
                return isOutgoing ? PortSide.EAST : PortSide.WEST;
            }
        }
        return PortSide.UNDEFINED;
    }
}

