/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.diagrams.fsm;

import de.cau.cs.kieler.kiml.options.Direction;
import de.cau.cs.kieler.kiml.options.EdgeRouting;
import de.cau.cs.kieler.klay.layered.p4nodes.NodePlacementStrategy;
import de.cau.cs.kieler.klay.layered.properties.LayerConstraint;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.preference.IPreferenceStore;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.diagrams.fsm.editor.actions.TransitionLabelType;
import ro.amiq.dvt.fsm.utils.FSMUtils;
import ro.amiq.dvt.wizards.specador.SpecadorModel;

public final class FSMDiagramConfiguration
implements Cloneable {
    private Map<String, Object> store = new HashMap<String, Object>();

    public void add(FSMDiagramConfigurationKey<Boolean> key) {
        this.store.put(key.id, Boolean.TRUE);
    }

    public <V> void remove(FSMDiagramConfigurationKey<V> key) {
        this.store.remove(key.id);
    }

    public void toggle(FSMDiagramConfigurationKey<Boolean> key) {
        if (this.contains(key)) {
            this.remove(key);
        } else {
            this.add(key);
        }
    }

    public <V> void set(FSMDiagramConfigurationKey<V> key, V value) {
        this.store.put(key.id, value);
    }

    public <V> V get(FSMDiagramConfigurationKey<V> key) {
        return (V)this.store.get(key.id);
    }

    public <V> boolean contains(FSMDiagramConfigurationKey<V> key) {
        return this.store.containsKey(key.id);
    }

    public static final FSMDiagramConfiguration getDefault() {
        FSMDiagramConfiguration config = new FSMDiagramConfiguration();
        IPreferenceStore store = DVTPlugin.getDefault().getPreferenceStore();
        config.set(FSMDiagramConfigurationKey.DIRECTION, Direction.valueOf((String)store.getString("designdiagrams.fsm_direction")));
        config.set(FSMDiagramConfigurationKey.EDGE_ROUTING, EdgeRouting.SPLINES);
        config.add(FSMDiagramConfigurationKey.MERGE_DUPLICATE_TRANSITIONS);
        if (!store.getBoolean("designdiagrams.fsm_loopback_transitions")) {
            config.add(FSMDiagramConfigurationKey.REMOVE_LOOPBACK_TRANSITIONS);
        }
        if (store.getBoolean("designdiagrams.fsm_show_default_state")) {
            config.add(FSMDiagramConfigurationKey.SHOW_DEFAULT_STATE);
        }
        if (store.getBoolean("designdiagrams.fms_filter_common_expressions_in_conditions")) {
            config.add(FSMDiagramConfigurationKey.FILTER_COMMON_EXPRESSIONS_IN_CONDITIONS);
        }
        config.set(FSMDiagramConfigurationKey.SHOW_TRANSITION_LABELS, TransitionLabelType.valueOf(store.getString("designdiagrams.fsm_show_edge_transition_labels")));
        config.set(FSMDiagramConfigurationKey.FILTER_NAMES_IN_CONDITIONS, FSMUtils.getNamesFilteredInCondition(store.getString("designdiagrams.fsm_hide_names_in_conditions")));
        config.set(FSMDiagramConfigurationKey.ENFORCE_TRANSITION_PORTS, EnforceTransitionPortsOption.valueOf(store.getString("designdiagrams.fsm_enforce_transition_ports")));
        config.set(FSMDiagramConfigurationKey.ENFORCE_INITIAL_STATE_LAYER, LayerConstraint.valueOf((String)store.getString("designdiagrams.fsm_enforce_initial_state_layer")));
        config.set(FSMDiagramConfigurationKey.NODE_PLACEMENT_STRATEGY, NodePlacementStrategy.valueOf((String)store.getString("designdiagrams.fsm_node_placement_strategy")));
        config.set(FSMDiagramConfigurationKey.SPACING, Float.valueOf(20.0f));
        config.set(FSMDiagramConfigurationKey.EDGE_NODE_SPACING_FACTOR, Float.valueOf(1.0f));
        config.set(FSMDiagramConfigurationKey.EDGE_SPACING_FACTOR, Float.valueOf(1.0f));
        config.set(FSMDiagramConfigurationKey.OBJ_SPACING_IN_LAYER_FACTOR, Float.valueOf(1.0f));
        return config;
    }

    public static final FSMDiagramConfiguration getPreferencesSpecador(SpecadorModel model) {
        FSMDiagramConfiguration config = FSMDiagramConfiguration.getDefault();
        config.set(FSMDiagramConfigurationKey.DIRECTION, FSMUtils.getDirectionFromString(model.getFSMDiagramDirection()));
        if (!model.getFSMShowLoopbackEdges()) {
            config.add(FSMDiagramConfigurationKey.REMOVE_LOOPBACK_TRANSITIONS);
        } else {
            config.remove(FSMDiagramConfigurationKey.REMOVE_LOOPBACK_TRANSITIONS);
        }
        if (model.getFSMShowDefaultState()) {
            config.add(FSMDiagramConfigurationKey.SHOW_DEFAULT_STATE);
        } else {
            config.remove(FSMDiagramConfigurationKey.SHOW_DEFAULT_STATE);
        }
        if (model.getFSMFilterCommonExpressionsInConditions()) {
            config.add(FSMDiagramConfigurationKey.FILTER_COMMON_EXPRESSIONS_IN_CONDITIONS);
        } else {
            config.remove(FSMDiagramConfigurationKey.FILTER_COMMON_EXPRESSIONS_IN_CONDITIONS);
        }
        if (model.getOutputFormat() == null || model.getOutputFormat().equals((Object)SpecadorModel.OutputFormat.HTML)) {
            config.add(FSMDiagramConfigurationKey.TOOLTIP);
        }
        config.set(FSMDiagramConfigurationKey.SHOW_TRANSITION_LABELS, TransitionLabelType.INDEX);
        config.set(FSMDiagramConfigurationKey.FILTER_NAMES_IN_CONDITIONS, Collections.singleton("reset"));
        config.set(FSMDiagramConfigurationKey.ENFORCE_TRANSITION_PORTS, FSMUtils.getEnforceTransitionPortsFromString(model.getFSMEnforceEdgePortSide()));
        config.set(FSMDiagramConfigurationKey.ENFORCE_INITIAL_STATE_LAYER, FSMUtils.getLayerConstraintFromString(model.getFSMInitialStatePosition()));
        config.set(FSMDiagramConfigurationKey.NODE_PLACEMENT_STRATEGY, FSMUtils.getNodePlacementStrategyFromString(model.getFSMPlacementStrategy()));
        return config;
    }

    public static final FSMDiagramConfiguration getTestDefault() {
        FSMDiagramConfiguration config = new FSMDiagramConfiguration();
        config.set(FSMDiagramConfigurationKey.DIRECTION, Direction.DOWN);
        config.set(FSMDiagramConfigurationKey.EDGE_ROUTING, EdgeRouting.SPLINES);
        config.add(FSMDiagramConfigurationKey.MERGE_DUPLICATE_TRANSITIONS);
        config.set(FSMDiagramConfigurationKey.SHOW_TRANSITION_LABELS, TransitionLabelType.CONDITION);
        config.add(FSMDiagramConfigurationKey.SHOW_DEFAULT_STATE);
        config.set(FSMDiagramConfigurationKey.FILTER_NAMES_IN_CONDITIONS, Collections.emptySet());
        config.set(FSMDiagramConfigurationKey.ENFORCE_TRANSITION_PORTS, EnforceTransitionPortsOption.ALL_STATES_EXCEPT_INITIAL);
        config.set(FSMDiagramConfigurationKey.ENFORCE_INITIAL_STATE_LAYER, LayerConstraint.FIRST_SEPARATE);
        config.set(FSMDiagramConfigurationKey.NODE_PLACEMENT_STRATEGY, NodePlacementStrategy.BRANDES_KOEPF);
        config.set(FSMDiagramConfigurationKey.SPACING, Float.valueOf(20.0f));
        config.set(FSMDiagramConfigurationKey.EDGE_NODE_SPACING_FACTOR, Float.valueOf(1.0f));
        config.set(FSMDiagramConfigurationKey.EDGE_SPACING_FACTOR, Float.valueOf(1.0f));
        config.set(FSMDiagramConfigurationKey.OBJ_SPACING_IN_LAYER_FACTOR, Float.valueOf(1.0f));
        return config;
    }

    public FSMDiagramConfiguration deepCopy() {
        FSMDiagramConfiguration config = new FSMDiagramConfiguration();
        config.store = new HashMap<String, Object>(this.store);
        return config;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.store == null ? 0 : this.store.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FSMDiagramConfiguration other = (FSMDiagramConfiguration)obj;
        return !(this.store == null ? other.store != null : !this.store.equals(other.store));
    }

    public static enum EnforceTransitionPortsOption {
        NONE,
        ALL_STATES,
        ALL_STATES_EXCEPT_INITIAL;

    }

    public static final class FSMDiagramConfigurationKey<V> {
        private String id;
        public static final FSMDiagramConfigurationKey<Boolean> MERGE_DUPLICATE_TRANSITIONS = new FSMDiagramConfigurationKey("fsm.merge_duplicate_transitions");
        public static final FSMDiagramConfigurationKey<Boolean> REMOVE_LOOPBACK_TRANSITIONS = new FSMDiagramConfigurationKey("fsm.remove_loopback_transitions");
        public static final FSMDiagramConfigurationKey<TransitionLabelType> SHOW_TRANSITION_LABELS = new FSMDiagramConfigurationKey("fsm.show_edge_transition_labels");
        public static final FSMDiagramConfigurationKey<Boolean> SHOW_DEFAULT_STATE = new FSMDiagramConfigurationKey("fsm.show_default_state");
        public static final FSMDiagramConfigurationKey<Boolean> SHOW_STATE_AS_CIRCLE = new FSMDiagramConfigurationKey("fsm.show_state_as_circle");
        public static final FSMDiagramConfigurationKey<Set<String>> FILTER_NAMES_IN_CONDITIONS = new FSMDiagramConfigurationKey("fsm.filter_names_in_conditions");
        public static final FSMDiagramConfigurationKey<EnforceTransitionPortsOption> ENFORCE_TRANSITION_PORTS = new FSMDiagramConfigurationKey("fsm.enforce_transition_ports");
        public static final FSMDiagramConfigurationKey<LayerConstraint> ENFORCE_INITIAL_STATE_LAYER = new FSMDiagramConfigurationKey("fsm.enforce_initial_state_layer");
        public static final FSMDiagramConfigurationKey<NodePlacementStrategy> NODE_PLACEMENT_STRATEGY = new FSMDiagramConfigurationKey("fsm.node_placement_strategy");
        public static final FSMDiagramConfigurationKey<Direction> DIRECTION = new FSMDiagramConfigurationKey("fsm.direction");
        public static final FSMDiagramConfigurationKey<EdgeRouting> EDGE_ROUTING = new FSMDiagramConfigurationKey("fsm.edge_routing");
        public static final FSMDiagramConfigurationKey<Boolean> TOOLTIP = new FSMDiagramConfigurationKey("fsm.tooltip");
        public static final FSMDiagramConfigurationKey<Boolean> FILTER_COMMON_EXPRESSIONS_IN_CONDITIONS = new FSMDiagramConfigurationKey("fsm.filter_common_expressions_in_conditions");
        public static final FSMDiagramConfigurationKey<Float> SPACING = new FSMDiagramConfigurationKey("fsm.node_spacing");
        public static final FSMDiagramConfigurationKey<Float> EDGE_NODE_SPACING_FACTOR = new FSMDiagramConfigurationKey("fsm.edge_node_spacing_factor");
        public static final FSMDiagramConfigurationKey<Float> EDGE_SPACING_FACTOR = new FSMDiagramConfigurationKey("fsm.edge_spacing_factor");
        public static final FSMDiagramConfigurationKey<Float> OBJ_SPACING_IN_LAYER_FACTOR = new FSMDiagramConfigurationKey("fsm.obj_spacing_in_layer_factor");

        private FSMDiagramConfigurationKey(String id) {
            this.id = id;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            FSMDiagramConfigurationKey other = (FSMDiagramConfigurationKey)obj;
            return !(this.id == null ? other.id != null : !this.id.equals(other.id));
        }
    }
}

