/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.diagrams.fsm;

import de.cau.cs.kieler.core.kgraph.KNode;
import org.eclipse.core.runtime.IProgressMonitor;
import ro.amiq.dvt.diagrams.DProgressMonitor;
import ro.amiq.dvt.diagrams.IDiagramEngine;
import ro.amiq.dvt.diagrams.exceptions.DCanceledException;
import ro.amiq.dvt.diagrams.exceptions.DMessageException;
import ro.amiq.dvt.diagrams.fsm.FSMDiagramConfiguration;
import ro.amiq.dvt.diagrams.fsm.FSMDiagramImporter;
import ro.amiq.dvt.diagrams.fsm.editor.FSMTransitionTableData;
import ro.amiq.dvt.diagrams.fsm.model.FSMModel;
import ro.amiq.dvt.diagrams.fsm.utils.FSMDiagramProcessors;
import ro.amiq.dvt.fsm.convert.FSMConverter;
import ro.amiq.dvt.model.reflection.IRfFieldElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;

public enum FSMDiagramEngine implements IDiagramEngine
{
    INSTANCE;


    public KNode makeNewDiagram(String title, IRfFieldElement stateVar, IRfNamedElement stateVarScope, FSMDiagramConfiguration config, FSMTransitionTableData tableConstructor, DProgressMonitor monitor) throws DCanceledException {
        if (tableConstructor != null) {
            tableConstructor.clear();
        }
        FSMModel model = this.makeFSMModel(stateVar, stateVarScope, monitor);
        return this.makeNewDiagram(title, model, config, tableConstructor, monitor);
    }

    public KNode makeNewDiagram(String title, FSMModel model, FSMDiagramConfiguration config, FSMTransitionTableData tableConstructor, DProgressMonitor monitor) throws DCanceledException {
        if (model == null) {
            throw new DMessageException("Could not determine state values for '" + title + "'!");
        }
        if (!model.hasTransitions()) {
            throw new DMessageException("Could not determine state transitions for '" + title + "'!");
        }
        FSMDiagramProcessors.filterCommonCondition(model, config, monitor);
        FSMDiagramProcessors.mergeDuplicateTransitions(model, config, (IProgressMonitor)monitor);
        FSMDiagramProcessors.filterConditionsBySignalName(model, config, monitor);
        FSMDiagramProcessors.removeLoopBackTransitions(model, config, monitor);
        FSMDiagramProcessors.removeDefaultState(model, config, monitor);
        KNode graph = FSMDiagramImporter.getInstance(config).toKLay(title, model, monitor);
        FSMDiagramProcessors.setAndShowTransitionIndexes(model, config);
        if (tableConstructor != null) {
            tableConstructor.doWork(model);
        }
        return graph;
    }

    private FSMModel makeFSMModel(IRfFieldElement stateVar, IRfNamedElement stateVarScope, DProgressMonitor monitor) {
        FSMModel model = (FSMModel)FSMConverter.convert(stateVar, stateVarScope, (IProgressMonitor)monitor);
        return model;
    }
}

