/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.diagrams.fsm;

import de.cau.cs.kieler.core.kgraph.KEdge;
import de.cau.cs.kieler.core.kgraph.KNode;
import de.cau.cs.kieler.core.kgraph.KPort;
import de.cau.cs.kieler.kiml.klayoutdata.KShapeLayout;
import de.cau.cs.kieler.kiml.options.HierarchyHandling;
import de.cau.cs.kieler.kiml.options.LayoutOptions;
import de.cau.cs.kieler.kiml.util.KimlUtil;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import ro.amiq.dvt.diagrams.DProgressMonitor;
import ro.amiq.dvt.diagrams.exceptions.DCanceledException;
import ro.amiq.dvt.diagrams.fsm.FSMDiagramAdapter;
import ro.amiq.dvt.diagrams.fsm.FSMDiagramConfiguration;
import ro.amiq.dvt.diagrams.fsm.model.FSMModel;
import ro.amiq.dvt.diagrams.fsm.model.FSMState;
import ro.amiq.dvt.diagrams.fsm.model.FSMTransition;
import ro.amiq.dvt.diagrams.fsm.rendering.FSMRenderingUtils;
import ro.amiq.dvt.diagrams.klay.model.KLayWrapper;
import ro.amiq.dvt.fsm.debug.FSMDebugUtils;
import ro.amiq.dvt.fsm.model.IFSMState;
import ro.amiq.dvt.fsm.model.IFSMTransition;
import ro.amiq.dvt.fsm.utils.FSMExecutors;
import ro.amiq.dvt.fsm.utils.FSMUtils;
import ro.amiq.dvt.fsm.utils.FSMVisitors;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.wizards.specador.FSMTooltipDataWrapper;

public class FSMDiagramImporter {
    private final FSMDiagramAdapter adapter;
    private final FSMDiagramConfiguration config;

    public FSMDiagramImporter(FSMDiagramAdapter adapter, FSMDiagramConfiguration config) {
        this.adapter = adapter;
        this.config = config;
    }

    public static FSMDiagramImporter getInstance(FSMDiagramConfiguration config) {
        return new FSMDiagramImporter(new FSMDiagramAdapter(config), config);
    }

    public KNode toKLay(String title, FSMModel model, DProgressMonitor monitor) throws DCanceledException {
        monitor.checkCanceled();
        Bundle bundle = Bundle.of(KimlUtil.createInitializedNode(), new LinkedHashMap<FSMState, KNode>(), model, monitor);
        this.BFSToKlay(monitor, bundle);
        monitor.setDebugTimeoutInfo("Nodes: " + bundle.nofKNodes + "\nEdges: " + bundle.nofKEdges);
        this.adapter.setKNodesSpacingInfo(bundle.kNodes.values());
        this.adapter.setRootKNodeInfo(title, bundle.root);
        return bundle.root;
    }

    private void BFSToKlay(DProgressMonitor monitor, final Bundle bundle) {
        if (bundle.root == null || bundle.model == null || bundle.model.isEmpty()) {
            return;
        }
        FSMExecutors.newBFS().setModel(bundle.model, false, (IProgressMonitor)monitor).addVisitor(new FSMVisitors.StateVisitor(){

            @Override
            public void visit(IFSMState state) {
                FSMDiagramImporter.this.createOrGetKnode((FSMState)state, bundle);
            }
        }).addVisitor(new FSMVisitors.TransitionVisitor(){

            @Override
            public void visit(IFSMTransition transition) {
                FSMDiagramImporter.this.createKEdge((FSMTransition)transition, bundle);
            }
        }).start();
    }

    private KNode createOrGetKnode(FSMState state, Bundle bundle) {
        if (state == null) {
            return null;
        }
        if (bundle.kNodes.containsKey(state)) {
            return bundle.kNodes.get(state);
        }
        KNode node = KimlUtil.createInitializedNode();
        bundle.kNodes.put(state, node);
        ++bundle.nofKNodes;
        state.setNode(node);
        node.getData().add((Object)KLayWrapper.of(state));
        if (this.config.contains(FSMDiagramConfiguration.FSMDiagramConfigurationKey.TOOLTIP)) {
            node.getData().add((Object)FSMTooltipDataWrapper.of(this.getTooltip(state)));
        }
        bundle.root.getChildren().add((Object)node);
        this.adapter.setKNodeInfo(node, state);
        return node;
    }

    private KEdge createKEdge(FSMTransition transition, Bundle bundle) {
        if (FSMUtils.isStartTransition(transition)) {
            return null;
        }
        KNode sourceNode = this.createOrGetKnode((FSMState)transition.getSource(), bundle);
        KNode destinationNode = this.createOrGetKnode((FSMState)transition.getDestination(), bundle);
        if (sourceNode == null || destinationNode == null) {
            return null;
        }
        KEdge edge = KimlUtil.createInitializedEdge();
        ++bundle.nofKEdges;
        transition.setEdge(edge);
        edge.getData().add((Object)KLayWrapper.of(transition));
        if (this.config.contains(FSMDiagramConfiguration.FSMDiagramConfigurationKey.TOOLTIP)) {
            edge.getData().add((Object)FSMTooltipDataWrapper.of(transition.getSourceInput().toString()));
        }
        FSMDiagramConfiguration.EnforceTransitionPortsOption enforcePorts = this.config.get(FSMDiagramConfiguration.FSMDiagramConfigurationKey.ENFORCE_TRANSITION_PORTS);
        edge.setSource(sourceNode);
        if (enforcePorts != FSMDiagramConfiguration.EnforceTransitionPortsOption.NONE) {
            KPort sourcePort = KimlUtil.createInitializedPort();
            sourceNode.getPorts().add((Object)sourcePort);
            edge.setSourcePort(sourcePort);
            this.adapter.setKPortInfo(sourcePort, String.valueOf(transition.toString()) + ".source", true);
            FSMDebugUtils.debugLevelThree("Created source port for transition " + transition, new Object[0]);
        }
        edge.setTarget(destinationNode);
        if (enforcePorts != FSMDiagramConfiguration.EnforceTransitionPortsOption.NONE) {
            KPort targetPort = KimlUtil.createInitializedPort();
            destinationNode.getPorts().add((Object)targetPort);
            edge.setTargetPort(targetPort);
            boolean isOutgoing = enforcePorts == FSMDiagramConfiguration.EnforceTransitionPortsOption.ALL_STATES_EXCEPT_INITIAL && FSMUtils.isStartState(transition.getDestination());
            this.adapter.setKPortInfo(targetPort, String.valueOf(transition.toString()) + ".target", isOutgoing);
            FSMDebugUtils.debugLevelThree("Created target port for transition " + transition, new Object[0]);
        }
        this.adapter.setKEdgeInfo(edge, transition);
        return edge;
    }

    public KNode createDummyRoot(KNode graph) {
        KNode dummyRoot = KimlUtil.createInitializedNode();
        if (graph != null) {
            dummyRoot.getChildren().add((Object)graph);
        }
        FSMRenderingUtils.renderDummyGate(dummyRoot);
        KShapeLayout dummyRootLayout = (KShapeLayout)dummyRoot.getData(KShapeLayout.class);
        dummyRootLayout.setProperty(LayoutOptions.EXPAND_NODES, (Object)true);
        dummyRootLayout.setProperty(LayoutOptions.HIERARCHY_HANDLING, (Object)HierarchyHandling.INCLUDE_CHILDREN);
        return dummyRoot;
    }

    private String getTooltip(FSMState state) {
        StringBuilder result = new StringBuilder();
        IRfNamedElement element = state.getElement();
        String name = state.getNiceID();
        String value = state.getID();
        String comment = "";
        if (element != null) {
            comment = element.getComment();
        }
        result.append(name);
        if (!name.equalsIgnoreCase(value)) {
            result.append(" = ").append(value);
        }
        if (comment != null && !comment.isEmpty()) {
            result.append("&#10;&#9;").append(comment);
        }
        return result.toString();
    }

    public static class Bundle {
        public final KNode root;
        public final Map<FSMState, KNode> kNodes;
        public final FSMModel model;
        public final DProgressMonitor monitor;
        public int nofKNodes;
        public int nofKEdges;

        private Bundle(KNode root, Map<FSMState, KNode> kNodes, FSMModel model, DProgressMonitor monitor) {
            this.root = root;
            this.kNodes = kNodes;
            this.model = model;
            this.monitor = monitor;
        }

        public static Bundle of(KNode root, Map<FSMState, KNode> kNodes, FSMModel model, DProgressMonitor monitor) {
            return new Bundle(root, kNodes, model, monitor);
        }
    }
}

