/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.diagrams.fsm.draw;

import de.cau.cs.kieler.core.kgraph.KEdge;
import de.cau.cs.kieler.core.kgraph.KGraphElement;
import de.cau.cs.kieler.core.kgraph.KLabel;
import de.cau.cs.kieler.core.kgraph.KLabeledGraphElement;
import de.cau.cs.kieler.core.kgraph.KNode;
import de.cau.cs.kieler.core.krendering.KBackground;
import de.cau.cs.kieler.core.krendering.KColor;
import de.cau.cs.kieler.core.krendering.KColoring;
import de.cau.cs.kieler.core.krendering.KEllipse;
import de.cau.cs.kieler.core.krendering.KFontBold;
import de.cau.cs.kieler.core.krendering.KFontItalic;
import de.cau.cs.kieler.core.krendering.KFontName;
import de.cau.cs.kieler.core.krendering.KFontSize;
import de.cau.cs.kieler.core.krendering.KForeground;
import de.cau.cs.kieler.core.krendering.KLineStyle;
import de.cau.cs.kieler.core.krendering.KLineWidth;
import de.cau.cs.kieler.core.krendering.KRendering;
import de.cau.cs.kieler.core.krendering.KRoundedRectangle;
import de.cau.cs.kieler.core.krendering.KStyle;
import de.cau.cs.kieler.core.krendering.KText;
import de.cau.cs.kieler.core.krendering.LineStyle;
import de.cau.cs.kieler.core.math.KVector;
import de.cau.cs.kieler.core.math.KVectorChain;
import de.cau.cs.kieler.kiml.klayoutdata.KEdgeLayout;
import de.cau.cs.kieler.kiml.klayoutdata.KShapeLayout;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import ro.amiq.dvt.diagrams.fsm.draw.obj.FSMDContainer;
import ro.amiq.dvt.diagrams.fsm.draw.obj.FSMDEdge;
import ro.amiq.dvt.diagrams.fsm.draw.obj.FSMDLabel;
import ro.amiq.dvt.diagrams.fsm.draw.obj.FSMDObject;
import ro.amiq.dvt.diagrams.fsm.draw.obj.FSMDScene;
import ro.amiq.dvt.diagrams.klay.rendering.styles.KSelectionBackground;
import ro.amiq.dvt.diagrams.klay.rendering.styles.KSelectionDriverAndLoadBackground;
import ro.amiq.dvt.diagrams.klay.rendering.styles.KSelectionDriverAndLoadForeground;
import ro.amiq.dvt.diagrams.klay.rendering.styles.KSelectionDriverAndLoadLineWidth;
import ro.amiq.dvt.diagrams.klay.rendering.styles.KSelectionDriverBackground;
import ro.amiq.dvt.diagrams.klay.rendering.styles.KSelectionDriverForeground;
import ro.amiq.dvt.diagrams.klay.rendering.styles.KSelectionDriverLineWidth;
import ro.amiq.dvt.diagrams.klay.rendering.styles.KSelectionForeground;
import ro.amiq.dvt.diagrams.klay.rendering.styles.KSelectionLineWidth;
import ro.amiq.dvt.diagrams.klay.rendering.styles.KSelectionLoadBackground;
import ro.amiq.dvt.diagrams.klay.rendering.styles.KSelectionLoadForeground;
import ro.amiq.dvt.diagrams.klay.rendering.styles.KSelectionLoadLineWidth;
import ro.amiq.dvt.draw.obj.utils.DProperties;
import ro.amiq.dvt.draw.obj.utils.RGBV;
import ro.amiq.dvt.draw.utils.ColorFactory;
import ro.amiq.dvt.draw.utils.FRectangle;
import ro.amiq.dvt.draw.utils.FontFactory;
import ro.amiq.dvt.wizards.specador.FSMTooltipDataWrapper;

public enum FSMDrawConverter {
    INSTANCE;

    private static final DProperties.Key<FRectangle> FLOAT_LAYOUT;
    private static final DProperties.Key<List<FSMDObject>> CHILDREN;

    static {
        FLOAT_LAYOUT = new DProperties.Key("FSMDrawConverter.FLOAT_LAYOUT");
        CHILDREN = new DProperties.Key("FSMDrawConverter.CHILDREN");
    }

    public FSMDScene convert(KNode kRoot) {
        KShapeLayout kLayout = (KShapeLayout)kRoot.getData(KShapeLayout.class);
        Rectangle bounds = new Rectangle(0, 0, Math.round(kLayout.getWidth()), Math.round(kLayout.getHeight()));
        FSMDScene dScene = new FSMDScene(kRoot, bounds);
        this.registerDObject(dScene, (KGraphElement)kRoot, null, dScene);
        dScene.setProperty(FLOAT_LAYOUT, new FRectangle(kLayout.getXpos(), kLayout.getYpos(), kLayout.getWidth(), kLayout.getHeight()));
        this.convertKNodes((List<KNode>)kRoot.getChildren(), dScene);
        this.forgeCHObjects(dScene);
        return dScene;
    }

    private void forgeCHObjects(FSMDObject dObject) {
        dObject.forge();
        List<FSMDObject> dChildren = dObject.getProperty(CHILDREN);
        dObject.removeProperty(CHILDREN);
        dObject.removeProperty(FLOAT_LAYOUT);
        if (dChildren != null) {
            dChildren.sort(FSMDObject.COMPARATOR);
            dObject.addChildren(dChildren);
            for (FSMDObject dChild : dChildren) {
                this.forgeCHObjects(dChild);
            }
        }
    }

    private void convertKNodes(List<KNode> kNodes, FSMDScene dScene) {
        for (KNode kNode : kNodes) {
            FSMDContainer dContainer = this.registerDObject(new FSMDContainer(), (KGraphElement)kNode, (KGraphElement)kNode.getParent(), dScene);
            this.setLayoutProperties((KGraphElement)kNode, (KGraphElement)kNode.getParent(), dContainer, dScene);
            this.setRenderingProperties((KGraphElement)kNode, dContainer);
            this.convertKNodes((List<KNode>)kNode.getChildren(), dScene);
            FSMTooltipDataWrapper data = (FSMTooltipDataWrapper)kNode.getData(FSMTooltipDataWrapper.class);
            this.convertKLabels((List<KLabel>)kNode.getLabels(), dScene, data);
            this.convertKEdges((List<KEdge>)kNode.getOutgoingEdges(), dScene);
        }
    }

    private void convertKEdges(List<KEdge> kEdges, FSMDScene dScene) {
        for (KEdge kEdge : kEdges) {
            KNode kContainerParent = this.findEdgeContainerParent(kEdge.getSource(), kEdge.getTarget());
            FSMDEdge dEdge = this.registerDObject(new FSMDEdge(), (KGraphElement)kEdge, (KGraphElement)kContainerParent, dScene);
            this.setRenderingProperties((KGraphElement)kEdge, dEdge);
            KNode kLayoutParent = this.findEdgeLayoutParent(kEdge.getSource(), kEdge.getTarget());
            FSMDObject dLayoutParent = dScene.getDObject(kLayoutParent);
            FRectangle floatLayout = dLayoutParent.getProperty(FLOAT_LAYOUT);
            dEdge.setProperty(FSMDEdge.ARROW_SIZE, Math.round(8.0f));
            KEdgeLayout kEdgeLayout = (KEdgeLayout)kEdge.getData(KEdgeLayout.class);
            ArrayList<Point> dBendingPoints = new ArrayList<Point>();
            KVectorChain kEdgePoints = kEdgeLayout.createVectorChain();
            for (KVector kPoint : kEdgePoints) {
                dBendingPoints.add(floatLayout.relativeRound((float)kPoint.x, (float)kPoint.y));
            }
            this.adjustEdge((Point)dBendingPoints.get(0), (Point)dBendingPoints.get(1), false);
            this.adjustEdge((Point)dBendingPoints.get(dBendingPoints.size() - 1), (Point)dBendingPoints.get(dBendingPoints.size() - 2), true);
            dEdge.setProperty(FSMDEdge.BENDING_POINTS, dBendingPoints);
            for (KLabel kLabel : kEdge.getLabels()) {
                FSMDLabel dLabel = this.registerDObject(new FSMDLabel.FSMDSelectableLabel(), (KGraphElement)kLabel, (KGraphElement)kLayoutParent, dScene);
                this.setLayoutProperties((KGraphElement)kLabel, (KGraphElement)kLayoutParent, dLabel, dScene);
                this.setRenderingProperties((KGraphElement)kLabel, dLabel);
                this.setTextProperties(kLabel, dLabel);
                StringBuilder label = new StringBuilder(kLabel.getText());
                FSMTooltipDataWrapper data = (FSMTooltipDataWrapper)kEdge.getData(FSMTooltipDataWrapper.class);
                if (data != null) {
                    label.append(data.getTooltip());
                }
                dLabel.setProperty(FSMDLabel.TEXT, label.toString());
            }
        }
    }

    private void adjustEdge(Point edgeP1, Point edgeP2, boolean hasArrow) {
        int diff;
        int n = diff = hasArrow ? 4 : 1;
        if (edgeP1.x - edgeP2.x == 0) {
            edgeP1.y += (diff *= edgeP1.y > edgeP2.y ? -1 : 1);
        } else if (edgeP1.y - edgeP2.y == 0) {
            edgeP1.x += (diff *= edgeP1.x > edgeP2.x ? -1 : 1);
        }
    }

    private KNode findEdgeContainerParent(KNode kNode1, KNode kNode2) {
        if (kNode1 == null || kNode2 == null) {
            return null;
        }
        if (kNode1.equals(kNode2)) {
            return kNode1;
        }
        HashSet<KNode> parents = new HashSet<KNode>();
        do {
            parents.add(kNode1);
        } while ((kNode1 = kNode1.getParent()) != null);
        do {
            if (!parents.contains(kNode2)) continue;
            return kNode2;
        } while ((kNode2 = kNode2.getParent()) != null);
        return null;
    }

    /*
     * Unable to fully structure code
     */
    private KNode findEdgeLayoutParent(KNode kNode1, KNode kNode2) {
        if (kNode1 == null || kNode2 == null) {
            return null;
        }
        if (!kNode1.equals(kNode2)) ** GOTO lbl7
        return kNode1.getParent();
lbl-1000:
        // 1 sources

        {
            if (!kNode1.equals(kNode2)) continue;
            return kNode1;
lbl7:
            // 2 sources

            ** while ((kNode2 = kNode2.getParent()) != null)
        }
lbl8:
        // 1 sources

        return kNode1.getParent();
    }

    private void convertKLabels(List<KLabel> kLables, FSMDScene dScene, FSMTooltipDataWrapper data) {
        for (KLabel kLabel : kLables) {
            KLabeledGraphElement kParent = kLabel.getParent();
            FSMDLabel dLabel = this.registerDObject(new FSMDLabel(), (KGraphElement)kLabel, (KGraphElement)kParent, dScene);
            this.setLayoutProperties((KGraphElement)kLabel, (KGraphElement)kLabel.getParent(), dLabel, dScene);
            this.setTextProperties(kLabel, dLabel);
            StringBuilder label = new StringBuilder(kLabel.getText());
            if (data != null) {
                label.append(data.getTooltip());
            }
            dLabel.setProperty(FSMDLabel.TEXT, label.toString());
        }
    }

    private void setTextProperties(KLabel kLabel, FSMDLabel dLabel) {
        KText kText = (KText)kLabel.getData(KText.class);
        String fontName = null;
        int fontSize = 0;
        int fontStyle = 0;
        EList styles = kText.getStyles();
        for (KStyle kStyle : styles) {
            if (kStyle instanceof KFontName) {
                fontName = ((KFontName)kStyle).getName();
                continue;
            }
            if (kStyle instanceof KFontSize) {
                fontSize = ((KFontSize)kStyle).getSize();
                continue;
            }
            if (kStyle instanceof KFontBold && ((KFontBold)kStyle).isBold()) {
                fontStyle |= 1;
                continue;
            }
            if (kStyle instanceof KFontItalic && ((KFontItalic)kStyle).isItalic()) {
                fontStyle |= 2;
                continue;
            }
            if (!(kStyle instanceof KForeground)) continue;
            dLabel.setProperty(FSMDObject.LINE_COLOR, this.convertKColoring((KColoring<?>)((KForeground)kStyle)));
        }
        dLabel.setProperty(FSMDLabel.FONT, FontFactory.getInstance().getFontData(fontName, fontSize, fontStyle));
    }

    private <T extends FSMDObject> T registerDObject(T dObject, KGraphElement kElement, KGraphElement kParent, FSMDScene dScene) {
        ((FSMDObject)dObject).setProperty(FSMDObject.KELEMENT, (KGraphElement)kElement);
        dScene.putDObject(kElement, (FSMDObject)dObject);
        FSMDObject dParent = dScene.getDObject(kParent);
        if (dParent != null) {
            List<FSMDObject> children = dParent.getProperty(CHILDREN);
            if (children == null) {
                children = new ArrayList<FSMDObject>();
                dParent.setProperty(CHILDREN, children);
            }
            children.add((FSMDObject)dObject);
        }
        return (T)dObject;
    }

    private void setLayoutProperties(KGraphElement kElement, KGraphElement kParent, FSMDObject dObject, FSMDScene dScene) {
        FSMDObject dParent = dScene.getDObject(kParent);
        FRectangle parentLayout = null;
        parentLayout = dParent == null ? new FRectangle(0.0f, 0.0f, 0.0f, 0.0f) : dParent.getProperty(FLOAT_LAYOUT);
        KShapeLayout kLayout = (KShapeLayout)kElement.getData(KShapeLayout.class);
        FRectangle currentLayout = parentLayout.relative(kLayout.getXpos(), kLayout.getYpos(), kLayout.getWidth(), kLayout.getHeight());
        dObject.setProperty(FLOAT_LAYOUT, currentLayout);
        dObject.setProperty(FSMDObject.LAYOUT, currentLayout.round());
    }

    private void setRenderingProperties(KGraphElement kElement, FSMDObject dObject) {
        KRendering kRendering = (KRendering)kElement.getData(KRendering.class);
        if (kRendering instanceof KEllipse) {
            dObject.setProperty(FSMDContainer.SHAPE, FSMDContainer.Shape.ELLIPSE);
        } else if (kRendering instanceof KRoundedRectangle) {
            dObject.setProperty(FSMDContainer.SHAPE, FSMDContainer.Shape.ROUNDED_RECTANGLE);
        }
        EList kStyles = kRendering.getStyles();
        for (KStyle kStyle : kStyles) {
            if (kStyle instanceof KSelectionBackground) {
                dObject.setProperty(FSMDObject.SELECTED_FILL_COLOR, this.convertKColoring((KSelectionBackground)kStyle));
                continue;
            }
            if (kStyle instanceof KSelectionDriverBackground) {
                dObject.setProperty(FSMDObject.SELECTED_DRIVER_FILL_COLOR, this.convertKColoring((KSelectionDriverBackground)kStyle));
                continue;
            }
            if (kStyle instanceof KSelectionLoadBackground) {
                dObject.setProperty(FSMDObject.SELECTED_LOAD_FILL_COLOR, this.convertKColoring((KSelectionLoadBackground)kStyle));
                continue;
            }
            if (kStyle instanceof KSelectionDriverAndLoadBackground) {
                dObject.setProperty(FSMDObject.SELECTED_DRIVER_AND_LOAD_FILL_COLOR, this.convertKColoring((KSelectionDriverAndLoadBackground)kStyle));
                continue;
            }
            if (kStyle instanceof KBackground) {
                dObject.setProperty(FSMDObject.FILL_COLOR, this.convertKColoring((KColoring<?>)((KBackground)kStyle)));
                continue;
            }
            if (kStyle instanceof KSelectionForeground) {
                dObject.setProperty(FSMDObject.SELECTED_LINE_COLOR, this.convertKColoring((KSelectionForeground)kStyle));
                continue;
            }
            if (kStyle instanceof KSelectionDriverForeground) {
                dObject.setProperty(FSMDObject.SELECTED_DRIVER_LINE_COLOR, this.convertKColoring((KSelectionDriverForeground)kStyle));
                continue;
            }
            if (kStyle instanceof KSelectionLoadForeground) {
                dObject.setProperty(FSMDObject.SELECTED_LOAD_LINE_COLOR, this.convertKColoring((KSelectionLoadForeground)kStyle));
                continue;
            }
            if (kStyle instanceof KSelectionDriverAndLoadForeground) {
                dObject.setProperty(FSMDObject.SELECTED_DRIVER_AND_LOAD_LINE_COLOR, this.convertKColoring((KSelectionDriverAndLoadForeground)kStyle));
                continue;
            }
            if (kStyle instanceof KForeground) {
                dObject.setProperty(FSMDObject.LINE_COLOR, this.convertKColoring((KColoring<?>)((KForeground)kStyle)));
                continue;
            }
            if (kStyle instanceof KSelectionLineWidth) {
                dObject.setProperty(FSMDObject.SELECTED_LINE_WIDTH, Math.round(((KSelectionLineWidth)kStyle).getLineWidth()));
                continue;
            }
            if (kStyle instanceof KSelectionDriverLineWidth) {
                dObject.setProperty(FSMDObject.SELECTED_DRIVER_LINE_WIDTH, Math.round(((KSelectionDriverLineWidth)kStyle).getLineWidth()));
                continue;
            }
            if (kStyle instanceof KSelectionLoadLineWidth) {
                dObject.setProperty(FSMDObject.SELECTED_LOAD_LINE_WIDTH, Math.round(((KSelectionLoadLineWidth)kStyle).getLineWidth()));
                continue;
            }
            if (kStyle instanceof KSelectionDriverAndLoadLineWidth) {
                dObject.setProperty(FSMDObject.SELECTED_DRIVER_AND_LOAD_LINE_WIDTH, Math.round(((KSelectionDriverAndLoadLineWidth)kStyle).getLineWidth()));
                continue;
            }
            if (kStyle instanceof KLineWidth) {
                dObject.setProperty(FSMDObject.LINE_WIDTH, Math.round(((KLineWidth)kStyle).getLineWidth()));
                continue;
            }
            if (!(kStyle instanceof KLineStyle)) continue;
            dObject.setProperty(FSMDObject.LINE_STYLE, this.convertKLineStyle(((KLineStyle)kStyle).getLineStyle()));
        }
    }

    private RGBV convertKColoring(KColoring<?> kColoring) {
        KColor color = kColoring.getColor();
        return ColorFactory.getInstance().getRGBV(color.getRed(), color.getGreen(), color.getBlue(), kColoring.getAlpha() > 0);
    }

    private int convertKLineStyle(LineStyle kStyle) {
        if (kStyle == LineStyle.SOLID) {
            return 1;
        }
        if (kStyle == LineStyle.DASH) {
            return 2;
        }
        if (kStyle == LineStyle.DASHDOT) {
            return 4;
        }
        if (kStyle == LineStyle.DASHDOTDOT) {
            return 5;
        }
        if (kStyle == LineStyle.DOT) {
            return 3;
        }
        return 1;
    }
}

